////////////////////////////////////////////////////////////////////////////////
//  Implementaion of scientific base class.                                   //  
//  LAST EDIT: Thu Aug 11 14:13:07 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//                      yart@prakinf.tu-ilmenau.de                            //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <scient/scient.h>

void rt_initScientCommands( Tcl_Interp *rt_Ip ) {
    rt_PackageList += "Scient ";
    // add Scientific to the package list
    rt_PrimitiveClassList += " {Scient {The classes for scientific visualisation} {";

    // the scientific commands:
    RTM_command( RTN_COORD, RT_Coord::classCMD );
    rt_PrimitiveClassList += RTN_COORD; rt_PrimitiveClassList += " ";
    RTM_command( RTN_2D_P_LATTICE, RT_2DPerimetricLattice::classCMD );
    rt_PrimitiveClassList += RTN_2D_P_LATTICE; rt_PrimitiveClassList += " ";
    RTM_command( RTN_2D_U_LATTICE, RT_2DUniformLattice::classCMD );
    rt_PrimitiveClassList += RTN_2D_U_LATTICE; rt_PrimitiveClassList += " ";
    RTM_command( RTN_2D_C_LATTICE, RT_2DCurvilinearLattice::classCMD );
    rt_PrimitiveClassList += RTN_2D_C_LATTICE; rt_PrimitiveClassList += " ";
    RTM_command( RTN_3D_U_LATTICE, RT_3DUniformLattice::classCMD );
    rt_PrimitiveClassList += RTN_3D_U_LATTICE; rt_PrimitiveClassList += " ";
    RTM_command( RTN_3D_P_LATTICE, RT_3DPerimetricLattice::classCMD );
    rt_PrimitiveClassList += RTN_3D_P_LATTICE; 

    rt_PrimitiveClassList += "}}";
}

int RT_Scientific::gmF, RT_Scientific::gmV, RT_Scientific::gmG;
int RT_Scientific::imF, RT_Scientific::imV, RT_Scientific::imG, RT_Scientific::ioF, RT_Scientific::cmF, RT_Scientific::cmG, RT_Scientific::ioG, RT_Scientific::ilG, RT_Scientific::izG, RT_Scientific::pmapG, RT_Scientific::inrG, RT_Scientific::imaxG, RT_Scientific::pmaxG, RT_Scientific::mmaxG, RT_Scientific::lpG , RT_Scientific::pscrF;
int RT_Scientific::ilF, RT_Scientific::pmapF, RT_Scientific::punmapF;
int RT_Scientific::izF, RT_Scientific::izV;
char *RT_Scientific::ilV, *RT_Scientific::pmapV, *RT_Scientific::punmapV, *RT_Scientific::cmV, *RT_Scientific::pscrV;
double RT_Scientific::ioV;

RT_ParseEntry RT_Scientific::table[] = {
    { "-gridmode", RTP_INTEGER, (char*)&gmV, &gmF, "Specify a new {ARG 1 Gridmode } for the scientific object. Possible values are (from zero) {ENUM 1 \"None Hollow Filled \"}.", RTPS_INTEGER },
    { "-isomode", RTP_INTEGER, (char*)&imV, &imF, "Specify a new {ARG 1 Isomode } for the scientific object. Possible values are (from zero) {ENUM 1 \"None Isolines Isoareas \"}.", RTPS_INTEGER },
    { "-isobase", RTP_INTEGER, (char*)&izV, &izF, "Specify a new {ARG 1 Isobase } for the scientific object. Isolines may be drawn planar, or with their real Z-values. Possible values for Isobase are (from zero) {ENUM 1 \"Planar RealZ \"}.", RTPS_INTEGER },
    { "-isolevel", RTP_STRING, (char*)&ilV, &ilF, "Specify the {ARG 1 Index}, {ARG 2 Level} and {ARG 3 Color} for an isoline.", RTPS_STRING },
    { "-isooffset", RTP_DOUBLE, (char*)&ioV, &ioF, "Specify an {ARG 1 Offset} for better visualisation of isolines.", RTPS_DOUBLE },
    { "-paramdescription", RTP_STRING, (char*)&pscrV, &pscrF, "Add to {ARG 1 ParameterNr} a {ARG 2 DescriptionString} for better identification and navigation.", RTPS_STRING },
    { "-map", RTP_STRING, (char*)&pmapV, &pmapF, "Specify for {ARG 1 Parameter} the {ARG 2 Mappingtype}. This type may be (from zero) {ENUM 1 \"none Z-map Color-map Iso-map \"}.", RTPS_STRING },
    { "-unmap", RTP_STRING, (char*)&punmapV, &punmapF, "Specify for {ARG 1 Parameter} {ARG 2 Mappingtype}.", RTPS_STRING },
    { "-hslmap", RTP_STRING, (char*)&cmV, &cmF, "Specify {ARG 1 HueMin}, {ARG 2 HueMax}, {ARG 3 Saturation}, {ARG 4 Value} for colormapping.", RTPS_STRING },
    { "-get_gridmode", RTP_NONE, 0, &gmG, "Get the gridmode.", RTPS_NONE },
    { "-get_isomode", RTP_NONE, 0, &imG, "Get the isomode.", RTPS_NONE },
    { "-get_isobase", RTP_NONE, 0, &izG, "Get the isobase mode.", RTPS_NONE },
    { "-get_isonr", RTP_NONE, 0, &inrG, "Get the number of used isolevels.", RTPS_NONE },
    { "-get_maxiso", RTP_NONE, 0, &imaxG, "Get the maximum number of isolines.", RTPS_NONE },
    { "-get_isolevels", RTP_NONE, 0, &ilG, "Get the isolevels.", RTPS_NONE },
    { "-get_isooffset", RTP_NONE, 0, &ioG, "Get the isooffset.", RTPS_NONE },
    { "-get_map", RTP_NONE, 0, &pmapG, "Get the mapping of parameters.", RTPS_NONE },
    { "-get_maxparams", RTP_NONE, 0, &pmaxG, "Get the maximum number of parameters per vertex.", RTPS_NONE },
    { "-get_loadedparams", RTP_NONE, 0, &lpG, "Get the list of loaded parameters with description.", RTPS_NONE },
    { "-get_maxmaps", RTP_NONE, 0, &mmaxG, "Get the maximum number of mapping types per parameter.", RTPS_NONE },
    { "-get_hslmap", RTP_NONE, 0, &cmG, "Get the colormapping.", RTPS_NONE },
    { NULL , RTP_END, NULL , NULL , NULL, NULL }
};

int RT_Scientific::objectCMD(char *argv[]) {
    int r = 0;
    if (RT_Primitive::objectCMD( argv )) r++;
    RT_parseTable( argv, table );
    if (gmF)  { gridmode( (RT_GridMode)gmV ); r++; }
    if (imF)  { isomode( (RT_IsoMode)imV ); r++; }
    if (izF)  { isobase( izV ); r++; }
    if (ilF) { 
	char **xargv; int xargc;
	double _level, _r, _g, _b;
	int _index;
	if ( Tcl_SplitList( rt_Ip, ilV, &xargc, &xargv) == TCL_OK) {
	    if ( xargc == 5 ) {
		RT_string2int( xargv[0], _index );
		RT_string2double( xargv[1], _level );
		RT_string2double( xargv[2], _r );
		RT_string2double( xargv[3], _g );
		RT_string2double( xargv[4], _b );
		isolevel( _index, _level, RT_Color( _r, _g, _b ));
		r++;
	    }
	    free((char*)xargv);
	}
    }
    if (pscrF) {
	char **xargv; int xargc;
	int _pnr;
	RT_String _descr;
	if ( Tcl_SplitList( rt_Ip, pscrV, &xargc, &xargv) == TCL_OK) {
	    if ( xargc == 2 ) {
		RT_string2int( xargv[0], _pnr );
		_descr = _descr + xargv[1];
		paramdescription( _pnr, _descr );
		r++;
	    }
	    free((char*)xargv);
	}
    }
    if (cmF) { 
	char **xargv; int xargc;
	double _hueMin, _hueMax, _sat, _val;
	if ( Tcl_SplitList( rt_Ip, cmV, &xargc, &xargv) == TCL_OK) {
	    if ( xargc == 4 ) {
		RT_string2double( xargv[0], _hueMin );
		RT_string2double( xargv[1], _hueMax );
		RT_string2double( xargv[2], _sat );
		RT_string2double( xargv[3], _val );
		hslmap( _hueMin, _hueMax, _sat, _val );
		r++;
	    }
	    free((char*)xargv);
	}
    }
    if (pmapF) { 
	char **xargv; int xargc;
	int pnr, pmt;
	if ( Tcl_SplitList( rt_Ip, pmapV, &xargc, &xargv) == TCL_OK) {
	    if ( xargc == 2 ) {
		RT_string2int( xargv[0], pnr );
		RT_string2int( xargv[1], pmt );
		map( pnr, (RT_MapType)pmt );
		r++;
	    }
	    free((char*)xargv);
	}
    }
    if (punmapF) { 
	char **xargv; int xargc;
	int pnr, pmt;
	if ( Tcl_SplitList( rt_Ip, punmapV, &xargc, &xargv) == TCL_OK) {
	    if ( xargc == 2 ) {
		RT_string2int( xargv[0], pnr );
		RT_string2int( xargv[1], pmt );
		unmap( pnr, (RT_MapType)pmt );
		r++;
	    }
	    free((char*)xargv);
	}
    }
    if (ioF)  { isooffset( ioV ); r++; }
    if (gmG) {
	r++; char tmp[30];
	RT_int2string( get_gridmode(), tmp ); RT_Object::result( tmp );
    }
    if (imG) {
	r++; char tmp[30];
	RT_int2string( get_isomode(), tmp ); RT_Object::result( tmp );
    }
    if (izG) {
	r++; char tmp[30];
	RT_int2string( get_isobase(), tmp ); RT_Object::result( tmp );
    }
    if (inrG) {
	r++; char tmp[30];
	RT_int2string( get_isonr(), tmp ); RT_Object::result( tmp );
    }
    if (imaxG) {
	r++; char tmp[30];
	RT_int2string( get_maxiso(), tmp ); RT_Object::result( tmp );
    }
    if (ioG) {
	r++; char tmp[30];
	RT_double2string( get_isooffset(), tmp ); RT_Object::result( tmp );
    }
    if (ilG) {
	r++; 
	char tmp[ MAXISO * 60]; char tmp2[60];
	tmp[0] = 0;
	int nr[MAXISO]; double lev[MAXISO]; RT_Color col[MAXISO];
	get_isolevels( nr, lev, col );
	for ( int i=0; i< get_isonr(); i++ ) {
	    sprintf( tmp2, "%i %lf %lf %lf %lf \n", nr[i], lev[i], col[i].r, col[i].g, col[i].b );
	    strcat( tmp, tmp2 );
	}
	RT_Object::result( tmp );
    }
    if (pmapG) {
	r++; 
	RT_String tmp, tmp2, tmp3;
	RT_MapType mt[ MAX_MAPS ];
	for ( int i=0; i<MAX_PARAM; i++ ) if (paramData[i].loaded) {
	    get_map( i, mt );
	    sprintf( (char*)tmp2, " %i ", i );
	    for ( int j=0; j<MAX_MAPS; j++ ) {
		sprintf( (char*)tmp3, " %i ", mt[j] );
		tmp2 = tmp2 + tmp3;
	    }
	    tmp = tmp + tmp2;
	    tmp = tmp + "\n";
	}
	RT_Object::result( tmp );
    }
    if (lpG) {
	r++;
	RT_String tmp, tmp2;
	for ( int i=0; i<MAX_PARAM; i++ ) if (paramData[i].loaded) {
	    sprintf( (char*)tmp2, " %i ", i );
	    tmp2 = tmp2 + paramData[i].description;
	    tmp2 = tmp2 + "\n";
	    tmp = tmp + tmp2;
	}
	RT_Object::result( tmp );
    }
    if (pmaxG) {
	r++; char tmp[30];
	RT_int2string( get_maxparams(), tmp ); RT_Object::result( tmp );
    }
    if (mmaxG) {
	r++; char tmp[30];
	RT_int2string( get_maxmaps(), tmp ); RT_Object::result( tmp );
    }
    if (cmG) {
	r++; char tmp[80];
	double hmin, hmax, val, sat;
	get_hslmap( &hmin, &hmax, &sat, &val );
	sprintf( tmp, " %lf %lf %lf %lf", hmin, hmax, sat, val );
	RT_Object::result( tmp );
    }
    return r;
}

void RT_Scientific::newParameters() {
    // allocate a new field for parameters according
    // to the values in dims 
    if (paramData[currParNr].params) delete paramData[currParNr].params;

    switch (paramData[currParNr].paramType) {
    case RTSC_DOUBLE: paramData[currParNr].dData = new double[ dims[0] * dims[1] * dims[2] * dims[3]];
	break; 
    case RTSC_INTEGER: paramData[currParNr].iData = new int[ dims[0] * dims[1] * dims[2] * dims[3]];
    case RTSC_FLOAT: paramData[currParNr].fData = new float[ dims[0] * dims[1] * dims[2] * dims[3]];
    case RTSC_CHAR: paramData[currParNr].cData = new char[ dims[0] * dims[1] * dims[2] * dims[3]];
	break;
    default : break;
    }
}

void RT_Scientific::destroyParams() {
    for ( int i=0; i<MAX_PARAM; i++ ) 
	if (paramData[i].params) delete paramData[i].params;
}

void RT_Scientific::map( int _pnr, RT_MapType _mt ) {
    if ( _pnr > MAX_PARAM ) {
	rt_Output->errorVar("Sorry, have not so many parameters. ", 0 );
	return;
    }
    if (_mt) {
	for ( int i=0; i<MAX_PARAM; i++ ) paramData[i].mappings[ _mt ] = NO_MAP;
	paramData[_pnr].mappings[ _mt ] = 1;
    } else {
	for ( int i=0; i<MAX_PARAM; i++ )
	    for ( int j=0; j<MAX_MAPS; j++ ) paramData[i].mappings[j] = NO_MAP;
    }
    geomChanged();
}

void RT_Scientific::get_map( int _pnr, RT_MapType *_mt ) {
    if ( (_pnr<0) || ( _pnr > MAX_PARAM) ) {
	rt_Output->errorVar("Sorry, have not so many parameters. ", 0 );
	return;
    }
    for ( int i=0; i<MAX_MAPS; i++ ) _mt[i] = (RT_MapType)paramData[_pnr].mappings[i];
}

void RT_Scientific::unmap( int _pnr, RT_MapType _mt ) {
    if ( (_pnr<0) || ( _pnr > MAX_PARAM) ) {
	rt_Output->errorVar("Sorry, have not so many parameters. ", 0 );
	return;
    }
    if (_mt) paramData[_pnr].mappings[ _mt ] = NO_MAP;
    geomChanged();
}

int RT_Scientific::isA(const char *_c)const {
    if (RTM_isA(_c, RTN_SCIENTIFIC )) return 1;
    return RT_Primitive::isA( _c );
}
