/*-
 * Copyright (c) 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 * Copyright (c) 1994, 1995
 *	Keith Bostic.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char sccsid[] = "@(#)svi_util.c	9.6 (Berkeley) 2/15/95";
#endif /* not lint */

#include <sys/types.h>
#include <sys/queue.h>
#include <sys/time.h>

#include <bitstring.h>
#include <errno.h>
#include <limits.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>

#include "compat.h"
#include <db.h>
#include <regex.h>

#include "vi.h"
#include "../vi/vcmd.h"
#include "excmd.h"
#include "svi_screen.h"
#include "../sex/sex_screen.h"

/*
 * svi_optchange --
 *	Svi screenspecific "option changed" routine.
 */
int
svi_optchange(sp, opt)
	SCR *sp;
	int opt;
{
	switch (opt) {
	case O_TERM:
#ifdef XXX_TK_XXX
		/* Toss any saved visual bell information. */
		if (SVP(sp)->VB != NULL) {
			FREE(SVP(sp)->VB, strlen(SVP(sp)->VB) + 1);
			SVP(sp)->VB = NULL;
		}
#endif
		break;
	case O_WINDOW:
		if (svi_crel(sp, O_VAL(sp, O_WINDOW)))
			return (1);
		break;
	}

	return (0);
}

/*
 * svi_crel --
 *	Change the relative size of the current screen.
 */
int
svi_crel(sp, count)
	SCR *sp;
	long count;
{
	/* Can't grow beyond the size of the window. */
	if (count > O_VAL(sp, O_WINDOW))
		count = O_VAL(sp, O_WINDOW);

	sp->t_minrows = sp->t_rows = count;
	if (sp->t_rows > sp->rows - 1)
		sp->t_minrows = sp->t_rows = sp->rows - 1;
	TMAP = HMAP + (sp->t_rows - 1);
	F_SET(sp, S_SCR_REDRAW);
	return (0);
}

/*
 * svi_busy --
 *	Put the cursor somewhere so the user will think we're busy.
 */
int
svi_busy(sp, msg)
	SCR *sp;
	char const *msg;
{
	SVI_PRIVATE *svp;

	svp = SVP(sp);
	(void)svp->scr_move(sp, RLNO(sp, INFOLINE(sp)), 0);
	if (msg) {
		(void)svp->scr_addstr(sp, msg);
		(void)svp->scr_clrtoeol(sp);
	}
	(void)svp->scr_refresh(sp);
	F_SET(svp, SVI_CUR_INVALID);
	return (0);
}

/*
 * svi_clrtoeos --
 *	Clear from the row down to the end of the screen.
 */
int
svi_clrtoeos(sp)
	SCR *sp;
{
	SVI_PRIVATE *svp;
	size_t oldy, oldx, row;

	svp = SVP(sp);
	(void)svp->scr_cursor(sp, &oldy, &oldx);
	for (row = svp->srows - 1; row >= oldy; --row) {
		(void)svp->scr_move(sp, row, 0);
		(void)svp->scr_clrtoeol(sp);
	}
	(void)svp->scr_move(sp, oldy, oldx);
	(void)svp->scr_refresh(sp);
	return (0);
}

/*
 * svi_message --
 *	Display a few common messages.
 */
void
svi_message(sp, p, which)
	SCR *sp;
	char *p;
	enum svimtype which;
{
	switch (which) {
	case SVIM_NOINIT:
		msgq(sp, M_ERR,
		    "270|%s command failed, screen not yet initialized", p);
		break;
	}
}
