diff -u --recursive --new-file jed-0.96.2/jed/changes.txt jed-0.96.3/jed/changes.txt
--- jed-0.96.2/jed/changes.txt	Fri Jun  3 05:37:04 1994
+++ jed-0.96.3/jed/changes.txt	Sun Jul 17 00:13:25 1994
@@ -1,4 +1,19 @@
 This file documents changes and new features found in JED
+Changes since 0.96-2: (By S.Herbert@shef.ac.uk - this is an UNOFFICIAL patch)
+
+    1. borland.sl/hlp added - mostly Borland IDE editor compatible now
+    2. META & ALT key support under X Windows fixed
+    3. Backspace and Delete support under X Windows fixed
+       (backspace is keycode 107 under X, and delete is keycode 22 - see
+       xjed.txt for more help)
+    4. ``Startup_String'' added, so different key bindings can display their
+       own message on startup.
+    5. Menu bar removed (one line change to windows.c)
+    6. Changed default colours in jed & xjed to suit people with black-
+       background terminals.
+    7. linux.sl fixed so the keybindings for home/end et al are available
+       from all consoles (con132x24 etc), not just TERM=console
+    
 Changes since 0.96-1:
 
     1. bug fix regarding regular expressions
diff -u --recursive --new-file jed-0.96.2/jed/doc/xjed.doc jed-0.96.3/jed/doc/xjed.doc
--- jed-0.96.2/jed/doc/xjed.doc	Thu Jun  2 22:51:29 1994
+++ jed-0.96.3/jed/doc/xjed.doc	Sun Jul 17 00:18:20 1994
@@ -1,5 +1,6 @@
 These are some notes about using xjed, the X Window version of JED.  It also
-mentions information about how to setup the EDT emulation under Linux.
+mentions information about how to setup the EDT emulation and the Borland IDE
+emulation under Linux.
 
 xjed recognizes the following resources:
 
@@ -123,6 +124,15 @@
 
 in the .Xmodmap file to enable EDT keypad emulation.
 
-Send comments and suggestions to davis@amy.tch.harvard.edu.
 
-   
+Borland IDE emuation under Linux.
+
+S.Herbert@sheffield.ac.uk (Stuart Herbert) strongly suggests putting
+
+	keycode 107 = Backspace
+	keycode 22  = Delete
+	
+in /usr/lib/X11/xinit/.Xmodmap.  The Slackware distribution for one comes
+with delete and backspace both acting as the same key.
+
+Send comments and suggestions to davis@amy.tch.harvard.edu.
diff -u --recursive --new-file jed-0.96.2/jed/lib/borland.hlp jed-0.96.3/jed/lib/borland.hlp
--- jed-0.96.2/jed/lib/borland.hlp	Thu Jan  1 00:00:00 1970
+++ jed-0.96.3/jed/lib/borland.hlp	Sat Jul 16 22:27:41 1994
@@ -0,0 +1,111 @@
+Linux Keybindings For JED - v1.0
+--------------------------------
+
+(Use ESC-W-X to switch to this window)
+
+This set of keybindings attempts to emulate the layout favoured by DOS-based
+editors such as Borland's IDE, or QEDIT, so that programmers used to DOS can
+feel equally at home on UNIX.
+
+Note that not everything has been implemented, partially due to the
+shortcomings of the UNIX keyboard mappings, partially because there are
+somethings which I've yet to find a use for, and partially because some of
+the IDE's capabilities go beyond what I can personally get JED to do (to be
+honest, I wouldn't be surprised if you could make JED do the lot - I am
+seriously impressed by this editor).
+
+These keybindings are based on the Wordstar emulation by JED's author, 
+John E. Davis.  I've added the missing move block :-), plus I've added the
+menus.  Please note that the function key setup works for me, using a UK
+keyboard map under Linux - you may need to alter things to suit your own
+operating system/keyboard map.  For those terminals which don't support
+function keys, you can use ESC-1..0 in place of F1..F10.
+
+Note that you can use ALT instead of ESC by default under JED - see your
+jed.rc file for more information about this.
+
+Stuart Herbert
+
+------------------------------------------------------------------------------
+Menu Option		How To Choose It
+------------------------------------------------------------------------------
+Main Menu						ESC-0		F10
+  File			ESC-F		ALT-F		ESC-0-F		F10-F
+  Edit			ESC-E		ALT-E		ESC-0-E		F10-E
+  Mode			ESC-M		ALT-M		ESC-0-M		F10-M
+  Search		ESC-S		ALT-S		ESC-0-S		F10-S
+  Compile		ESC-C		ALT-C		ESC-0-C		F10-C
+  Buffer		ESC-B		ALT-B		ESC-0-B		F10-B
+  Window		ESC-W		ALT-W		ESC-0-W		F10-W
+  Help			ESC-H		ALT-H		ESC-0-H		F1
+  System		ESC-Space	ALT-Space	ESC-0-Y		F10-Y
+
+File			ESC-F		ALT-F		ESC-0-F		F10-F
+  New			ESC-F-N		ALT-F-N
+  Open			ESC-F-O		ALT-F-O		ESC-3		F3
+  Save			ESC-F-S		ALT-F-S		ESC-2		F2
+  Save As		ESC-F-A		ALT-F-A
+  Save All		ESC-F-L		ALT-F-L
+  Shell			ESC-F-H		ALT-F-H
+  Quit			ESC-F-Q		ALT-F-Q		ESC-X		ALT-X
+  
+Edit			ESC-E		ALT-E		ESC-0-E		F10-E
+  Undo			ESC-E-U		ALT-E-U
+* Redo			ESC-E-R		ALT-E-R
+  Cut			ESC-E-T		ALT-E-T		^KY
+  Copy			ESC-E-C		ALT-E-C		^KC
+  Paste			ESC-E-P		ALT-E-P		^KI		^P
+  Clear			ESC-E-E		ALT-E-E
+  Show Clipboard	ESC-E-S		ALT-E-S
+
+Mode			ESC-M		ALT-M		ESC-0-M		F10-M
+  None			ESC-M-0		ALT-M-0
+  Text			ESC-M-1		ALT-M-1
+  C			ESC-M-2		ALT-M-2
+  Fortran		ESC-M-3		ALT-M-3
+  SLang			ESC-M-4		ALT-M-4
+  TeX			ESC-M-5		ALT-M-5
+
+Search			ESC-S		ALT-S		ESC-0-S		F10-S
+  Find			ESC-S-F		ALT-S-F		^QF
+  Replace		ESC-S-R		ALT-S-R		^QA
+  Search Again		ESC-S-S		ALT-S-S		^L
+  Goto Line Number	ESC-S-G		ALT-S-G
+
+Compile			ESC-C		ALT-C		ESC-0-C		F10-C
++ Compile		ESC-C-C		ALT-C-C				F9
+* Make			ESC-C-M		ALT-C-M
+* Link			ESC-C-L		ALT-C-L
+* Build All		ESC-C-B		ALT-C-B
+* Information		ESC-C-I		ALT-C-I
+
+Buffer			ESC-B		ALT-B		ESC-0-B		F10-B
+  Insert		ESC-B-I		ALT-B-I
+  List			ESC-B-L		ALT-B-L
+  Switch To		ESC-B-S		ALT-B-S
+  Close			ESC-B-C		ALT-B-C
+
+Window			ESC-W		ALT-W		ESC-0-W		F10-W
+  New			ESC-W-N		ALT-W-N
+  Next			ESC-W-X		ALT-W-X				F6
+  Close This		ESC-W-C		ALT-W-C
+  Close Others		ESC-W-L		ALT-W-L
+  
+Help			ESC-H		ALT-H		ESC-0-H		F1
+  Info			ESC-H-I		ALT-H-I
+  Man			ESC-H-M		ALT-H-M
+  Keys			ESC-H-K		ALT-H-K
+  Function		ESC-H-F		ALT-H-F
+  
+System			ESC-Space	ALT-Space	ESC-0-Y		F10-Y
+  Repaint		ESC-Space-R	ALT-Space-R
+  Ispell		ESC-Space-I	ALT-Space-I
+  Mail			ESC-Space-M	ALT-Space-M
+  Calendar		ESC-Space-C	ALT-Space-C
+  Function		ESC-Space-F	ALT-Space-F
+  
+------------------------------------------------------------------------------
+* : Function is not implemented, but a keybinding exists, because I'm
+    likely to implement this in the future.
++ : F9 normally goes for `make', but `make' is not implemented yet.
+------------------------------------------------------------------------------
diff -u --recursive --new-file jed-0.96.2/jed/lib/borland.sl jed-0.96.3/jed/lib/borland.sl
--- jed-0.96.2/jed/lib/borland.sl	Thu Jan  1 00:00:00 1970
+++ jed-0.96.3/jed/lib/borland.sl	Sun Jul 17 00:20:49 1994
@@ -0,0 +1,507 @@
+% PC-Developer Support For JED
+% Version 1.0 By Stuart Herbert
+% Based on files by John E. Davis
+%
+% This file should set JED up so that those used to such classic editors
+% as QEDIT or Borland's IDE will feel instantly at home.  I am NOT aiming
+% for 100% compatability here, as this isn't possible in UNIX environments.
+% Key-bindings are taken from "User's Guide - Borland C++ 3.1", by
+% Borland International.
+%
+% Note: I have altered the contents of menus, where appropriate, from the
+% Borland IDE to reflect the way JED works.  There is a lot which JED can
+% do, which I've tried to tap into ...
+%
+% I wrote this on Linux, and as a result, it may not work well on other
+% environments.  As I no longer have net access, I'm afraid someone else
+% will have to clean it up.
+%
+% Note that CUA compliancy isn't attempted either - everyone I know who
+% uses Borland editors use the Wordstar-influenced keybindings ...
+%
+% Put the line: "evalfile ("borland.sl"); pop ();" in your jed.rc startup file.
+
+Help_File = "borland.hlp";
+startup_string = "Welcome to JED.  Press F10 (ESC-0) for menus, or ESC-H for help.";
+
+set_status_line (" F1: Help | %b (%m%n) | %c %p | %t ", 1);
+
+set_abort_char (30);    % ^^ (Control 6 on most keyboards)
+% Note, the above command BREAKS ^G emacs abort.
+
+% This allows ^S and ^Q to work :-)
+enable_flow_control(0);
+
+unsetkey("^K");
+unsetkey("^X");
+unsetkey("^W");
+unsetkey("^F");
+unsetkey("^[F");
+unsetkey("^[D");
+unsetkey("^[0");
+unsetkey("^[1");
+unsetkey("^[2");
+unsetkey("^[3");
+unsetkey("^[4");
+unsetkey("^[5");
+unsetkey("^[6");
+unsetkey("^[7");
+unsetkey("^[8");
+unsetkey("^[9");
+
+%
+% Function keys
+%
+
+setkey ("pcdev_help_menu", Key_F1);	% F1  - help
+setkey ("pcdev_help_menu", "^[1");
+setkey ("save_buffer"    , Key_F2);	% F2  - save
+setkey ("save_buffer"    , "^[2");
+setkey ("open_file"      , Key_F3);	% F3  - open file
+setkey ("open_file"      , "^[3");
+setkey ("not_implemented", Key_F4);	% F4  - run program to cursor
+setkey ("not_implemented", "^[4");
+setkey ("one_window"     , Key_F5);	% F5  - zoom window
+setkey ("one_window"     , "^[5");
+setkey ("other_window"   , Key_F6);	% F6  - next window
+setkey ("other_window"   , "^[6");
+setkey ("not_implemented", Key_F7);	% F7  - trace into
+setkey ("not_implemented", "^[7");
+setkey ("not_implemented", Key_F8);	% F8  - step over
+setkey ("not_implemented", "^[8");
+setkey ("compile"	 , Key_F9);	% F9  - compile/make
+setkey ("compile"        , "^[9");
+setkey ("pcdev_menu"     , Key_F10);	% F10 - menu
+setkey ("pcdev_menu"     , "^[0");
+%
+% menu shortcut bindings
+%
+
+setkey ("pcdev_system_menu",  "^[ ");	% Alt-Space - system menu
+setkey ("pcdev_buffer_menu",  "^[B");	% Alt-B     - buffer menu
+setkey ("pcdev_compile_menu", "^[C");	% Alt-C     - compile menu
+setkey ("not_implemented",    "^[D");	% Alt-D     - debug menu
+setkey ("pcdev_edit_menu",    "^[E");	% Alt-E     - edit menu
+setkey ("pcdev_file_menu",    "^[F");	% Alt-F     - file menu
+setkey ("pcdev_help_menu",    "^[H");	% Alt-H     - help menu
+setkey ("pcdev_mode_menu",    "^[M");   % Alt-M     - mode menu
+setkey ("not_implemented",    "^[O");	% Alt-O     - options menu
+setkey ("not_implemented",    "^[P");	% Alt-P     - project menu
+setkey ("not_implemented",    "^[R");	% Alt-R     - run menu
+setkey ("pcdev_search_menu",  "^[S");	% Alt-S     - search menu
+setkey ("pcdev_window_menu",  "^[W");	% Alt-W     - window menu
+
+setkey ("exit_jed",           "^[X");	% Alt-X     - we've had enough :-)
+
+%
+% These key bindings come historically from Wordstar, and were implemented
+% by John
+%
+
+setkey ("ws_insert_block",      "^P");
+setkey ("next_char_cmd",        "^D");
+setkey ("previous_char_cmd",    "^S");
+#ifndef XWINDOWS
+  setkey ("previous_line_cmd",    "^E");
+#endif
+setkey ("next_line_cmd",        "^X");
+setkey ("page_up",              "^R");
+setkey ("page_down",            "^C");
+setkey ("skip_word",            "^F");
+setkey ("bskip_word",           "^A");
+setkey ("delete_char_cmd",      "^G");
+setkey ("delete_word",          "^T");
+setkey ("delete_line",          "^Y");
+setkey ("ws_repeat_search",     "^L");
+setkey ("ws_window_up",         "^W");
+setkey ("ws_window_down",       "^Z");
+%
+% Control-Q keys
+%
+setkey ("eol",                  "^Q^D");
+setkey ("eol",                  "^QD");
+setkey ("bol",                  "^Q^S");
+setkey ("bol",                  "^QS");
+setkey ("bob",                  "^Q^R");
+setkey ("bob",                  "^QR");
+setkey ("eob",                  "^Q^C");
+setkey ("eob",                  "^QC");
+setkey ("search_forward",       "^Q^F");
+setkey ("search_forward",       "^QF");
+setkey ("replace_cmd",          "^Q^A");
+setkey ("replace_cmd",          "^QA");
+setkey ("kill_line",            "^Q^Y");
+setkey ("kill_line",            "^QY");
+setkey ("goto_top_of_window",   "^QE");
+setkey ("goto_top_of_window",   "^Q^E");
+setkey ("goto_bottom_of_window","^Q^X");
+setkey ("goto_bottom_of_window","^QX");
+%
+% Control-K map
+%
+%setkey ("ws_begin_block",       "^K^B");
+%setkey ("ws_begin_block",       "^KB");
+%setkey ("ws_end_block",         "^K^K");
+%setkey ("ws_end_block",         "^KK");
+%setkey ("ws_delete_block",      "^K^Y");
+%setkey ("ws_delete_block",      "^KY");
+%setkey ("ws_copy_block",        "^K^C");
+%setkey ("ws_copy_block",        "^KC");
+%setkey ("ws_move_block",	"^K^V");
+%setkey ("ws_move_block",	"^KV");
+%setkey ("insert_file",          "^K^R");
+%setkey ("insert_file",          "^KR");
+%setkey ("save_buffer",          "^K^S");
+%setkey ("save_buffer",          "^KS");
+%setkey ("exit_jed",             "^K^Q");
+%setkey ("exit_jed",             "^KQ");
+%setkey ("ws_exit_jed",          "^K^D");
+%setkey ("ws_exit_jed",          "^KD");
+setkey ("ctrl_k_menu",           "^K");
+
+%
+% These are John's routines, taken from wordstar.sl ...
+% 
+
+define ws_window_up () 
+{
+   recenter (window_line() + 1);
+}
+
+define ws_window_down ()
+{
+   recenter (window_line() + 1);
+}
+
+define ws_repeat_search ()
+{
+   go_right (1);
+   !if (fsearch(LAST_SEARCH)) error ("Not found.");
+}
+
+% the blocks are very different.  Here we cheat.  Two marks are pushed--
+% One at beginning of block and one at end.  Assumption is that the spots
+% we see are the ones we put.
+
+variable WS_Mark_Pushed = 0;
+
+define ws_begin_block ()
+{
+   loop (WS_Mark_Pushed) pop_mark (0);
+   WS_Mark_Pushed = 1;
+   push_mark(); push_mark ();
+   call ("set_mark_cmd");
+   message ("Begin Block.");
+}
+
+% copies block to internal buffer-- preserves block
+variable WS_Block_Buffer = " *ws-clipboard*";
+
+define ws_show_clipboard ()
+{
+  setbuf(WS_Block_Buffer);
+  pop2buf(whatbuf());
+}
+
+define ws_copy_block_to_buffer ()
+{
+   if (WS_Mark_Pushed < 2) error ("Block Not defined.");
+   push_spot ();
+   pop_mark (1); % end of block
+   dupmark(); pop();  % dup beginning because we want to keep it
+   whatbuf ();
+   setbuf (WS_Block_Buffer); erase_buffer ();
+   setbuf(());
+   copy_region (WS_Block_Buffer);
+   push_mark ();
+   pop_spot ();
+}
+
+define ws_end_block ()
+{
+   if (WS_Mark_Pushed != 1)
+     {
+	loop (WS_Mark_Pushed) pop_mark(0); 
+	WS_Mark_Pushed = 0;
+	error ("Begin Block First!");
+     }
+   
+   !if (markp()) 
+     {
+	WS_Mark_Pushed = 0;
+	error ("Wordstar Error.");
+     }
+   
+   WS_Mark_Pushed = 2;
+   pop_mark (0);           % pops visible mark from begin block
+   push_mark ();
+   ws_copy_block_to_buffer ();
+   message ("Block Defined.");
+}
+
+define ws_clear_block ()
+{
+  pop_mark (0);
+  message ("Block Undefined.");
+}
+
+define ws_delete_block ()
+{
+   ws_copy_block_to_buffer ();
+   pop_mark (1); del_region ();
+}
+
+define ws_copy_block ()
+{
+   ws_copy_block_to_buffer ();
+   insbuf (WS_Block_Buffer);
+   message ("Block Copied.");
+}
+
+define ws_exit_jed ()
+{
+   save_buffer ();
+   exit_jed ();
+}
+
+define ws_insert_block ()
+{
+   if (bufferp(WS_Block_Buffer)) insbuf (WS_Block_Buffer);
+}
+
+define ws_move_block ()
+{
+  ws_copy_block_to_buffer ();
+  ws_insert_block ();
+  ws_delete_block ();
+  message ("Block Moved.");
+}
+
+%
+% end of functions taken from John's Wordstar emulation
+%
+
+define open_file ()
+{
+  variable file;
+  
+  file = read_file_from_mini("Filename:");
+  !if (strlen(extract_filename(file)))
+  {
+    dired;
+    return;
+  }
+  !if (find_file (file)) message ("New file.");
+  pop2buf(whatbuf());
+}
+
+variable new_buffer = 1;
+
+define new_file ()
+{
+  variable bufname = "*noname.";
+  
+  bufname = strcat (bufname,string(new_buffer));
+  bufname = strcat (bufname,"*");
+  new_buffer++;
+  
+  setbuf(bufname);
+  erase_buffer();
+  set_buffer_modified_flag(0);
+  pop2buf(whatbuf());
+}
+
+define not_implemented ()
+{
+  flush ("Not implemented.  Feel free to add this function yourself if you require it.");
+}
+
+%
+% here we have the menus for the PC Development environment
+% this is a quick and dirty hack, based on routines in site.sl
+%
+
+% this is a nasty hack which clears the menu line
+define clear_menu ()
+{
+  flush ("  ");
+}
+
+% the place to put stuff that doesn't belong anywhere else
+define pcdev_system_menu ()
+{
+  variable c;
+  
+  flush ("Menu : (R)epaint  (I)spell  (M)ail  (C)alendar  (F)unction");
+  c = int (strup(char(getkey())));
+  switch (c)
+    { case 'R' : call ("redraw") }
+    { case 'I' : ispell          }
+    { case 'M' : mail            }
+    { case 'C' : calendar        }
+    { case 'F' : emacs_escape_x  }
+    { pop(); clear_menu; }
+}
+
+define pcdev_file_menu ()
+{
+  variable c;
+  
+  flush ("Menu : (N)ew  (O)pen  (S)ave  S(a)ve As  Save A(l)l  (I)nsert  S(h)ell  (Q)uit");
+  c = int (strup(char(getkey())));
+  switch (c)
+    { case 'N' : new_file             }
+    { case 'O' : open_file            }
+    { case 'S' : save_buffer          }
+    { case 'A' : call("write_buffer") }
+    { case 'L' : save_buffers         }
+    { case 'I' : call("insert_file")  }
+    { case 'H' : shell                }
+    { case 'Q' : exit_jed             }
+    { pop(); clear_menu(); }
+}
+
+define pcdev_edit_menu ()
+{
+  variable c;
+  
+  flush ("Menu : (U)ndo  (R)edo  Cu(t)  (C)opy  (P)aste  C(l)ear  (S)how Clipboard  C(e)ntre");
+  c = int (strup(char(getkey())));
+  switch (c)
+    { case 'U' : call ("undo")     }
+    { case 'R' : not_implemented   }
+    { case 'T' : ws_delete_block   }
+    { case 'C' : ws_copy_block     }
+    { case 'P' : ws_insert_block   }
+    { case 'L' : ws_clear_block    }
+    { case 'S' : ws_show_clipboard }
+    { case 'E' : call("center_line")       }
+    { pop(); clear_menu(); }
+}
+
+define pcdev_search_menu ()
+{
+  variable c;
+  
+  flush ("Menu : (F)ind  (R)eplace  (S)earch Again  (G)oto Line");
+  c = int (strup(char(getkey())));
+  switch (c)
+    { case 'F' : search_forward   }
+    { case 'R' : replace_cmd      }
+    { case 'S' : ws_repeat_search }
+    { case 'G' : goto_line_cmd    }
+    { pop(); clear_menu(); }
+}
+
+define pcdev_compile_menu ()
+{
+  variable c;
+  
+  flush ("Menu : (C)ompile  (M)ake  (L)ink  (B)uild All  (I)nformation");
+  c = int (strup(char(getkey())));
+  switch (c)
+    { case 'C' : compile         }
+    { case 'M' : not_implemented }
+    { case 'L' : not_implemented }
+    { case 'B' : not_implemented }
+    { case 'I' : not_implemented }
+    { pop(); clear_menu(); }
+}
+
+define pcdev_buffer_menu ()
+{
+  variable c;
+  
+  flush ("Menu : (I)nsert  (L)ist  (S)witch To  (C)lose");
+  c = int (strup(char(getkey())));
+  switch(c)
+    { case 'I' : call("insert_buffer")    }
+    { case 'L' : list_buffers             }
+    { case 'S' : call("switch_to_buffer") }
+    { case 'C' : call("kill_buffer")      }
+    { pop(); clear_menu(); }
+}
+
+define pcdev_window_menu ()
+{
+  variable c;
+  
+  flush ("Menu : (N)ew  Ne(x)t  (C)lose This  C(l)ose Others");
+  c = int (strup(char(getkey())));
+  switch (c)
+    { case 'N' : call ("split_window")  }
+    { case 'X' : call ("other_window")  }
+    { case 'C' : call ("delete_window") }
+    { case 'L' : call ("one_window")    }
+    { pop() }
+  clear_menu();
+}
+
+define pcdev_help_menu ()
+{
+  variable c;
+  
+  flush ("Menu : (I)nfo  (M)an  (K)eys  (F)unctions");
+  c = int (strup(char(getkey())));
+  switch (c)
+    { case 'I' : info              }
+    { case 'M' : unix_man          }
+    { case 'K' : describe_bindings }
+    { case 'F' : describe_function }
+    { pop(); clear_menu(); }
+}
+
+define pcdev_mode_menu ()
+{
+  variable c;
+  
+  flush ("Menu : (0)None  (1)Text  (2)C  (3)Fortran  (4)SLang  (5)TeX");
+  c = int (strup(char(getkey())));
+  switch (c)
+    { case '0' : no_mode    }
+    { case '1' : text_mode  }
+    { case '2' : c_mode     }
+    { case '3' : fortran    }
+    { case '4' : slang_mode }
+    { case '5' : tex_mode   }
+    { pop() }
+  clear_menu();
+}
+
+define pcdev_menu ()
+{
+  variable c;
+  
+  flush ("Menu: (F)ile (E)dit (M)ode (S)earch (C)ompile (B)uffer (W)indow (H)elp S(y)stem");
+  c = int (strup(char(getkey())));
+  switch (c)
+    { case 'F' : pcdev_file_menu    }
+    { case 'E' : pcdev_edit_menu    }
+    { case 'M' : pcdev_mode_menu    }
+    { case 'S' : pcdev_search_menu  }
+    { case 'C' : pcdev_compile_menu }
+    { case 'B' : pcdev_buffer_menu  }
+    { case 'W' : pcdev_window_menu  }
+    { case 'H' : pcdev_help_menu    }
+    { case 'Y' : pcdev_system_menu  }
+    { pop(); clear_menu(); }
+}
+
+define ctrl_k_menu ()
+{
+  variable c;
+  
+  flush ("Menu : (B)egin/(K)End/(Y)Delete/(C)opy/(V)Move Block  (R)Insert/(S)ave File");
+  c = int (strup(char(getkey())));
+  switch (c)
+    { case 'B' : ws_begin_block  }
+    { case 'K' : ws_end_block    }
+    { case 'Y' : ws_delete_block }
+    { case 'C' : ws_copy_block   }
+    { case 'V' : ws_move_block   }
+    { case 'R' : insert_file     }
+    { case 'S' : save_buffer     }
+    { case 'Q' : exit_jed        }
+    { case 'D' : ws_exit_jed     }
+    { pop(); clear_menu(); }
+}
diff -u --recursive --new-file jed-0.96.2/jed/lib/defaults.sl jed-0.96.3/jed/lib/defaults.sl
--- jed-0.96.2/jed/lib/defaults.sl	Thu Jan  1 00:00:00 1970
+++ jed-0.96.3/jed/lib/defaults.sl	Sat Jul 16 22:27:42 1994
@@ -0,0 +1 @@
+evalfile("linux"); pop();
diff -u --recursive --new-file jed-0.96.2/jed/lib/jed.rc jed-0.96.3/jed/lib/jed.rc
--- jed-0.96.2/jed/lib/jed.rc	Thu Jun  2 22:51:33 1994
+++ jed-0.96.3/jed/lib/jed.rc	Sat Jul 16 22:27:44 1994
@@ -27,21 +27,22 @@
 %    uncomment Wordstar line.
 %
 
-   evalfile("emacs"); pop();           % Emacs-like bindings
+%   evalfile("emacs"); pop();           % Emacs-like bindings
 #ifndef MSDOS OS2
-   evalfile("edt"); pop();             % EDT--- Unix and VMS
+%   evalfile("edt"); pop();             % EDT--- Unix and VMS
 #else
-%      evalfile("edt"); pop();         % EDT--- IBMPC
+%      evalfile("edt"); pop();          % EDT--- IBMPC
 #endif
 
-%     evalfile("wordstar"); pop();     % Wordstar
+%     evalfile("wordstar"); pop();      % Wordstar
+      evalfile("borland");  pop();      % Borland-like key bindings
    
 %----------------------------------------------------------------------
 %
 %   TAB key setting  -- by default, the tab key is bound to 'indent_line_cmd'.
 %                       If you want a real tab inserted, uncomment next line.
 %
-%   setkey("self_insert_cmd", "^I");
+   setkey("self_insert_cmd", "^I");
    
 %----------------------------------------------------------------------
 %  
@@ -57,12 +58,12 @@
 % JED global variables  --- defaults shown
 %
 #ifdef VMS UNIX
-%USE_ANSI_COLORS = 1;   % if non-zero, JED will display colors on a color
+USE_ANSI_COLORS = 1;   % if non-zero, JED will display colors on a color
                         % terminal (Unix and VMS only) See doc/color.txt 
                         % for more discussion and look below for setting
                         % the colors.
 #endif
-Startup_With_File = 1;  % if greater then zero, force JED to prompt for a file
+Startup_With_File = -1; % if greater then zero, force JED to prompt for a file
                         %   if none is specified on the command line.  If 
                         %   negative, inhibit startup message.
 DISPLAY_TIME    = 1;    % non-zero enables the time to be displayed on 
@@ -73,7 +74,7 @@
                         % Highlight syntax in C mode.  See section on colors
                         %  below for choosing how to highlight.  On Unix and 
                         %  VMS systems, USE_ANSI_COLORS must also be non-zero.
-HORIZONTAL_PAN	= 20;	% if zero, no automatic panning.  If positive, only
+HORIZONTAL_PAN	= -1;	% if zero, no automatic panning.  If positive, only
                         % the current line is panned.  If negative, pan window.
 #ifdef MSDOS		% For msdos, panning window might be better:
   HORIZONTAL_PAN  = -1;
@@ -82,7 +83,7 @@
 #ifdef MSDOS
   LINENUMBERS	= 2;	% A value of zero means do NOT display line number on 
 #else                   % status line line.  A value of 1, means to display
-  LINENUMBERS	= 1;	% the linenumber. A value greater than 1 will also
+  LINENUMBERS	= 2;	% the linenumber. A value greater than 1 will also
 #endif			% display column number information.  I recommend a 
 			% value of 2 only at high baud rates
 
@@ -90,9 +91,9 @@
 TAB_DEFAULT	= 8;	% Tab size  (also try edit_tab_stops)
 WRAP		= 78;	% wrap column
 ADD_NEWLINE	= 1;	% add newline to file when writing if one not present
-IGNORE_BEEP	= 0;	% If non zero, to not beep terminal during error msgs.
+IGNORE_BEEP	= 1;	% If non zero, to not beep terminal during error msgs.
 _traceback	= 0;	% Non zero means dump traceback on S-Lang errors
-WRAP_INDENTS	= 0;	% Non zero indents next line after wrapping current.
+WRAP_INDENTS	= 1;	% Non zero indents next line after wrapping current.
 			%  Make this a 1 if you want indented text mode.
 KILL_LINE_FEATURE = 1;
 			% If non-zero, kill line will kill through end of the 
@@ -117,9 +118,9 @@
 
 %                           C-mode variables:
 
-C_INDENT	= 3;	% amount of space to indent within block.
-C_BRACE		= 2;	% amount of space to indent brace
-C_BRA_NEWLINE   = 0;    % If non-zero, insert a newline first before inserting
+C_INDENT	= 2;	% amount of space to indent within block.
+C_BRACE		= 0;	% amount of space to indent brace
+C_BRA_NEWLINE   = 1;    % If non-zero, insert a newline first before inserting
                         % a '{'.  Many C programmers like this to be 0. A zero
 			% value will force '{' to be on same line as insertion.
 				
@@ -176,17 +177,17 @@
 %  reprogram the controller so that high intensity background colors may be
 %  displayed.  There does not seem to be a way to do this in MS-Kermit.
 
-   $1 = "black"; $2 = "white";
+   $1 = "lightgray"; $2 = "black";
    set_color("normal", $1, $2);
    set_color("status", "yellow", "blue");
-   set_color("region", "yellow", "brightmagenta");
-   set_color("operator", $1, $2);      % +, -, etc..
-   set_color("number", "brightblue", $2);    % 10, 2.71, etc..
-   set_color("comment", "magenta", "brightcyan");% /* comment */
-   set_color("string", "brightblue", $2);    % "string" or 'char'
-   set_color("keyword", "brightred", $2);    % if, while, unsigned, ...
-   set_color("delimeter", $1, $2);     % {}[](),.;...
-   set_color("preprocess", "magenta", $2); % #ifdef ....
+   set_color("region", "black", "lightgray");
+   set_color("operator", "yellow", $2);      	% +, -, etc..
+   set_color("number", "brightcyan", $2);    	% 10, 2.71, etc..
+   set_color("comment", "gray", $2);		% /* comment */
+   set_color("string", "brightcyan", $2);    	% "string" or 'char'
+   set_color("keyword", "brightgreen", $2);    	% if, while, unsigned, ...
+   set_color("delimeter", "yellow", $2);     	% {}[](),.;...
+   set_color("preprocess", "brightblue", $2); 	% #ifdef ....
 
 #ifdef UNIX VMS
 if (USE_ANSI_COLORS) call ("redraw");
@@ -207,7 +208,7 @@
 %  and it is more than a vt100, either set your TERM variable appropriately
 %  or add vt100 to the list below. 
 %  
-  $1 = "vt102 vt200 vt220 vt300 vt320 vt420 xterms";
+  $1 = "vt102 vt200 vt220 vt300 vt320 vt420 xterm";
 
   if (is_substr($1, getenv("TERM"))) set_term_vtxxx(0);
 
@@ -218,7 +219,7 @@
 %
 %  Compiler interface --- uncomment one of the following:
 %
-% compile_parse_error_function = "gcc";           % GNU compiler
+compile_parse_error_function = "gcc";           % GNU compiler
 % compile_parse_error_function = "Ultrix_cc";     % cc on Ultrix
 % compile_parse_error_function = "bcc";           % Borlands BCC
 % compile_parse_error_function = "sun_acc";       % SunOS C++ and ACC
diff -u --recursive --new-file jed-0.96.2/jed/lib/linux.sl jed-0.96.3/jed/lib/linux.sl
--- jed-0.96.2/jed/lib/linux.sl	Thu Jun  2 22:51:34 1994
+++ jed-0.96.3/jed/lib/linux.sl	Sat Jul 16 22:27:45 1994
@@ -10,17 +10,52 @@
 
 variable UCB_Mailer;  UCB_Mailer = "/bin/mail";
 
-!if (strcmp("console", getenv("TERM")))
-{
-%   USE_ANSI_COLORS = 1;   % uncomment if your console is a color one!
-   OUTPUT_RATE = 0;
-   tt_send("\e[44m");		       %/* white on blue */
-   call("redraw");
-   TERM_CANNOT_SCROLL = -1;
+variable Key_F1;
+variable Key_F2;
+variable Key_F3;
+variable Key_F4;
+variable Key_F5;
+variable Key_F6;
+variable Key_F7;
+variable Key_F8;
+variable Key_F9;
+variable Key_F10;
+
+#ifdef XWINDOWS
+   setkey("bol",		"^[[H" ); 	% home
+   setkey("toggle_overwrite",   "^[[2~");	% insert
+   setkey("delete_char_cmd",    "^[[7~");
+   unsetkey("^E");
+   setkey("eol",                "^E" );		% end
+
+   Key_F1 = "^[[12~";
+   Key_F2 = "^[[13~";
+   Key_F3 = "^[[14~";
+   Key_F4 = "^[[15~";
+   Key_F5 = "^[[16~";
+   Key_F6 = "^[[17~";
+   Key_F7 = "^[[18~";
+   Key_F8 = "^[[19~";
+   Key_F9 = "^[[20~";
+   Key_F10 = "^[[21~";
+
+#else
    setkey("bol",      		"^[[1~");	% home
    setkey("toggle_overwrite",	"^[[2~");       % insert
    setkey("delete_char_cmd",	"^[[3~");       % delete
    setkey("eol",		"^[[4~");       % end
+
+   Key_F1 = "^[[[A";
+   Key_F2 = "^[[[B";
+   Key_F3 = "^[[[C";
+   Key_F4 = "^[[[D";
+   Key_F5 = "^[[[E";
+   Key_F6 = "^[[17~";
+   Key_F7 = "^[[18~";
+   Key_F8 = "^[[19~";
+   Key_F9 = "^[[20~";
+   Key_F10 = "^[[21~";
+#endif
+
    setkey("page_up",		"^[[5~");	
    setkey("page_down",		"^[[6~");
-}
diff -u --recursive --new-file jed-0.96.2/jed/lib/menu.sl jed-0.96.3/jed/lib/menu.sl
--- jed-0.96.2/jed/lib/menu.sl	Thu Jun  2 22:51:34 1994
+++ jed-0.96.3/jed/lib/menu.sl	Sat Jul 16 22:27:45 1994
@@ -48,8 +48,7 @@
 
 	forever 
 	  {
-	     message ("Pick a number or press Ctrl-G to abort or SPACE to go back to previous level.");
-	     set_top_status_line (s); pop (); update(1);
+	     flush(s);
 	     i = getkey();
 	     if (i == 7) call ("kbd_quit");
 	     if (i == ' ')
@@ -65,8 +64,8 @@
 
 	     beep();
 	     flush_input();
-	     % flush("Pick a number or press Ctrl-G to abort or SPACE to go back.");
-	     % pop(input_pending(20));
+	     flush("Pick a number or press Ctrl-G to abort or SPACE to go back.");
+	     pop(input_pending(20));
 	  }
    
 	cmd = extract_element(cmd_list, i, ',');
@@ -79,7 +78,7 @@
 	else
 	  {
 	     Menu_Last_Cmd = cmd;
-	     eval(strcat (".", cmd));  %  Use RPN--- no need to parse it
+	     eval(cmd);
 	  }
      }
    while(Menu_Abort);
@@ -102,7 +101,7 @@
 define menu_deletion_cmd ()
 {
    menu_select_cmd ("Delete Char,Delete Word",
-		    "del,delete_word");
+		    "del,@delete_word");
 }
 
 
@@ -160,13 +159,8 @@
 
 define menu_misc ()
 {
-#ifdef UNIX VMS
-   menu_select_cmd ("compose mail,send mail,ispell,shell command,suspend",
+   menu_select_cmd ("compose mail,send mail,ispell,shell command,Suspend",
 		    "mail,send,ispell,do_shell_cmd,@sys_spawn_cmd");
-#else
-   menu_select_cmd ("Shell command,Suspend",
-		    "do_shell_cmd,@sys_spawn_cmd");
-#endif
 }
 
 
@@ -175,17 +169,9 @@
 {
    variable n, key, len, next, nlen;
    
-   ERROR_BLOCK 
-     {
-	set_top_status_line (Global_Top_Status_Line);
-	pop ();
-     }
-   
-   menu_select_cmd ("File,Edit,Buffers,Windows,Help,Misc,Exit",
-		    "menu_files,menu_basics,menu_buffers,menu_window_cmds,menu_help,menu_misc,@exit_jed");
+   menu_select_cmd ("Basic,Files,Buffers,Windows,Help,Misc,Exit",
+		    "menu_basics,menu_files,menu_buffers,menu_window_cmds,menu_help,menu_misc,@exit_jed");
 
-   EXECUTE_ERROR_BLOCK ();
-   
      %
      %  Show user keybinding of the function.
      %  The problem with this is that any function which leaves a message
@@ -201,7 +187,8 @@
      }
    
    if (Menu_Abort)
-     {
+     { 
+	flush (" ");
 	return; 
      }
    
@@ -226,4 +213,5 @@
    else strcat (Menu_Last_Cmd, " is not on any keys.");
    message (());
 }
+
 
diff -u --recursive --new-file jed-0.96.2/jed/lib/site.sl jed-0.96.3/jed/lib/site.sl
--- jed-0.96.2/jed/lib/site.sl	Thu Jun  2 22:51:34 1994
+++ jed-0.96.3/jed/lib/site.sl	Sat Jul 16 22:27:47 1994
@@ -95,7 +95,7 @@
    Info_Directory = strcat(JED_ROOT, "[info]");
    Jed_Bin_Dir = strcat(JED_ROOT, "[bin]");
 #else
-   Info_Directory = dircat(JED_ROOT, "info");
+   Info_Directory = "/usr/info";
    Jed_Bin_Dir = dircat(JED_ROOT, "bin");
 #endif
  
@@ -265,7 +265,7 @@
 	if (i == 1) ungetkey(13);
 	ungetkey(9);
 	++i;
-	f = read_with_completion("M-x", Null_String, f, 'F')
+        f = read_with_completion("Run function:", Null_String, f, 'F')
      } 
 }
 
@@ -603,6 +603,9 @@
  "^H -> Help:^H  Menu:?  Info:I  Apropos:A  Key:C  Where:W  Fnct:F  Var:V  Man:M";
 #endif
 
+% string to display when JED is started - can be overwritten by other keybindings
+variable startup_string = "Welcome to JED.  Press 'ctrl-h' twice for help, or 'ctrl-h ?' for menus." ;
+
 % Load minibuffer routines now before any files are loaded.
 % This will reduce fragmentation on PC.
 !if (BATCH) {evalfile("mini"); pop();}
@@ -679,7 +682,7 @@
 	  }
 	else !if (Startup_With_File)
 	  {
-	     message(help_for_help_string); do_message = 0;
+	     message(startup_string); do_message = 0;
 	     update(1);
 	     pop(input_pending(600));
 	  }
@@ -687,7 +690,7 @@
 	if (strlen (file)) pop(find_file(file));
      }
    
-   if (do_message) message(help_for_help_string);
+   if (do_message) message(startup_string);
 }
 
 
@@ -907,8 +910,9 @@
    EXECUTE_ERROR_BLOCK;
 }  add_completion("insert_buffer");
 
-variable Global_Top_Status_Line = " *** To activate menus, press `Ctrl-H ?'.  For help, press `Ctrl-H' twice. ***";
-set_top_status_line (Global_Top_Status_Line); pop ();
+%variable Global_Top_Status_Line = " *** To activate menus, press `Ctrl-H ?'.  For help, press `Ctrl-H' twice. ***";
+%set_top_status_line (Global_Top_Status_Line); pop ();
+
 define help_prefix()
 {
    variable c;
diff -u --recursive --new-file jed-0.96.2/jed/lib/wordstar.hlp jed-0.96.3/jed/lib/wordstar.hlp
--- jed-0.96.2/jed/lib/wordstar.hlp	Thu Jan  1 00:00:00 1970
+++ jed-0.96.3/jed/lib/wordstar.hlp	Sat Jul 16 22:00:11 1994
@@ -0,0 +1,11 @@
+  --- JED Key-bindings -----------------------------------------------------------------------------------------------------------
+	Blocks  | ^KB: Block Start	 ^KK: Block End		^KC: Block Copy		^KY: Block Delete
+	Files	| ^KR: Insert File	 ^KS: Save File		^KD: Save & Exit	^KQ: Quit & Exit
+	Format  |  @q: Format p/graph	  @n: Format p/graph	 @s: Centre Line	 @u: Uppercase Word
+		|  @l: Lowercase Word	  @c: Capitalise Word
+	Search	| ^QF: Find Word          ^L: Repeat Find	^QA: Search & Replace
+	Move	| ^QE: Top Of Window	 ^QX: Bottom Of Window	^QS: Start Of Line	^QD: End Of Line
+	Window	| ^X1: One Window	 ^X2: Two Windows	^X0: Close Window	^Xo: Other Window
+		| ^Xx: Other Window Down ^Xz: Other Window Up	^X+: Enlarge Window
+	Mode	| @m0: No Mode		 @m1: Text Mode		@m2: C Mode		@m3: Fortran Mode
+		| @m4: SLang Mode	 @m5: TeX Mode
diff -u --recursive --new-file jed-0.96.2/jed/lib/wordstar.sl jed-0.96.3/jed/lib/wordstar.sl
--- jed-0.96.2/jed/lib/wordstar.sl	Thu Jun  2 22:51:35 1994
+++ jed-0.96.3/jed/lib/wordstar.sl	Sat Jul 16 22:27:48 1994
@@ -5,16 +5,17 @@
 %   in your jed.rc startup file.
 %
 
-Help_File = Null_String;
+Help_File = "wordstar.hlp";
 
-set_status_line (" Jed %v : %b   (%m%n)   (%p %c)   %t", 1);
+set_status_line (" Jed %v : %b   (%m%n)   (%p %c)   %t ", 1);
 
-Help_File = Null_String;
-
 set_abort_char (30);    % ^^ (Control 6 on most keyboards)
 % Note, the above command BREAKS ^G emacs abort.
+
+enable_flow_control(0);
+
 unsetkey("^K");
-unsetkey("^X");
+% unsetkey("^X");
 unsetkey("^W");
 unsetkey("^F");
 
@@ -22,7 +23,7 @@
 setkey ("next_char_cmd","^D");
 setkey ("previous_char_cmd","^S");
 setkey ("previous_line_cmd","^E");
-setkey ("next_line_cmd","^X");
+% setkey ("next_line_cmd","^X");
 setkey ("page_up","^R");
 setkey ("page_down","^C");
 setkey ("skip_word","^F");
@@ -73,6 +74,24 @@
 setkey ("exit_jed","^KQ");
 setkey ("ws_exit_jed","^K^D");
 setkey ("ws_exit_jed","^KD");
+setkey ("exit_jed","^[[21~");
+%
+% ESC-m map
+%
+setkey ("no_mode","^[m0");
+setkey ("text_mode","^[m1");
+setkey ("c_mode","^[m2");
+setkey ("fortran","^[m3");
+setkey ("slang_mode","^[m4");
+setkey ("tex_mode", "^[m5");
+%
+% other window controls
+%
+setkey ("next_wind_up","^XZ");
+setkey ("next_wind_up","^X^Z");
+setkey ("next_wind_dn","^XX");
+setkey ("next_wind_dn","^X^X");
+setkey ("enlarge_window","^X+");
 
 define ws_window_up () 
 {
@@ -81,7 +100,7 @@
 
 define ws_window_down ()
 {
-   recenter (window_line() + 1);
+   recenter (window_line() - 1);
 }
 
 % Not implemented:
diff -u --recursive --new-file jed-0.96.2/jed/src/window.c jed-0.96.3/jed/src/window.c
--- jed-0.96.2/jed/src/window.c	Thu Jun  2 22:51:39 1994
+++ jed-0.96.3/jed/src/window.c	Sat Jul 16 22:45:29 1994
@@ -17,7 +17,7 @@
 
 Window_Type *JWindow;
 extern Window_Type *The_MiniWindow;
-int Top_Window_Row = 2;
+int Top_Window_Row = 1;
 
 Window_Type *create_window(int top, int rows, int col, int width)
 {
diff -u --recursive --new-file jed-0.96.2/jed/src/xkeys.c jed-0.96.3/jed/src/xkeys.c
--- jed-0.96.2/jed/src/xkeys.c	Thu Jun  2 22:51:40 1994
+++ jed-0.96.3/jed/src/xkeys.c	Sat Jul 16 23:34:50 1994
@@ -86,7 +86,7 @@
    "",			/* 0xFF4D */
    "",			/* 0xFF4E */
    "",			/* 0xFF4F */
-   "\001\001",		/* 0xFF50 	 XK_Home */
+   "\003\033[H",	/* 0xFF50 	 XK_Home */
    "\003\033[D",	/* 0xFF51 	 XK_Left */
    "\003\033[A",	/* 0xFF52 	 XK_Up */
    "\003\033[C",	/* 0xFF53 	 XK_Right */
@@ -237,9 +237,9 @@
    "",			/* 0xFFE4 	 XK_Control_R */
    "",			/* 0xFFE5 	 XK_Caps_Lock */
    "",			/* 0xFFE6 	 XK_Shift_Lock */
-   "",			/* 0xFFE7 	 XK_Meta_L */
+   "\001\033",		/* 0xFFE7 	 XK_Meta_L */
    "",			/* 0xFFE8 	 XK_Meta_R */
-   "",			/* 0xFFE9 	 XK_Alt_L */
+   "\001\033",		/* 0xFFE9 	 XK_Alt_L */
    "",			/* 0xFFEA 	 XK_Alt_R */
    "",			/* 0xFFEB 	 XK_Super_L */
    "",			/* 0xFFEC 	 XK_Super_R */
@@ -261,7 +261,7 @@
    "",			/* 0xFFFC */
    "",			/* 0xFFFD */
    "",			/* 0xFFFE */
-   "\001\177"		/* 0xFFFF 	 XK_Delete */
+   "\004\033[7~"	/* 0xFFFF 	 XK_Delete */
 };
 
 static KeySym_Mapping_Type Shift_KeySym_Mapping[256] =
@@ -346,7 +346,7 @@
    "",			/* 0xFF4D */
    "",			/* 0xFF4E */
    "",			/* 0xFF4F */
-   "\001\001",		/* 0xFF50 	 XK_Home */
+   "\003\033[H",	/* 0xFF50 	 XK_Home */
    "\003\033[d",	/* 0xFF51 	 XK_Left */
    "\003\033[a",	/* 0xFF52 	 XK_Up */
    "\003\033[c",	/* 0xFF53 	 XK_Right */
@@ -497,9 +497,9 @@
    "",			/* 0xFFE4 	 XK_Control_R */
    "",			/* 0xFFE5 	 XK_Caps_Lock */
    "",			/* 0xFFE6 	 XK_Shift_Lock */
-   "",			/* 0xFFE7 	 XK_Meta_L */
+   "\001\033",		/* 0xFFE7 	 XK_Meta_L */
    "",			/* 0xFFE8 	 XK_Meta_R */
-   "",			/* 0xFFE9 	 XK_Alt_L */
+   "\001\033",		/* 0xFFE9 	 XK_Alt_L */
    "",			/* 0xFFEA 	 XK_Alt_R */
    "",			/* 0xFFEB 	 XK_Super_L */
    "",			/* 0xFFEC 	 XK_Super_R */
@@ -521,7 +521,7 @@
    "",			/* 0xFFFC */
    "",			/* 0xFFFD */
    "",			/* 0xFFFE */
-   "\001\177"		/* 0xFFFF 	 XK_Delete */
+   "\004\033[7$"	/* 0xFFFF 	 XK_Delete */
 };
 
 static KeySym_Mapping_Type Control_KeySym_Mapping[256] =
@@ -606,7 +606,7 @@
    "",			/* 0xFF4D */
    "",			/* 0xFF4E */
    "",			/* 0xFF4F */
-   "\001\001",		/* 0xFF50 	 XK_Home */
+   "\003\033[H",	/* 0xFF50 	 XK_Home */
    "\003\033[\004",	/* 0xFF51 	 XK_Left */
    "\003\033[\001",	/* 0xFF52 	 XK_Up */
    "\003\033[\003",	/* 0xFF53 	 XK_Right */
@@ -757,9 +757,9 @@
    "",			/* 0xFFE4 	 XK_Control_R */
    "",			/* 0xFFE5 	 XK_Caps_Lock */
    "",			/* 0xFFE6 	 XK_Shift_Lock */
-   "",			/* 0xFFE7 	 XK_Meta_L */
+   "\001\033",		/* 0xFFE7 	 XK_Meta_L */
    "",			/* 0xFFE8 	 XK_Meta_R */
-   "",			/* 0xFFE9 	 XK_Alt_L */
+   "\001\033",		/* 0xFFE9 	 XK_Alt_L */
    "",			/* 0xFFEA 	 XK_Alt_R */
    "",			/* 0xFFEB 	 XK_Super_L */
    "",			/* 0xFFEC 	 XK_Super_R */
@@ -781,6 +781,6 @@
    "",			/* 0xFFFC */
    "",			/* 0xFFFD */
    "",			/* 0xFFFE */
-   "\001\177"		/* 0xFFFF 	 XK_Delete */
+   "\004\033[7^"	/* 0xFFFF 	 XK_Delete */
 };
 
diff -u --recursive --new-file jed-0.96.2/jed/src/xterm.c jed-0.96.3/jed/src/xterm.c
--- jed-0.96.2/jed/src/xterm.c	Fri Jun  3 05:34:22 1994
+++ jed-0.96.3/jed/src/xterm.c	Sat Jul 16 23:35:02 1994
@@ -111,23 +111,23 @@
 static char *This_Geometry = NULL;
 static char *This_Font_Name = "fixed";
 static char *This_Border_Width_Name = "0";
-static char *This_MFG = "green";
-static char *This_MBG = "white";
+static char *This_MFG = "lightgrey";
+static char *This_MBG = "black";
 
 static GC_Info_Type Default_GC_Info[JMAX_COLORS] = 
 {
-   {NULL, 0, 0, "black", "white"},     /* NORMAL */
-   {NULL, 0, 0, "green", "red"},       /* CURSOR */
-   {NULL, 0, 0, "black", "skyblue"},   /* STATUS */
-   {NULL, 0, 0, "black", "magenta"},      /* REGION */
-   {NULL, 0, 0, "black", "skyblue"},      /* MENU */
-   {NULL, 0, 0, "black", "white"},     /* operator */
-   {NULL, 0, 0, "green", "white"},     /* numbers */
-   {NULL, 0, 0, "blue", "white"},      /* strings */
-   {NULL, 0, 0, "black", "gray"},      /* comments */
-   {NULL, 0, 0, "red", "white"},       /* keyword */
-   {NULL, 0, 0, "black", "white"},      /* delimeters */
-   {NULL, 0, 0, "magenta", "white"}      /* preprocess */
+   {NULL, 0, 0, "lightgrey",     "black"},	/* NORMAL */
+   {NULL, 0, 0, "green",         "red"},       	/* CURSOR */
+   {NULL, 0, 0, "yellow",        "blue"},   	/* STATUS */
+   {NULL, 0, 0, "black",         "lightgrey"},  /* REGION */
+   {NULL, 0, 0, "black",         "blue"},    	/* MENU */
+   {NULL, 0, 0, "yellow",        "black"},	/* operator */
+   {NULL, 0, 0, "skyblue",       "black"},	/* numbers */
+   {NULL, 0, 0, "skyblue",       "black"},      /* strings */
+   {NULL, 0, 0, "darkslategrey", "black"},      /* comments */
+   {NULL, 0, 0, "green",         "black"},      /* keyword */
+   {NULL, 0, 0, "yellow",        "black"},      /* delimeters */
+   {NULL, 0, 0, "blue",          "black"}	/* preprocess */
 };
 
 static XWindow_Arg_Type X_Arg_List[] =
