#
# Module for performing searches in Entry widgets
#

# Searches w for next instance of string.
proc th_Entry_find {w string {next 1} {direction "forward"} {type "string"}} {
  global TH
  set border(forward) -1
  if {![catch "$w index sel.first" was_search_start]} {
    set was_search_end [$w index sel.last]
    set insert [$w index insert]
    if {($was_search_start <= $insert) && ($insert <= $was_search_end)} {
      $w select clear
      if $next {
        set border(forward) [incr was_search_start]
        set border(backward) [incr was_search_end -1]
      } else {
        set border(forward) $was_search_start
        set border(backward) [incr was_search_end]
  }}}
  if {$border(forward) == -1} {
    if $next {
      set border(forward) [expr [$w index insert] +1]
      set border(backward) [$w index insert]
    } else {
      set border(forward) [$w index insert]
      set border(backward) [expr [$w index insert] + [string length $string]]
  }}

  if {[catch "set TH(Search,Failed,$w)"]} {set TH(Search,Failed,$w) 0}
  if $TH(Search,Failed,$w) {
    set border(forward) 0
    set border(backward) end
  }

  set length [string length $string]
  if {($length == 0)} {return 0}

  set slist [th_Entry_[set type]_[set direction] $w $border($direction) $string]
  if {($slist != "")} {
    $w icursor [lindex $slist 0]
    if {$TH(Search,Select,[winfo class $w]) == "sel"} {
      $w select from [lindex $slist 0]
      $w select to [lindex $slist 1]
      th_Entry_goto $w [lindex $slist 0] 0
    } else {$w view insert}
    set TH(Search,Failed,$w) 0
    return 1
  } else {
    set TH(Search,Failed,$w) 1
    return 0
}}


# Finds first occurrence of string after point in widget w
# Returns start and end of occurance or "" if unsuccessful.
proc th_Entry_string_forward {w point string} {
  global TH
  set text [string range [$w get] $point end]
  if $TH(Search,Case,$w) {set text [string tolower $text]}
  set answer [string first $string $text]
  if {($answer == -1)} {return ""
  } else {
    incr answer $point
    return [list $answer [expr $answer + [string length $string] - 1]]
}}

# Finds last occurrence of string before point in widget w
# Returns start and end of occurance or "" if unsuccessful.
proc th_Entry_string_backward {w point string} {
  global TH
  set point [expr [$w index $point] -1]
  set text [string range [$w get] 0 $point]
  if $TH(Search,Case,$w) {set text [string tolower $text]}
  set answer [string last $string $text]
  if {($answer == -1)} {return ""
  } else {return [list $answer [expr $answer + [string length $string] - 1]]
}}


# The glob routines find first occurrence of string after point in widget
# w, using Tcl's string match command (which uses glob expressions).
# Returns start and end of occurance or "" if unsuccessful.

proc th_Entry_glob_forward {w point string} {return [th_Entry_glob $w $point $string forward]}

proc th_Entry_glob_backward {w point string} {return [th_Entry_glob $w $point $string backward]}

proc th_Entry_glob {w point string direction} {
  if {![regexp -- {([^][?*\]*)(.*)} $string dummy start]} {return}
  if {$string == $start} {
    return [th_Entry_string_[set direction] $w $point $string]}
  set l [string length $string] ; incr l -1
  set end ""
  while {[regexp -- {[^][?*\]} [string index $string $l]]} {
    set char [string index $string $l]
    incr l -1
    if {[string index $string $l] == "\\"} {break}
    set end "$char$end"
  }

  global TH
  set text [string range [$w get] 0 end]
  if $TH(Search,Case,$w) {set text [string tolower $text]}

  set point [$w index $point]
  set start_index $point
  set end_index $point
  set sl [string length $start]
  set el [string length $end]

  if {$direction == "forward"} {set fn "th_Entry_string_forward"
  } else {set fn "th_Entry_string_backward"}

  if {($start != "") && ($end != "")} {
    set end_flag 1
    while {[set start_index [$fn $w $start_index $start]] != ""} {
      set start_index [lindex $start_index 0]
      if {!(($direction == "forward") && ($start_index < $point))} {
        if {[string match "[set string]*" [string range $text $start_index end]]} {
          set end_index $start_index
          set end_flag 0
          while {[set end_index [th_Entry_string_forward $w [expr $end_index +1] $end]] != ""} {
            set end_index [lindex $end_index 0]
            set end_flag 1
            incr end_index [expr $el -1]
            if {!(($direction == "backward") && ($end_index > $point))} {
              if {[string match $string [string range $text $start_index $end_index]]} {
                return [list $start_index $end_index]
      }}}}}
      if {$direction == "forward"} {incr start_index} else {incr start_index -1
    }}
    if {!$end_flag} {return ""}

  } elseif {($start != "") && ($end == "")} {
    while {[set start_index [$fn $w $start_index $start]] != ""} {
      set start_index [lindex $start_index 0]
      set end_index [th_string_wordend $text [expr $start_index +$sl - 1]]
      incr end_index -1
      if {!(($direction == "forward") && ($start_index < $point)) &&
          !(($direction == "backward") && ($end_index > $point))} {
        if {[string match $string [string range $text $start_index $end_index]]} {
            return [list $start_index $end_index]}}
      if {$direction == "forward"} {incr start_index} else {incr start_index -1}

  }} elseif {$end != ""} {
    while {[set end_index [$fn $w $end_index $end]] != ""} {
      set end_index [lindex $end_index 0]
      incr end_index [expr $el -1]
      set start_index [th_string_wordstart $text [expr $end_index - $el]]
      if {!(($direction == "forward") && ($start_index < $point)) &&
          !(($direction == "backward") && ($end_index > $point))} {
        if {[string match $string [string range $text $start_index $end_index]]} {
          return [list $start_index $end_index]}}
      if {$direction == "forward"} {
        incr end_index
      } else {
        incr end_index [expr $sl -1]

  }}} else {
    while {1} {
      set end_index [expr [th_string_wordend $text $start_index] -1]
      set start_index [th_string_wordstart $text $end_index]
      if {!(($direction == "forward") && ($start_index < $point)) &&
          !(($direction == "backward") && ($end_index > $point))} {
        if {[string match $string [string range $text $start_index $end_index]]} {
          return [list $start_index $end_index]
      }}
      if {$direction == "forward"} {
        set new_index [expr $end_index +1]
      } else {set new_index [th_string_wordstart $text [expr $start_index -1]]}
      if {($new_index == $start_index) || ($new_index >= [string length $text])} {break}
      set start_index $new_index
  }}
  return ""
}


# Finds first occurrence of string after point in widget w using regexp.
# Returns start and end of occurance or "" if unsuccessful.
proc th_Entry_regexp_forward {w point string} {
  global TH
  if $TH(Search,Case,$w) {
    if {[catch {regexp -indices -nocase -- $string [string range [$w get] $point end] where} result]} {th_beep ; return}
  } else {if {[catch {regexp -indices -- $string [string range [$w get] $point end] where} result]} {th_beep ; return}
  }
  if {!$result} {return ""}

  return [list [expr $point + [lindex $where 0]] \
               [expr $point + [lindex $where 1]]]
}

# Like regexp_forward, but searches from beginning to point.
proc th_Entry_regexp_backward {w point string} {
  global TH
  set text [string range [$w get] 0 $point]
  set text_range $text
  set offset 0
  set answer ""
  while {1} {
    if $TH(Search,Case,$w) {
      if {[catch {regexp -indices -nocase -- $string $text_range where} result]} {th_beep ; return}
    } else {if {[catch {regexp -indices -- $string $text_range where} result]} {th_beep ; return}
    }
    if $result {
      set answer [list [expr $offset + [lindex $where 0]] \
			[expr $offset + [lindex $where 1]]]
    } else {break}
    incr offset [expr [lindex $where 0] +1]
    set text_range [string range $text $offset end]
  }
  return $answer
}


# Cleans up widget from searching.
proc th_Entry_search_exit {w} {
  global TH
  if {$TH(Search,Select,[winfo class $w]) == "sel"} {$w select clear}
}


