#
# Code for maintaining a frame widget for entries & messages
#

# Returns the widget's frame
proc th_frame {w} {
  set f "[winfo toplevel $w].th_frame"
  if {$f == "..th_frame"} {set f .th_frame}
  if {[winfo exists $f]} {return $f}
  global TH
  return $TH(Frame)
}


# Time to display labels
set TH(Label,Flash) 3000

# Displays a label for $TH(Label,Flash) seconds. Label lives in $parent.
# Args gets passed to the label as configuration options.
proc th_flash_label {w args} {
  set f [th_frame $w]
  set newlabel "$f.m[th_gensym]"
  eval label $newlabel -relief raised $args
  destroy $newlabel
  eval label $newlabel -relief raised $args
  pack $newlabel -side left
  update
  global TH
  after $TH(Label,Flash) "catch \"destroy $newlabel\""
}

# Works like the bind command, except uses TH(Binding,$th_binding) which is
# a list of bindings, applies binding to all in the list.
proc th_bind {w th_binding {cmd ""}} {
  global TH
  if {$cmd == ""} {return [bind $w [lindex $TH(Binding,$th_binding) 0]]}
  foreach binding $TH(Binding,$th_binding) {bind $w $binding $cmd}
}

# Creates a subframe, widget name of $name, with a label and entry, inside
# the widget's frame widget.
# Returns subframe. Label is $name.l and entry is $name.e
proc th_show_entry {w name} {
  set f [th_frame $w]
  if {[string match "$f.*" $w]} {return ""}
  if {![winfo exists $f.$name]} {
    frame $f.$name
    label $f.$name.l
    entry $f.$name.e
    pack $f.$name.l -side left
    pack $f.$name.e -side right
  }
  pack $f.$name -side left
  th_bind $f.$name.e Cancel "th_hide_entry $w $name ; th_beep"
  if {[th_bind $w Cancel] == ""} {
    th_bind $w Cancel [th_bind [winfo class $w] Cancel]}
  th_bind $w Cancel "+th_hide_entry $w $name"
  focus $f.$name.e
  return $f.$name
}

# Removes entry & label. (merely unpacks them)
proc th_hide_entry {w name} {
  set f [th_frame $w]
  pack forget $f.$name
  focus $w
}

# Called by a binding and menuentry.
proc th_checkbutton_variable {var} {
  global TH
  if {[catch "set TH($var,aux)"]} {set TH($var,aux) 0}
  if {[catch "set TH($var)"]} {set TH($var) 0}
  if {$TH($var) != $TH($var,aux)} {
# was invoked by menu.
    set TH($var,aux) $TH($var)
  } else {
# was invoked by keybinding
    set TH($var) [expr $TH($var) ? 0 : 1]
    set TH($var,aux) $TH($var)
}}


