#
# Module for browsing around in Scrollbar widgets
#

# Where is index of left/top edge of scroller. (It is kept the same size, and
# if it is attached to a widget, it resets the widget, too).
proc th_Scrollbar_goto {w where} {
  set s [$w get]
  if {[lindex $s 2] == $where} {th_beep ; return 0}
  eval $w set [lreplace $s 2 3 $where [expr [lindex $s 3] - [lindex $s 2] + $where]]
  set cmd [lindex [$w configure -command] 4]
  if {$cmd != ""} {eval $cmd [lindex [$w get] 2]}
  return 1
}

# Returns the size of the scrollbar. Useful for paging.
proc th_Scrollbar_size {w} {
  set s [$w get]
  set delta [expr [lindex $s 3] - [lindex $s 2]]
  if {$delta < 3} {set delta 3}
  return $delta
}

# Exchanges scrollbar mark with its current position.
proc th_Scrollbar_exchange_mark {w} {
  global TH ; if {[catch "set TH(Mark,$w)"]} {th_beep ; return}
  set s [$w get]
  th_Scrollbar_goto $w $TH(Mark,$w)
  set TH(Mark,$w) [lindex $s 2]
}


