#
# Bindings for Htmlth
#


set Bindings(Html) {
  {Split_Html  		{th_html_mark %W}}
  {Update_Anchors	{th_Text_tag_regions %W anchor th_anchor_begin th_anchor_end th_anchor_next}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Split_Html Update_Anchors}


set TH_Bindings_Help {
HTML Functions

This module introduces some HTML concepts to a text widget containing HTML. It
cooperates with the paragraph module to bring you paragraph formatting, but it
adds a few options of its own, particularly an index for anchors, as well as the
index for paragraphs, and it provides an option called "Update Anchors" to
refresh the index when anchors get added and deleted. Normally, the program
tries to maintain the tags so you don't have to use this option. It tags all the
paragraphs and anchors upon startup, and several functions, such as
Select-Paragraph also will adjust the tags, so you often can edit the file
without explicitly calling this option. 
}


