#
# Bindings for Edith
#

set Bindings(Edit,Misc) {
  {Undo 		{th_[winfo class %W]_undo %W}}
  {Show_Last_Undo 	{th_look_undo %W}}
  {Kill_Undo_Log 	{th_kill_undos %W}}
  {Yank 		{th_[winfo class %W]_paste_selection %W}}
  {Quote 		{th_quote %W}}
  {Kill_Line 		{th_[winfo class %W]_kill_line %W}}
  {Kill_Region 		{th_[winfo class %W]_kill_region %W}}
  {Delete_Selection 	{th_[winfo class %W]_delete_selection %W}}
  {Uppercase_Region 	{th_[winfo class %W]_filter %W th_string_toupper}}
  {Lowercase_Region 	{th_[winfo class %W]_filter %W th_string_tolower}}
  {Capitalize_Region 	{th_[winfo class %W]_filter %W th_string_capitalize}}
  {Transpose_Chars 	{th_[winfo class %W]_transpose_chars %W}}
}
set Bindings(Edit,Text) {
  {Delete_Char_Backward	{th_Text_delete_range %W {insert -1 char} insert 0}}
  {Delete_Char_Forward	{th_Text_delete_range %W insert {insert +1 char} 0}}
  {Delete_Word_Backward	{th_Text_delete_range %W {insert -2 chars wordstart} insert}}
  {Delete_Word_Forward	{th_Text_delete_range %W insert {insert +1 chars wordend}}}
  {Transpose_Words 	{th_[winfo class %W]_transpose_words %W}}
  {Split_Line 		{th_Text_insert %W "\n" ; %W mark set insert "insert -1c" ; %W yview -pickplace insert}}
  {Indent_Region 	{th_indent %W th_Text_indent_add}}
  {Delete_Indent 	{th_indent %W th_Text_indent_delete}}
}
set Bindings(Edit,Entry) {
  {Kill_All 		{%W icursor 0 ; th_Entry_kill_line %W}}
  {Delete_Char_Backward	{th_[winfo class %W]_delete_char_backward %W}}
  {Delete_Char_Forward	{th_[winfo class %W]_delete_char_forward %W}}
  {Delete_Word_Backward	{th_[winfo class %W]_delete_word_backward %W}}
  {Delete_Word_Forward	{th_[winfo class %W]_delete_word_forward %W}}
  {Transpose_Words 	{th_[winfo class %W]_transpose_words %W}}
}
set Bindings(Edit,Canvas) {
  {Kill_All 		{catch {%W icursor [%W focus] 0} ; th_Canvas_kill_line %W}}
  {Delete_Char_Backward	{catch {th_[winfo class %W]_delete_char_backward %W [%W focus]}}}
  {Delete_Char_Forward	{catch {th_[winfo class %W]_delete_char_forward %W [%W focus]}}}
  {Delete_Word_Backward	{catch {th_[winfo class %W]_delete_word_backward %W [%W focus]}}}
  {Delete_Word_Forward	{catch {th_[winfo class %W]_delete_word_forward %W [%W focus]}}}
  {Transpose_Words 	{th_[winfo class %W]_transpose_words %W}}
  {Split_Line 		{th_Canvas_insert %W "\n" ; catch {th_Canvas_goto %W [%W focus] [expr [%W index [%W focus] insert] -1]}}}
}
set Bindings(Edit,Self_Insert) {
  {Toggle_Overwrite 	{th_checkbutton_variable Overwrite,%W}}
  {Self_Insert 		{th_[winfo class %W]_self_insert %W %A}}
}
set Bindings(Edit,Newline) {
  {Newline 		{th_[winfo class %W]_insert %W "\n"}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Undo Show_Last_Undo Kill_Undo_Log Yank 
	Toggle_Overwrite Self_Insert Quote Kill_Line Kill_Region Kill_All
	Delete_Char_Backward Delete_Char_Forward Delete_Word_Backward
	Delete_Word_Forward Delete_Selection Uppercase_Region Lowercase_Region
	Capitalize_Region Transpose_Chars Transpose_Words Split_Line
	Indent_Region Delete_Indent OK Cancel}


set TH_Bindings_Help {
Edit Functions

These are commands to alter the text contents in various widgets. They work on
text widgets, entry widgets, and text items in canvas widgets.

The most important are insertion commands. Pressing any key inserts that key
into the widget. If the Overwrite mode is on, then each key overwrites the
current character at the cursor, otherwise it gets inserted before the current
character. You can turn on or off the overwrite mode using Meta-o. Normally
a control character will get inserted unless it has some special binding
associated with it. To insert a control character that would otherwise execute
some function, press Control-q before pressing the control character.

Toggle overwrite mode:	Meta-o
Quote:			Control-q

One can erase text in one of two ways. Killing text removes it from the window,
but puts it into a 'kill' buffer (actually a hidden text widget called .th_kill)
It also selects the text in the kill buffer, so you can paste it elsewhere.

One can kill a line of text with Control-k. Control-k will remember the last
point where text was killed from, and one can increase the kill region by
hitting Control-k repeatedly, which kills another line, in text widgets. For
entry and canvas widgets, Control-k kills the text from the insert to the end.
In addition to Control-k, one can kill the region between the insert cursor and
the mark with Control-w. (You have to use browseth's features to set the mark).
Finally, for entry and canvas widgets, Control-u kills all the text in the
widget. (This binding does not exist for text widgets; it would make it too easy
to kill a big file of text.)

Kill:	line:	Control-k
	region:	Control-w
	all:	Control-u

Pasting is done with Control-y, which will insert the contents of the X
selection before the insertion cursor. The X selection may be created by 
killing some text, or by using one of the selection bindings provided by
browseth, or by selecting text with the mouse. The Insert key and mouse button 3
(normally unused in Tcl) have the same functionality.
Paste:	Control-y	Insert	button3

In lieu of killing, one can delete characters or ranges of text. Unlike killed
text, deleted text cannot be pasted back. Control-d removes the character after
the insert cusror and Control-h removes the one before the cursor. The Delete
key has the same functionality as Control-h, and Shift-Delete works like
Control-d. You can delete words as well. The Meta-d key deletes the range of the
word from the cursor to the end, and the Meta-h key deletes from the cursor to
the beginning of the current word. Or you can use Meta-Shift-Delete and
Meta-Delete, respectively. When the cursor is at a word boundary, these delete
the next and previous word, respectively. Also, you can delete the current
selection by hitting Control-Delete, or by hitting Delete with mouse button 1
pressed. Thus button 1 is useful for both selecting and deleting text.

		Next:			Previous:
Delete:	Char:	Control-d Delete	Control-h
	Word:	Meta-d			Meta-h
	Selection:	Control-Delete Button1-Delete

There are a few functions to change the case of a range of letters. Meta-u, for
example, converts all letters within the selected region to UPPER CASE. If no
selected region exists, the characters between the cursor and the end of the
current word are UPPERCASED. For canvas widgets, just the character at the
cursor is affected. Meta-l is similar, but it converts its range to lower case.
Finally, there is Meta-c, which Capitalizes Its Range Of Text.

Case:	Upper:	Meta-u
	Lower:	Meta-l
	Cap:	Meta-c

There are a handful of other editing features. Control-o inserts a newline
character *after* the insertion cursor, thereby splitting the cursor's line.
Control-t has the effect of transposing the two characters adjacent to the
cursor. For word transposition, Meta-t transposes two words around the cursor.
Actually, Meta-t transposes three Tk 'words', which usually does the right
thing, exchanging two alphanumeric words while leaving intact the whitespace
between them. There is also a command Control-i to indent the selected region.
It prompts for an indentation prefix, to be inserted at the start of every line.
This is useful for indenting a textual paragraph or commenting out lines of
code, but is only available for text widgets. Also there is Control-I which will
delete an indentation prefix from the selected lines of text.

Open line:		Control-o
Transpose:	Chars:	Control-t
		Words:	Meta-t
Indent:		Add:	Control-i 
		Delete:	Control-I

The last feature edith provides is the ability to undo almost every command
described above. The program keeps a log of the changes made by each command,
and so you can undo as many commands as you please. The key Meta-Control-u will
undo the last undoable cmd (even if you have done other commands that are not
undoable). 

The pasting command, as well as word and region deletion, case-changing,
transposition, and indent commands are all undoable. The only commands that are
not undoable are kills (since paste 'undoes' them anyway), and single character
deletion and insertion (including quote).

Undone commands do not reposition the insert cursor or the view of the widget.
For entry and canvas widgets, the entire contents are remembered for each
undoable command. Since text widgets usually contain too much text to make this
practical, text widgets use marks to indicate regions that recent commands
occurred in. This is much more efficient for text widgets, but it can sometimes
create confusion when undo marks get jumbled together during multiple undos.

If one is unsure about what might get undone by a Meta-Control-u press, one can
view the last command on the undo log, by typing Meta-Control-l. One can clear
the log with Meta-Control-k.

Log:	Last:	Meta-Control-l
	Kill:	Meta-Control-k
	Undo:	Meta-Control-u
}

