#
# Bindings for Cth
#


set Bindings(C) {
  {Begin_Fn 		{th_Text_goto %W [th_fn_begin %W insert]}}
  {End_Fn		{th_Text_goto %W [th_fn_end %W insert]}}
  {Next_Fn		{th_Text_goto %W [th_fn_next %W insert]}}
  {Prev_Fn		{th_Text_goto %W [th_fn_prev %W insert]}}
  {Select_Fn		{th_fn_select %W}}
  {Kill_Fn		{th_Text_kill_range %W [th_fn_begin %W insert] [th_fn_end %W insert]}}
  {Split_C		{th_c_mark %W}}
  {Reformat_ccomment	{th_ccomment_format %W [th_ccomment_begin %W insert] [th_ccomment_end %W insert]}}
  {Update_Fn 		{th_Text_tag_regions %W function th_fn_begin th_fn_end th_fn_next}}
  {Update_ccomment	{th_Text_tag_regions %W comment th_ccomment_begin th_ccomment_end th_ccomment_next}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Begin_Fn End_Fn Next_Fn Prev_Fn Select_Fn Split_C
	Kill_Fn Reformat_ccomment Update_Fn Update_ccomment}


set TH_Bindings_Help {
C Functions

This module introduces the concept of functions and comments in the C/C++ coding
style to text widgets. It adds some simple editing and browsing commands for
functions and comments. One can traverse between functions with Control-N and
Control-P. Control-N puts the cursor at the beginning of the next function, and
Control-P puts the cursor at the beginning of the previous function (or current
one if it is not already there). One can select the current function with
Control-J. And Control-A moves to the beginning of the current function, while
Control-E goes to the end.

				Control-
				   P
Function:	Traversal:	 A + E
				   N
		Select:		   J

There is one editing feature for functions and one for comments. Control-U kills
the current function, it can be yanked, though not undone. Meta-j can be used to
reformat the comment containing the cursor, so that every line in the comment is
as long as the widget's width, but not longer.

				Control-
Function:	Delete:		 H + D
Comment:	Adjust:		Meta-j

Cth also works with taggeth to provide an index of functions and comments. If
taggeth is included, it adds two menu options called "Update Comments" and
"Update Function" to the Index menu. These options add 'function' and 'comment'
tags to each function and comment, respectively. This does not visibly alter the
text, but one can then go to any function or comment quickly using the Tags
submenu off the Index menu. Some editing commands will automatically add the
tags for you, so you can do some editing without explicitly calling these
features.
}


