
/* qddb/Utils/refer2q.c 
 * Convert a Refer(1) database into the readable qddb record format.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void main(argc, argv)
	int		argc;
	char		*argv[];
{
	FILE		*in, *out;
	char		Buffer[BUFSIZ];
	int		i;
	Boolean		NewLine = True;

	if (argc != 3) {
		fprintf(stderr, "Usage: %s infile outfile\n", argv[0]);
		exit(1);
	}
	in = fopen(argv[1], "r");
	out = fopen(argv[2], "w");
	if (in == NULL || out == NULL) {
		fprintf(stderr, "Cannot open files\n");
		exit(1);
	}
	i = 1;
	fprintf(out, "$NUMBER$ = \"%d\";\n", i++);
	while (fgets(Buffer, BUFSIZ, in) != NULL) {
		if (Buffer[0] == '\n') {
			if (NewLine == False) {
				fprintf(out, "\n");
				fprintf(out, "$NUMBER$ = \"%d\";\n", i++);
				NewLine = True;
				continue;
			} else
				continue;
		}
		NewLine = False;
		Buffer[strlen(Buffer)-1] = '\0'; /* zero out newline */
		switch(Buffer[1]) {
		case 'A':
		case 'a':
			fprintf(out, "Author = \"%s\";\n", Buffer+3);
			break;
		case 'H':
		case 'h':
			fprintf(out, "Header = \"%s\";\n", Buffer+3);
			break;
		case 'Q':
		case 'q':
			fprintf(out, "CorporateAuthor = \"%s\";\n",  Buffer+3);
			break;
		case 'T':
		case 't':
			fprintf(out, "Title = \"%s\";\n", Buffer+3);
			break;
		case 'S':
		case 's':
			fprintf(out, "SeriesTitle = \"%s\";\n", Buffer+3);
			break;
		case 'J':
		case 'j':
			fprintf(out, "Journal = \"%s\";\n", Buffer+3);
			break;
		case 'B':
		case 'b':
			fprintf(out, "Book = \"%s\";\n", Buffer+3);
			break;
		case 'R':
		case 'r':
			fprintf(out, "Report = \"%s\";\n", Buffer+3);
			break;
		case 'V':
		case 'v':
			fprintf(out, "Volume = \"%s\";\n", Buffer+3);
			break;
		case 'N':
		case 'n':
			fprintf(out, "Number = \"%s\";\n",  Buffer+3);
			break;
		case 'E':
		case 'e':
			fprintf(out, "Editor = \"%s\";\n",  Buffer+3);
			break;
		case 'P':
		case 'p':
			fprintf(out, "Page = \"%s\";\n",  Buffer+3);
			break;
		case 'I':
		case 'i':
			fprintf(out, "Publisher = \"%s\";\n",  Buffer+3);
			break;
		case 'C':
		case 'c':
			fprintf(out, "City = \"%s\";\n",  Buffer+3);
			break;
		case 'D':
		case 'd':
			fprintf(out, "Date = \"%s\";\n", Buffer+3);
			break;
		case 'O':
		case 'o':
			fprintf(out, "Commentary = \"%s\";\n", Buffer+3);
			break;
		case 'K':
		case 'k':
			fprintf(out, "Keywords = \"%s\";\n", Buffer+3);
			break;
		case 'L':
		case 'l':
			fprintf(out, "Label = \"%s\";\n", Buffer+3);
			break;
		case 'X':
		case 'x':
			fprintf(out, "Abstract = \"%s\";\n",  Buffer+3);
			break;
		default:
			fprintf(stderr, "Unknown command found: %%%c\n",
						Buffer[1]);
		}
	}
	fclose(in);
	fclose(out);
	exit(0);
}
