
/* qddb/Utils/qstab.c
 * Stab(ilize) the qddb Database by integrating all Changes and Additions
 * into the main stable Database.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

static int CheckAges(ch)
    char	*ch;
{
    char	f1[MAXPATHLEN], f2[MAXPATHLEN];
    struct stat	s1, s2;

    strcpy(f1,ch);
    strcat(f1,"/Database");
    strcpy(f2,ch);
    strcat(f2,"/Database.key");
    if (stat(f1, &s1) == -1)
	return -1;
    if (stat(f2, &s2) == -1)
	return -1;
    if (s1.st_mtime > s2.st_mtime)
	return -1;
    return 0;
}

void main(argc, argv)
    int		argc;
    char	*argv[];
{
    char	RelationFN[MAXFILENAMELEN], *rel;
    Schema	*ts;

    if (argc != 2) {
	fprintf(stderr, "Usage: %s Relation\n", argv[0]);
	exit(1);
    }
    qddb_stabilizing = 1;
    Qddb_Init();
    rel = Qddb_FindRelation(argv[1]);
    if (rel == NULL)
	PANIC("Cannot find relation, please set QDDBDIRS");
    strcpy(RelationFN, rel);
    if (CheckAges(RelationFN) == -1) {
	fprintf(stderr, "Run qkeys first.\n");
	exit(1);
    }
    ts = Qddb_InitSchema(RelationFN);
    if (ts == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    Qddb_BuildDatabase(ts);
#if defined(DEBUG_MALLOC)
    malloc_shutdown();
#endif
    exit(0);
}
