
/* qddb/Utils/qs.c
 * Interactively search a qddb database for records containing a list
 * of keys, i.e. the intersection of all sets of records generated by
 * finding all records with a particular key.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

#ifdef sequent
#include <usclkc.h>
#endif

void PrintKeyList _ANSI_ARGS_((Schema *, KeyList *, Boolean));

void main(argc, argv)
	int		argc;
	char		*argv[];
{
    Schema		*schema;
    char		String[BUFSIZ];
    char		Relation[BUFSIZ], *rel;
    KeyList		*list = NULL;
    size_t		Length;
    Qddb_SearchArg	search_args;
#ifdef sequent
    void 		usclk_init();
    usclk_t		Start, Finish, getusclk();

    usclk_init();
#endif
    if (argc != 2 && argc != 3) {
	fprintf(stderr, "Usage: %s Relation [p|n]\n", argv[0]);
	exit(1);
    }
    Qddb_Init();
    rel = Qddb_FindRelation(argv[1]);
    if (rel == NULL)
	PANIC("Cannot find relation, please set QDDBDIRS");
    strcpy(Relation, rel);
    schema = Qddb_InitSchema(Relation);
    if (schema == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    while (fgets(String, sizeof(String), stdin) != NULL) {
	char		*ptr;
	KeyList		*LastList = NULL;

	ptr = String;
	while (*ptr != '\0') {
	    char	*token;
	    
	    token = ptr;
	    while (!isspace(*ptr) && *ptr != '\0')
		ptr++;
	    if (*ptr != '\0') {
		*ptr++ = '\0';
		while (isspace(*ptr))
		    ptr++;
	    }
#ifdef sequent
	    Start = getusclk();
#endif	
	    search_args.Alpha = token;
	    search_args.Type  = ALPHA;
	    list = Qddb_Search(schema, &search_args, &Length, -1);
#ifdef sequent
	    Finish = getusclk();
	    fprintf(stdout, "Found %d items in %d microsec\n", 
		    Length, Finish-Start);
#endif
	    if (LastList != NULL)
		list = LastList = 
		    Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_INTERSECTION, 
				   QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY);
	    else
		LastList = list;
	}
	if ((argc == 3 && strcmp(argv[2],"-p") == 0) || (argc == 2))
	    PrintKeyList(schema, list, True);
	else if (argc == 3 && strcmp(argv[2],"-n") == 0)
	    PrintKeyList(schema, list, False);
    }	
    exit(0);
}

void PrintKeyList(schema, list, Print)
    Schema		*schema;
    KeyList		*list;
    Boolean		Print;
{
    char		*Buffer = Malloc(BUFSIZ), Valid;
    int			DBFile;
    unsigned		len = BUFSIZ;
#ifdef sequent
    void 		usclk_init();
    usclk_t		Start, Finish, getusclk();

    usclk_init();
#endif

    DBFile = OpenDatabase(schema->RelationName, 0);
    while (list != NULL) {
	switch(QDDB_KEYLIST_TYPE(list)) {
	case ORIGINAL:
	    if (list->Length > len) {
		len = list->Length;
		free(Buffer);
		Buffer = Malloc(len);
	    }
#ifdef sequent
	    Start = getusclk();
#endif
	    lseek(DBFile, list->Start, 0);
	    Read(DBFile, Buffer, list->Length);
#ifdef sequent
	    if (Print == False) {
		Finish = getusclk();
		fprintf(stdout, "Read entry in %d microsec\n", 
			Finish-Start);
	    }
#endif
	    sscanf(Buffer, "%%0 %c", &Valid);
	    if (Valid == 'I')
		break;
	    if (Print == True)
		Write(1, Buffer, list->Length);
	    break;
	case CHANGE:
	    if (Print == False)
		break;
	    sprintf(Buffer, "cat %s/Changes/%d", schema->RelationName, (int)list->Number);
	    system(Buffer);
	    break;
	case ADDITION:
	    if (Print == False)
		break;
	    sprintf(Buffer, "cat %s/Additions/%d", schema->RelationName, (int)list->Number);
	    system(Buffer);
	    break;
	default:
	    PANIC("BAD TYPE IN KeyList");
	}	
	if (Print == True)
	    write(1, "\n", 1);
	list = list->next;
    }
    free(Buffer);
    close(DBFile);
}
