
/* qddb/Utils/qprschema.c
 * Print the schema as a TCL list.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void main(argc, argv)
    int			argc;
    char		*argv[];
{
    Schema		*schema;
    char		Relation[BUFSIZ], *relname;
    int			i, j, k;

    if (argc < 2) {
	fprintf(stderr, "Usage: %s Relation\n", argv[0]);
	exit(1);
    }
    if ((relname = Qddb_FindRelation(argv[1])) == NULL) {
	fprintf(stderr, "cannot open schema '%s'\n", argv[1]);
	exit(1);
    }
    Qddb_Init();
    strcpy(Relation, relname);
    schema = Qddb_InitSchema(Relation);
    if (schema == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    for (i = 1; i < schema->NumberOfAttributes; i++) {
	for (j = 1; j < schema->Entries[i].Level; j++)
	    putchar('\t');
	if (schema->Entries[i].Level < schema->Entries[i+1].Level) {
	    printf("{ %s { \"%s\" %s } {\n", 
		   schema->Entries[i].Name,
		   schema->Entries[i].VerboseName,
		   schema->Entries[i].AsteriskPresent == True? "yes":"no");
	} else if (schema->Entries[i].Level >= schema->Entries[i+1].Level) {
	    printf("{ %s { \"%s\" %s } {} }",
		   schema->Entries[i].Name,
		   schema->Entries[i].VerboseName,
		   schema->Entries[i].AsteriskPresent == True? "yes":"no");
	    for (j = schema->Entries[i].Level-1; j >= schema->Entries[i+1].Level; j--) {
		putchar('\n');
		for (k = 1; k < j; k++)
		    putchar('\t');
		putchar('}');
		putchar('}');
	    }
	    putchar('\n');
	}
    }
    for (j = 1; j < schema->Entries[i].Level; j++)
	putchar('\t');
    printf("{ %s { \"%s\" %s } {} }\n",
	   schema->Entries[i].Name,
	   schema->Entries[i].VerboseName,
	   schema->Entries[i].AsteriskPresent == True? "yes":"no");
    for (j = schema->Entries[i].Level-1; j >= 1; j--) {
	putchar('\n');
	for (k = 1; k < j; k++)
	    putchar('\t');
	putchar('}');
	putchar('}');
    }
    putchar('\n');
    exit(0);
}
