
/* qddb/Utils/qkeys.c
 * Build the qddb keys file Database.keys.  The Database file must exist.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void main(argc, argv)
    int		argc;
    char	*argv[];
{
    Schema	*ts;
    char	*rel;

    if (argc != 2) {
	fprintf(stderr, "Usage: %s Relation\n", argv[0]);
	exit(1);
    }
    qddb_stabilizing = 1;
    Qddb_Init();
    rel = Qddb_FindRelation(argv[1]);
    if (rel == NULL) {
	fprintf(stderr, "%s: cannot find relation %s\n", argv[0], argv[1]);
	exit(1);
    }
    ts = Qddb_InitSchema(rel);
    if (ts == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    Qddb_MakeKeys(ts);
#if defined(DEBUG_MALLOC)
    malloc_shutdown();
#endif
    exit(0);
}
