
/* qddb/Utils/qchange.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void main(argc, argv)
    int			argc;
    char		*argv[];
{
    char		TmpFileName[MAXFILENAMELEN];
    char		Relation[MAXFILENAMELEN];
    char		*getenv(), *rel;
    Schema		*schema;
    char		*buf;
    Entry		ThisEntry = NULL;
    struct stat		statbuf;
    KeyListType		type;
    InCoreEntry		*incore;

    if (argc != 2) {
	fprintf(stderr, "Usage: %s RelationDirectory\n", argv[0]);
	exit(1);
    }
    Qddb_Init();
    if ((rel = Qddb_FindRelation(argv[1])) == NULL) {
	fprintf(stderr, "%s: cannot find relation %s\n", argv[0], argv[1]);
	exit(1);
    }
    strcpy(Relation, rel);
    schema = Qddb_InitSchema(Relation);
    if (schema == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    buf = Qddb_GetFile(fileno(stdin));
    incore = (InCoreEntry *)Qddb_Convert(schema, QDDB_ENTRYTYPE_TCLEXTERNAL, buf, QDDB_ENTRYTYPE_INTERNAL);
    if (incore == NULL)
	PANIC("Failed to convert TCLExternal to Internal format\n");
    Qddb_SortInCoreEntries(schema, incore); /* Sort the entry in case the TCL script doesn't */
    ThisEntry = (Entry)Qddb_Convert(schema, QDDB_ENTRYTYPE_INTERNAL, incore, QDDB_ENTRYTYPE_EXTERNAL);
    if (ThisEntry == NULL)
	PANIC("Failed to convert Internal To External format\n");
    sprintf(TmpFileName, "%s/Additions/%d", Relation, incore->SequenceNumber);
    if (stat(TmpFileName, &statbuf) == -1)
	type = CHANGE;
    else
	type = ADDITION;
    Qddb_InvalidateEntryByNumber(schema, (size_t)incore->SequenceNumber);
    Qddb_ChangeEntry(schema, -1, False, ThisEntry, type);
    exit(0);
}
