#!/bin/sh
# qddb/Utils/newdb.sh
# Create a new relation for qddb(1).
#
# Copyright (C) 1993, 1994 Herrin Software Development, Inc.
# All rights reserved.
#
# This file is part of Qddb.
#
# Qddb is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# as published by the Free Software Foundation.
#
# Qddb is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Qddb; see the file LICENSE.  If not, write to:
#
#	Herrin Software Development, Inc. 
#	R&D Division
#	41 South Highland Ave. 
#	Prestonsburg, KY 41653 
#
#

if [ $# -lt 1 ]
then
	echo Usage: $0 RelationsToCreate
	exit 1
fi
for i in $*
do
	if test -d $i ; then
		echo "Relation $i exists: remove it before running $0"
		exit 1
	fi
	mkdir $i
	mkdir $i/Additions
	mkdir $i/Changes
	cat /dev/null 	> $i/Database
	cat /dev/null 	> $i/Database.key
	cat /dev/null 	> $i/Index
	cat /dev/null 	> $i/KeyIndex
	cat /dev/null 	> $i/NumericIndex
	cat /dev/null 	> $i/HashTable
	cat /dev/null 	> $i/Schema
	echo 1 		> $i/Additions/NextEntry
done
echo "Remember to edit the Schema files for relations: "  $*
