
proc gp_writetemplate {} {
    global gv_mode_variable gv_status_variable gv_tuple gv_view gv_current_template gv_attr_pairs

    gp_file_select
    if {[llength $gv_current_template] > 0} {
	if {[catch [list open $gv_current_template w] fd] != 0} {
	    set gv_status_variable "Cannot open file $gv_current_template"
	    return
	}
	puts $fd [qddb_tuple get readable $gv_tuple]
	close $fd
	set gv_status_variable "Template successfully written."
    } else {
	set gv_status_variable "Template write cancelled."
    }
}

proc gp_readtemplate {} {
    global gv_mode_variable gv_status_variable gv_tuple gv_view gv_current_template gv_attr_pairs gv_schema
    global gv_status_msg

    gp_file_select
    if {[llength $gv_current_template] > 0} {
	if {[catch "set fd [open $gv_current_template r]"] != 0} {
	    set gv_status_variable "Cannot open file $gv_current_template"
	    return
	}
	set contents [read $fd]
	close $fd
	if {[catch [list qddb_tuple put readable $gv_schema $contents] new_tuple] != 0} {
	    set gv_status_variable "Bad input from file $gv_current_template"
	    set gv_status_msg $new_tuple
	    return
	}
	catch "qddb_tuple delete $gv_tuple"
	set gv_tuple $new_tuple
	set gv_view [qddb_view define $gv_tuple $gv_attr_pairs]
	gp_template_state last normal
	set gv_status_variable "Template successfully read."
    } else {
	set gv_status_variable "Template read cancelled."
    }
}

proc gp_lasttemplate {} {
    global gv_mode_variable gv_status_variable gv_tuple gv_view gv_current_template gv_attr_pairs gv_schema
    global gv_status_msg
    
    if {[llength $gv_current_template] > 0} {
	if {[catch "set fd [open $gv_current_template r]"] != 0} {
	    set gv_status_variable "Cannot open file $gv_current_template"
	    return
	}
	set contents [read $fd]
	close $fd
	if {[catch [list qddb_tuple put readable $gv_schema $contents] new_tuple] != 0} {
	    set gv_status_variable "Bad input from file $gv_current_template"
	    set gv_status_msg $new_tuple
	    return
	}
	catch "qddb_tuple delete $gv_tuple"
	set gv_tuple $new_tuple
	set gv_view [qddb_view define $gv_tuple $gv_attr_pairs]
	set gv_status_variable "Last template inserted."
    } else {
	set gv_status_variable "No last template, operation cancelled."
    }
}
