proc gp_manPage {} {
    global gv_qddb_lib_dir gv_qddb_version gv_config

    if {[winfo exists .manPage]} {
	wm withdraw .manPage
	wm deiconify .manPage
	update idletasks
        return
    }
    toplevel .manPage
    wm title .manPage "xqddb manual page"
    set x .manPage.buttons
    frame $x
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command "
	set [list gv_config(geom,\$manPage\$)] \[wm geometry .manPage\]
        destroy .manPage
    "
    pack $x.ok -fill x

    if {[string compare "[info commands pinfo]" ""] == 0} {
	label .manPage.qddb -bitmap @$gv_qddb_lib_dir/pixmaps/qddb.xbm
    } else {
	label .manPage.qddb -bitmap @$gv_qddb_lib_dir/pixmaps/qddb.xpm
    }
    pack .manPage.qddb -side top

    message .manPage.label -justify center -aspect 400 \
	-text "xqddb(1) Manual Page"
    pack .manPage.label -side top

    message .manPage.version -justify center -aspect 400 \
        -text "Quick and Dirty DataBase\nVersion ${gv_qddb_version}\n"
    pack .manPage.version -side top

    message .manPage.copyright -justify center -aspect 400 \
	-text "Copyright(c) 1993, 1994\nHerrin Software Development, Inc.\nAll rights reserved.\n" 
    pack .manPage.copyright -side top

    set fd [open $gv_qddb_lib_dir/xqddb.0 "r"]
    set MAN [read $fd]
    close $fd
    set x .manPage.f
    frame $x
    pack $x -side top -expand on -fill both
    scrollbar $x.s -orient vertical -relief sunken -command [list $x.c yview]
    pack $x.s -side right -fill y
    text $x.c -relief sunken -bd 2 -yscroll [list $x.s set] -wrap word -setgrid on
    pack $x.c -side left -expand on -fill both
    $x.c insert 0.0 $MAN
    $x.c configure -state disabled
    if {[info exists gv_config(geom,\$manPage\$)]} {
	wm geometry .manPage $gv_config(geom,\$manPage\$)
    } else {
	wm geometry .manPage +70+0
    }
}

