proc gp_faqBox {} {
    global gv_qddb_lib_dir gv_qddb_version gv_default_font gv_config qddb_library

    if {[winfo exists .faqBox]} {
	wm withdraw .faqBox
	wm deiconify .faqBox
	update idletasks
        return
    }
    toplevel .faqBox
    wm title .faqBox "Qddb Frequently Asked Questions"
    set x .faqBox.buttons
    frame $x
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command "
	set [list gv_config(geom,\$faqBox\$)] \[wm geometry .faqBox\]
        destroy .faqBox
    "
    pack $x.ok -fill x

    if {[string compare "[info commands pinfo]" ""] == 0} {
	label .faqBox.qddb -bitmap @$gv_qddb_lib_dir/pixmaps/qddb.xbm
    } else {
	label .faqBox.qddb -bitmap @$gv_qddb_lib_dir/pixmaps/qddb.xpm
    }
    pack .faqBox.qddb -side top

    message .faqBox.faq -justify center -aspect 400 \
	-text "Frequently Asked Questions"
    pack .faqBox.faq -side top

    message .faqBox.version -justify center -aspect 400 \
        -text "Quick and Dirty DataBase\nVersion ${gv_qddb_version}\n"
    pack .faqBox.version -side top

    message .faqBox.copyright -justify center -aspect 400 \
	-text "Copyright(c) 1993, 1994\nHerrin Software Development, Inc.\nAll rights reserved.\n" 
    pack .faqBox.copyright -side top

    set fd [open $qddb_library/FAQ "r"]
    set FAQ [read $fd]
    close $fd
    set x .faqBox.f
    frame $x
    pack $x -side top -expand on -fill both
    scrollbar $x.s -orient vertical -relief sunken -command [list $x.c yview]
    pack $x.s -side right -fill y
    text $x.c -font $gv_default_font -relief sunken -bd 2 -yscroll [list $x.s set] -wrap word -setgrid on
    pack $x.c -side left -expand on -fill both
    $x.c insert 0.0 $FAQ
    $x.c configure -state disabled
    if {[info exists gv_config(geom,\$faqBox\$)]} {
	wm geometry .faqBox $gv_config(geom,\$faqBox\$)
    } else {
	wm geometry .faqBox +70+0
    }
}

