
proc gp_nullop {{n1 ""} {n2 ""} {op ""}} {
}


proc gp_bindmod {} {
    global gv_entryname
    
    foreach i [array names gv_entryname] {
        if {[string compare [winfo class $gv_entryname($i)] Entry] == 0} {
	    bind $gv_entryname($i) <Return> [bind $gv_entryname($i) <Tab>]
	    bind $gv_entryname($i) <Down> [bind $gv_entryname($i) <Tab>]
	    bind $gv_entryname($i) <Up> [bind $gv_entryname($i) <Shift-Tab>]
	    bind $gv_entryname($i) <Control-n> [bind $gv_entryname($i) <Tab>]
	    bind $gv_entryname($i) <Control-p> [bind $gv_entryname($i) <Shift-Tab>]
	    bind $gv_entryname($i) <FocusOut> [list gp_typecheck $i]
	}
    }
}


proc gp_bindsearch {} {
    global gv_entryname

    foreach i [array names gv_entryname] {
        if {[string compare [winfo class $gv_entryname($i)] Entry] == 0} {
	    bind $gv_entryname($i) <Return> {gp_search}
	    bind $gv_entryname($i) <Down> [bind $gv_entryname($i) <Tab>]
	    bind $gv_entryname($i) <Up> [bind $gv_entryname($i) <Shift-Tab>]
	    bind $gv_entryname($i) <Control-n> [bind $gv_entryname($i) <Tab>]
	    bind $gv_entryname($i) <Control-p> [bind $gv_entryname($i) <Shift-Tab>]
	    bind $gv_entryname($i) <FocusOut> {gp_nullop}
	}
    }
}


proc gp_bindent {} {
    global gv_attr gv_schema gv_entryname gv_searchbox_name gv_cutbuffer gv_thack

    set leaves [qddb_schema leaves $gv_schema]
    set len [llength $leaves]
    incr len -1
    for {set i 1} {$i < $len} {incr i} {
	bind $gv_entryname([lindex $leaves $i]) <Tab> \
	    [list focus $gv_entryname([lindex $leaves [expr $i + 1]])]
	bind $gv_entryname([lindex $leaves [expr $i + 1]]) <Shift-Tab> \
	    [list focus $gv_entryname([lindex $leaves $i])]
    }
    bind $gv_searchbox_name <Tab> \
	[list focus $gv_entryname([lindex $leaves 0])]
    bind $gv_searchbox_name <Down> \
	[list focus $gv_entryname([lindex $leaves 0])]
    bind $gv_searchbox_name <Control-n> \
	[list focus $gv_entryname([lindex $leaves 0])]
    bind $gv_searchbox_name <Shift-Tab> {}
    bind $gv_entryname([lindex $leaves 0]) <Tab> \
	[list focus $gv_entryname([lindex $leaves 1])]
    bind $gv_entryname([lindex $leaves 1]) <Shift-Tab> \
	[list focus $gv_entryname([lindex $leaves 0])]
    bind $gv_entryname([lindex $leaves $len]) <Tab> \
	[list focus $gv_entryname([lindex $leaves 0])]
    bind $gv_entryname([lindex $leaves 0]) <Shift-Tab> \
        [list focus $gv_searchbox_name]
    bind Entry <Any-Control-Key> {gp_nullop}
    bind Text <Any-Control-Key> {gp_nullop}
    bind Entry <Any-Alt-Key> {gp_nullop}
    bind Text <Any-Alt-Key> {gp_nullop}    
    bind Text <Any-Key> {
	if {[string length %A] > 0} {
	    %W insert insert %A
	    set gv_thack(%W) ""
	    %W yview -pickplace insert
	}
    }
    bind Text <Control-a> {
	%W mark set insert [%W index {insert linestart}]
	%W yview -pickplace insert
    }
    bind Entry <Control-a> {
        %W icursor 0
        %W view 0
    }
    bind Text <Control-e> {
	%W mark set insert [%W index {insert lineend}]
	%W yview -pickplace insert
    }
    bind Entry <Control-e> {
        %W icursor end
        %W view [expr [%W index end] - [lindex [%W configure -width] 4]]
    }
    set comm {
        if {[catch "%W index sel.first"] == 0} {
            set gv_cutbuffer [string range [%W get] [%W index sel.first] [%W index sel.last]]
            %W delete sel.first sel.last
        }
    }
    bind Entry <Control-w> $comm
    bind Entry <Key-Delete> $comm
    set comm {
        if {[catch "%W index sel.first"] == 0} {
            set gv_cutbuffer [%W get [%W index sel.first] [%W index sel.last]]
            %W delete [%W index sel.first] [%W index sel.last]
	    set gv_thack(%W) ""
	    %W yview -pickplace insert
        }
    }
    bind Text <Control-w> $comm
    bind Text <Key-Delete> $comm

    bind Entry <Alt-w> {
        if {[catch "%W index sel.first"] == 0} {
            set gv_cutbuffer [string range [%W get] [%W index sel.first] [%W index sel.last]]
        }
    }
    bind Text <Alt-w> {
        if {[catch "%W index sel.first"] == 0} {
            set gv_cutbuffer [%W get [%W index sel.first] [%W index sel.last]]
        }
    }
    bind Entry <Control-d> {
        %W delete [%W index insert]
    }
    bind Text <Control-d> {
        %W delete [%W index insert]
	set gv_thack(%W) ""
	%W yview -pickplace insert
    }
    bind Entry <Control-y> {
        %W insert insert $gv_cutbuffer
    }
    bind Text <Control-y> {
        %W insert insert $gv_cutbuffer
	set gv_thack(%W) ""
	%W yview -pickplace insert
    }
    bind Entry <Button-3> {
        if {[catch "selection get"] == 0} {
            %W insert insert [selection get]
        }
    }
    bind Text <Button-3> {
        if {[catch "selection get"] == 0} {
            %W insert insert [selection get]
	    set gv_thack(%W) ""
	    %W yview -pickplace insert
        }
    }
    set comm {
        %W icursor [expr [%W index insert] + 1]
        set w [lindex [%W configure -width] 4]
        if {[%W index insert] > [expr [%W index @0] + $w]} {
            %W view [expr [%W index insert] - $w]
        }
    }
    bind Entry <Control-f> $comm
    bind Entry <Key-Right> $comm
    set comm {
	%W mark set insert [%W index {insert + 1 c}]
	%W yview -pickplace insert
    }
    bind Text <Control-f> $comm
    bind Text <Key-Right> $comm
    set comm {
        %W icursor [expr [%W index insert] - 1]
        if {[%W index insert] < [%W index @0]} {
            %W view [%W index insert]
        }
    }
    bind Entry <Control-b> $comm
    bind Entry <Key-Left> $comm
    set comm {
	%W mark set insert [%W index {insert - 1 c}]
	%W yview -pickplace insert
    }
    bind Text <Control-b> $comm
    bind Text <Key-Left> $comm
    bind Entry <Control-k> {
        set gv_cutbuffer [string range [%W get] [%W index insert] [%W index end]]
        %W delete insert end
    }
    bind Text <Control-k> {
	set tmpbuf [%W get [%W index insert] [%W index {insert lineend}]]
	if {[string length $tmpbuf] > 0} {
	    set gv_cutbuffer $tmpbuf
	    %W delete insert [%W index {insert lineend}]
	} else {
	    append gv_cutbuffer "\n"
	    %W delete insert
	}
	set gv_thack(%W) ""
    }
    bind Text <Return> {
	%W insert insert "\n"
	set gv_thack(%W) ""
	%W yview -pickplace insert
    }
    set comm {
	%W mark set insert [%W index {insert + 1 l}]
	%W yview -pickplace insert
    }
    bind Text <Key-Down> $comm
    bind Text <Control-n> $comm
    set comm {
	%W mark set insert [%W index {insert - 1 l}]
	%W yview -pickplace insert
    }
    bind Text <Key-Up> $comm
    bind Text <Control-p> $comm
    bind Text <Control-o> {
	%W insert insert "\n"
        %W mark set insert [%W index {insert - 1 c}]
	set gv_thack(%W) ""
    }
    bind Text <Control-h> {
	%W mark set insert [%W index {insert - 1 c}]
	%W delete [%W index insert]
	%W yview -pickplace insert
	set gv_thack(%W) ""
    }
    bind Text <Key-BackSpace> {
	%W mark set insert [%W index {insert - 1 c}]
	%W delete [%W index insert]
	%W yview -pickplace insert
	set gv_thack(%W) ""
    }
    bind Text <Alt-Shift-less> {
	%W mark set insert 0.0
	%W yview -pickplace 0.0
    }
    bind Text <Alt-Shift-greater> {
	%W mark set insert end
	%W yview -pickplace end
    }
    trace variable gv_attr wu {gp_set_tuple_changed}
}

proc gp_emacs_bindings {e} {
    bind $e <Any-Control-Key> {gp_nullop}
    bind $e <Any-Alt-KeyPress> {gp_nullop}
    bind $e <Any-Alt-KeyRelease> {gp_nullop}
    bind $e <Control-a> {
        %W icursor 0
        %W view 0
    }
    bind $e <Control-u> {
	%W delete 0 insert
    }
    bind $e <Control-h> {
	%W icursor [expr [%W index insert] - 1]
	%W delete insert
    }
    bind $e <Control-e> {
        %W icursor end
        %W view [expr [%W index end] - [lindex [%W configure -width] 4]]
    }
    set comm {
        if {[catch "%W index sel.first"] == 0} {
            set gv_cutbuffer [string range [%W get] [%W index sel.first] [%W index sel.last]]
            %W delete sel.first sel.last
        }
    }
    bind $e <Control-w> $comm
    bind $e <Key-Delete> $comm
    bind $e <Alt-w> {
        if {[catch "%W index sel.first"] == 0} {
            set gv_cutbuffer [string range [%W get] [%W index sel.first] [%W index sel.last]]
        }
    }
    bind $e <Control-d> {
        %W delete [%W index insert]
    }
    bind $e <Control-y> {
        %W insert insert $gv_cutbuffer
    }
    bind $e <Button-3> {
        if {[catch "selection get"] == 0} {
            %W insert insert [selection get]
        }
    }
    set comm {
        %W icursor [expr [%W index insert] + 1]
        set w [lindex [%W configure -width] 4]
        if {[%W index insert] > [expr [%W index @0] + $w]} {
            %W view [expr [%W index insert] - $w]
        }
    }
    bind $e <Control-f> $comm
    bind $e <Key-Right> $comm
    set comm {
        %W icursor [expr [%W index insert] - 1]
        if {[%W index insert] < [%W index @0]} {
            %W view [%W index insert]
        }
    }
    bind $e <Control-b> $comm
    bind $e <Key-Left> $comm
    bind $e <Control-k> {
        set gv_cutbuffer [string range [%W get] [%W index insert] [%W index end]]
        %W delete insert end
    }
}

proc gp_bind_menubutton {w accel accel_type cmd} {
    bind $w <ButtonPress-2> {gp_nullop}
    bind $w <ButtonPress-1> "
        if {\[string compare \[lindex \[$w configure -state\] 4\] disabled\] != 0} {
            $w configure -relief sunken -state active
            update
        }
    "
    bind $w <ButtonRelease-1> "
        if {\[string compare \[lindex \[$w configure -state\] 4\] disabled\] != 0} {
            $w configure -relief raised -state normal
            update
            $cmd
        }
    "
    foreach i $accel_type {
        bind $i <Alt-KeyPress-$accel> "
            if {\[string compare \[lindex \[$w configure -state\] 4\] disabled\] != 0} {
               $w configure -relief sunken -state active
               update
            }
        "
        bind $i <Alt-KeyRelease-$accel> "
            if {\[string compare \[lindex \[$w configure -state\] 4\] disabled\] != 0} {
                $w configure -relief raised -state normal
                update
                $cmd
            }
        "
    }
}
