# fx_widgets.tcl
#
# Fx Toolkit for Qddb widgets

itcl_class Fx_Attribute {
    global qddb_library

    constructor {config} {
	global fx_config

	if {![info exists attr]} {
	    error "Fx_Attribute: you must specify -attr"
	}
	if {![info exists label]} {
	    set verbosename [qddb_schema option verbosename $schema $attr]
	    if {[string compare $verbosename ""] == 0} {
		set label [split $attr .]
		set label [lindex $label [expr [llength $label] - 1]]
	    } else {
		set label $verbosename
	    }
	}
	set isexpandable [qddb_schema option isexpandable $schema $attr]
	foreach i {label labelfg helpmsg padx pady side} {
	    if {[info exists fx_config(entry,$i,$attr)]} {
		set $i $fx_config(entry,$i,$attr)
	    } else {
		set fx_config(entry,$i,$attr) [set $i]
	    }
	}
	if {![info exists fx_config($attr,ascending)]} {
	    set leaves [qddb_schema leaves $schema $attr]
	    set fx_config($attr,print) [lrange $leaves 0 4]
	    set fx_config($attr,alignment) {}
	    set fx_config($attr,widths) {}
	    set fx_config($attr,separators) {}
	    foreach i $fx_config($attr,print) {
		lappend fx_config($attr,alignment) left
		lappend fx_config($attr,widths) 0
		lappend fx_config($attr,separators) ""
	    }
	    set fx_config($attr,dontprint) [lrange $leaves 5 end]
	    set fx_config($attr,sortby) $leaves
	    set fx_config($attr,ascending) {}
	    foreach i $fx_config($attr,sortby) {
		lappend fx_config($attr,ascending) yes
	    }
	}
    }
    destructor {
	catch "destroy $w"
    }

    method BuildFrame {} {
	frame $w -relief $relief -bd $bd
	pack $w -expand on -fill both -padx $padx -pady $pady
	frame $w.f_0
	pack $w.f_0 -side $side -anchor $anchor
	if {[string compare [tk colormodel .] monochrome] == 0} {
	    set monomode 1
	} else {
	    set monomode 0
	}
	label $w.f_0.l -text $label -anchor e
	if {$monomode == 0} {
	    $w.f_0.l configure -fg $labelfg
	}
	pack $w.f_0.l -side left -anchor ne
	if {[string compare [qddb_schema option isexpandable $schema $attr] yes] == 0} {
	    if {$showbutton_add} {
		if {[string compare [string index $b_add 0] @] == 0} {
		    set what bitmap
		} else {
		    set what text
		}
		button $w.f_0.b_add -$what $b_add -relief raised -bd 2 \
		    -command [list $this AddInstance]
		if {$monomode == 0} {
		    $w.f_0.b_add configure -fg $labelfg
		}
		pack $w.f_0.b_add -side left -anchor ne
		lappend buttons $w.f_0.b_add
		lappend adddeletebuttons $w.f_0.b_add
	    }
	    if {$showbutton_view} {
		if {[string compare [string index $b_view 0] @] == 0} {
		    set what bitmap
		} else {
		    set what text
		}
		button $w.f_0.b_view -$what $b_view -relief raised -bd 2 \
		    -command [list $this ViewInstance]
		if {$monomode == 0} {
		    $w.f_0.b_view configure -fg $labelfg
		}
		pack $w.f_0.b_view -side left -anchor ne
		lappend buttons $w.f_0.b_view
	    }
	    if {$showbutton_del} {
		if {[string compare [string index $b_del 0] @] == 0} {
		    set what bitmap
		} else {
		    set what text
		}
		button $w.f_0.b_del -$what $b_del -relief raised -bd 2 \
		    -command [list $this DelInstance]
		if {$monomode == 0} {
		    $w.f_0.b_del configure -fg $labelfg
		}
		pack $w.f_0.b_del -side left -anchor ne
		lappend buttons $w.f_0.b_del
		lappend adddeletebuttons $w.f_0.b_del
	    }
	}
    }
    proc DisableButtons {} {
	if {[info exists buttons]} {
	    foreach i $buttons {
		$i configure -state disabled
	    }
	}
    }
    proc DisableAddDeleteButtons {} {
	if {[info exists adddeletebuttons]} {
	    foreach i $adddeletebuttons {
		$i configure -state disabled
	    }
	}
    }
    proc EnableButtons {} {
	if {[info exists buttons]} {
	    foreach i $buttons {
		$i configure -state normal
	    }
	}
    }
    method AddInstance {} {
	global $array

	if {[Fx:CheckMandatoryFields $schema $attr $array]} {
	    return
	}
	if {[Fx:CurrentTypeCheck $schema] || [Fx:CurrentUniqueCheck $schema]} {
	    return
	}
	if {[info exists beforeadd]} {
	    eval $beforeadd
	}
	if {[info exists copy_instances]} {
	    set leaves [qddb_schema leaves $schema $attr]
	    if {[llength $leaves] > 1} {
		set leaves $copy_instances
	    } elseif {$copy_instances == 0} {
		set leaves {}
	    }
	    foreach i $leaves {
		set leaftmp($i) [set ${array}($i)]
	    }
	}
	if {$addtoend} {
	    set newinst [qddb_instance new $view $attr]
	    qddb_instance switch $view $attr $newinst
	} else {
	    set newinst [qddb_instance new $view $attr]
	    qddb_instance move $view $attr $newinst 1
	    qddb_instance switch $view $attr 1
	}
	if {[info exists copy_instances]} {
	    foreach i $leaves {
		uplevel \#0 [list set ${array}($i) $leaftmp($i)]
	    }
	}
	focus $focus
	if {[info exists afteradd]} {
	    eval $afteradd
	}
	ReconfigureViewsBelow
	TupleChanged 1
    }
    method DelInstance {} {
	global $array

	if {[fx_dialog .dialog "Deleting Instance" "Are you sure you want to delete?" \
		 warning 0 Cancel Ok] == 0} {
	    return
	}
	if {[info exists beforedelete]} {
	    eval $beforedelete
	}
	set curnum [qddb_instance current $view $attr]
	if {[qddb_instance isempty $view $attr $curnum] == 0 || [qddb_instance maxnum $view $attr] > 1} {
	    qddb_instance remove $view $attr $curnum
	    if {[info exists afterdelete]} {
		eval $afterdelete
	    }
	    ReconfigureViewsBelow
	    TupleChanged 1
	}
	focus $focus
    }
    method BuildInst {} {
	set namelist [split $attr "."]
	set len [llength $namelist]
	incr len -1
	set buildinst ""
	for {set i 0} {$i < $len} {incr i} {
	    if {$i == 0} {
		set attribute [lindex $namelist 0]
	    } else {
		set attribute [join [lrange $namelist 0 $i] "."]
	    }
	    set cur [qddb_instance current $view $attribute]
	    if {[string compare $buildinst ""] != 0} {
		set buildinst [join [list $buildinst $cur] "."]
	    } else {
		set buildinst $cur
	    }
	}
	return [join [list $attr $buildinst] ","]
    }
    method ViewInstance {{reconfig 0}} {
	global fx_config

	if {[Fx:CheckMandatoryFields $schema $attr $array]} {
	    return
	}
	if {[Fx:CurrentTypeCheck $schema] || [Fx:CurrentUniqueCheck $schema]} {
	    return
	}
	set oldfocus [focus]
	set transattr [split $attr .]
	set transattr [string tolower [join $transattr _]]
	if {!$reconfig} {
	    if {[winfo exists .view_$transattr]} {
		if {[info exists fx_config(geom,search_results_config)]} {
		    wm geometry .view_$transattr $fx_config(geom,view_$transattr)
		}
		wm withdraw .view_$transattr
		wm deiconify .view_$transattr
		ReconfigureViewsBelow
		return
	    } else {
		set verbosename [qddb_schema option verbosename $schema $attr]
		if {[string compare $verbosename ""] == 0} {
		    set verbosename [split $attr .]
		    set verbosename [lindex $verbosename [expr [llength $verbosename] - 1]]
		}
	    }
	}
	set asc {}
	set x 0
	foreach i $fx_config($attr,ascending) {
	    if {[string compare $i yes] == 0} {
		lappend asc [lindex $fx_config($attr,sortby) $x] 
	    }
	    incr x
	}
	if {[info exists fx_config($attr,unsorted)] && $fx_config($attr,unsorted)} {
	    set r [qddb_rows all -instance [BuildInst] -attrs $fx_config($attr,print) \
		    -print $fx_config($attr,print) $tuple]
	} else {
	    set r [qddb_rows all -sortby $fx_config($attr,sortby) -ascending $asc \
		    -instance [BuildInst] -attrs $fx_config($attr,print) \
		    -print $fx_config($attr,print) $tuple]
	}
	set rows {}
	foreach i $r {
	    lappend rows [lindex $i 0]
	}
	set headings {}
	foreach i $fx_config($attr,print) {
	    set verb [qddb_schema option verbosename $schema $i]
	    if {[llength $verb] == 0} {
		set verb [split $i .]
		set verb [lindex $verb [expr [llength $verb] - 1]]
	    }
	    lappend headings $verb
	}
	set x 0
	foreach i $headings {
	    set maxwid($x) 0
	    incr x
	}
	set srt $rows
	set res {}
	foreach i $srt {
	    set tmp [qddb_rows getval $fx_config($attr,print) $i]
	    lappend res $tmp
	    set x 0
	    foreach j $tmp {
		set slen [string length $j]
		if {$slen > $maxwid($x)} {
		    set maxwid($x) $slen
		}
		incr x
	    }
	}
	set x 0
	foreach i $headings {
	    set slen [string length $i]
	    if {$slen > $maxwid($x)} {
		set maxwid($x) $slen
	    }
	    incr x
	}
	if {[info exists fx_config($attr,widths)]} {
	    set widths2 {}
	    for {set i 0} {$i < $x} {incr i} {
		set tmp [lindex $fx_config($attr,widths) $i]
		if {[string compare $tmp ""] == 0} {
		    puts "whoops: $i"
		}
		if {$tmp == 0} {
		    lappend widths2 $maxwid($i)
		} else {
		    lappend widths2 $tmp
		}
	    }
	} else {
	    set widths2 {}
	    for {set i 0} {$i < $x} {incr i} {
		lappend widths2 $maxwid($i)
	    }
	}
	if {$reconfig} {
	    set curselect [.view_$transattr.f.l2 curselection]
	    set nearesty  [.view_$transattr.f.l2 nearest 0]
	    view_$transattr ClearRows
	    view_$transattr ClearContents
	    view_$transattr configure -widths $widths2 \
		    -headings $headings -numcols [llength $headings] \
		    -align $fx_config($attr,alignment) \
		    -width 60 \
		    -separators $fx_config($attr,separators) \
		    -single_select on \
		    -exportselection off
	    view_$transattr BuildFormats
	} else {
	    toplevel .view_$transattr
	    wm title .view_$transattr "Viewing: $verbosename"
	    if {[info exists fx_config(geom,view_$transattr)]} {
		wm geometry .view_$transattr $fx_config(geom,view_$transattr)
	    }
	    set f .view_$transattr.f2
	    frame $f
	    pack $f -side bottom -expand on -fill x
	    button $f.select -text Select -command [list view_$transattr OnSelect]
	    pack $f.select -side left -padx 10m -pady 2m -ipadx 10m -ipady 2m
	    button $f.cancel -text Close \
		    -command [list catch "destroy .view_$transattr; view_$transattr delete"]
	    pack $f.cancel -side left -padx 10m -pady 2m -ipadx 10m -ipady 2m
	    button $f.print -text Print -command \
		    [list $this PrintCmd "view_$transattr GetFormattedContents" .view_$transattr]
	    pack $f.print -side right -padx 10m -pady 2m -ipadx 10m -ipady 2m
	    checkbutton $f.pin -text Pin -variable fx_config(pin,view_$transattr) -onvalue 1 -offvalue 0
	    pack $f.pin -side right -padx 10m -pady 2m -ipadx 10m -ipady 2m
	    Fx_MultiColumnListBox view_$transattr -w .view_$transattr.f -widths $widths2 \
		    -headings $headings -numcols [llength $headings] \
		    -align $fx_config($attr,alignment) \
		    -width 60 \
		    -separators $fx_config($attr,separators) \
		    -single_select on \
		    -exportselection off \
		    -height 10 -onselect [list $this PinnedViewProc view_$transattr]
	    set current_views(view_$transattr) $this
	}
	view_$transattr AppendRows $res
	view_$transattr Format
	view_$transattr Display
	if {$reconfig} {
	    .view_$transattr.f.l2 select from $curselect
	    .view_$transattr.f.l2 select to $curselect
	    .view_$transattr.f.l2 yview $nearesty
	}
	bind .view_$transattr <FocusIn> [list view_$transattr FocusSelect]
	bind .view_$transattr <Configure> [list $this ConfigureWindow $transattr]
	if {[info exists fx_config(geom,view_$transattr)]} {
	    wm geometry .view_$transattr $fx_config(geom,view_$transattr)
	}
	if {!$reconfig} {
	    tkwait window .view_$transattr.f
	    catch "view_$transattr delete"
	    catch "unset current_views(view_$transattr)"
	    catch "destroy .view_$transattr"
	    catch "focus $oldfocus"
	}
	update idletasks
    }
    proc KillAllViews {} {
	if {[info exists current_views]} {
	    foreach i [array names current_views] {
		catch "destroy .${i}.f"
		catch "$i delete"
		catch "unset current_views($i)"
		catch "destroy .$i"
	    }
	    catch "unset current_views"
	}
    }
    method ReconfigureViewsBelow {} {
	if {[info exists current_views]} {
	    set transattr [split $attr .]
	    set transattr [string tolower [join $transattr _]]
	    foreach i [array names current_views] {
		if {[string match view_${transattr}* ${i}] == 1} {
		    set myinst $current_views($i)
		    $myinst ViewInstance 1
		}
	    }
	    update idletasks
	}
    }
    method ConfigureWindow {transattr} {
	global fx_config
	set fx_config(geom,view_$transattr) [wm geometry .view_$transattr]
    }
    method PinnedViewProc {inst i} {
	global fx_config

	if {![info exists fx_config(pin,$inst)] || $fx_config(pin,$inst) == 0} {
	    $this SelectRow $i
	    catch "destroy .$inst.f"
	    catch "$inst delete"
	    catch "destroy .$inst"
	} else {
	    $this SelectRow $i
	    $inst FocusSelect
	}
    }
    method PrintCmd {contents t} {
	global fx_config fx:status_variable fx_blt

	Fx_PrintDialog ${this}_print_dialog
	if {$fx_config(cancel_print) == 0} {
	    if {$fx_blt} {
		blt_busy hold .
		if {[winfo exists ${t}]} {
		    blt_busy hold $t
		}
	    }
	    update idletasks
	    update
	    Fx:Print [eval $contents]
	    if {$fx_blt} {
		blt_busy forget .
		if {[winfo exists $t]} {
		    blt_busy forget $t
		}
	    }
	    update idletasks
	    update
	} else {
	    set fx:status_variable "Printing cancelled."
	}
    }
    method SelectRow {i} {
	set oldchanged [TupleChanged]
	if {[info exists beforechange]} {
	    eval $beforechange
	}
	qddb_view set $view [lindex $rows $i]
	if {[info exists afterchange]} {
	    eval $afterchange
	}
	TupleChanged $oldchanged
	ReconfigureViewsBelow
    }
    proc TupleChanged {{val ""} {n1 ""} {n2 ""} {op ""}} {
	if {[string compare $val ""] == 0} {
	    return $tuple_changed
	} else {
	    set tuple_changed $val
	}
    }
    method configure {config} {
    }

    # Generic Qddb stuff
    common schema
    public setschema {} {set schema $setschema}
    common view
    public setview {} {set view $setview}
    common tuple
    public settuple {} {set tuple $settuple}
    public attr
    public copy_instances
    protected rows {}
    common tuple_changed 0
    protected isexpandable
    protected verbosename
    common current_views

    # On-events
    public beforedelete
    public beforeadd
    public beforechange
    public afterdelete
    public afteradd
    public afterchange
    public addtoend 1

    # Label stuff
    public label
    public labelfg blue
    public helpmsg "No help available for this field"

    public array gv_attr

    # Button stuff
    common b_add Add
    common b_view View
    common b_del Del
    public showbutton_add 1
    public showbutton_del 1
    public showbutton_view 1
    public button_add $b_add {set b_add $button_add}
    public button_view $b_view {set b_view $button_view}
    public button_del $b_del {set b_del $button_del}
    common buttons
    common adddeletebuttons

    # Frame stuff
    public w
    public padx 1m
    public pady 1m
    public side left
    public anchor w
    public relief flat
    public bd 2
    public focus none
}

itcl_class Fx_Frame {
    inherit Fx_Attribute

    constructor {config} {
	Fx_Attribute::constructor
	lappend instances $this
	BuildFrame
	bind $w.f_0.l <Control-Button-3> [list $this Reconfigure]
    }
    destructor {
	Fx_Attribute::destructor
    }
    method Reconfigure {} {
	Fx:ConfigureEntry $schema $attr
    }
    proc GetInstances {} {
	return $instances
    }
    common instances {}
}

itcl_class Fx_Entry {
    inherit Fx_Attribute

    constructor {config} {
	global fx_config

	Fx_Attribute::constructor
	lappend instances $this
	foreach i {entryfg height width default_values type read_only mandatory unique} {
	    if {[info exists fx_config($attr,$i)]} {
		set $i $fx_config($attr,$i)
	    } else {
		if {[info exists $i]} {
		    set fx_config($attr,$i) [set $i]
		}
	    }
	}
	if {[info exists array]} {
	    global $array

	    set textvariable ${array}(${attr})
	    set $textvariable ""
	    uplevel \#0 [list trace variable $textvariable w [list Fx_Entry :: TupleChanged 1]]
	}
	foreach i {regexp_search range_search numeric_search date_search} {
	    if {![info exists fx_config(\$$i\$,$attr)]} {
		if {[set $i] == 1} {
		    set $i 1
		} else {
		    set $i 0
		}
	    } else {
		set $i $fx_config(\$$i\$,$attr)
	    }
	    set fx_config(\$$i\$,$attr) [set $i]
	}
	set mytabstop $tabtop
	set tab_array($tabtop) $w.e
	BuildFrame
	BuildEntry
	bind $w.f_0.l <Control-Button-3> [list $this Reconfigure]
	if {![info exists firstentry]} {
	    set firstentry $this
	    if {[info exists common_searchfor_entry]} {
		bind $common_searchfor_entry <Tab> [list $this GoToNext -1 0]
		bind $common_searchfor_entry <Shift-Tab> [list $this GoToLast 0]
	    }
	}
	incr tabtop
	if {[qddb_schema option exclude $schema $attr]} {
	    lappend excluded_entries $w.e
	}
    }
    destructor {
	if {[info exists textvariable]} {
	    global $array fx_thack

	    uplevel \#0 [list trace vdelete $textvariable w {Fx_Entry :: TupleChanged 1}]
	    uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
	    uplevel \#0 [list trace vdelete fx_thack($w.e) w [list $this RefreshTextVar]]
	}
	destroy $w
    }
    
    method GoToLast {checks} {
	global fx:mode_variable
	global fx:search_modeval fx:readonly_modeval
	if {$checks && [string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
		[string compare ${fx:mode_variable} ${fx:readonly_modeval}] != 0} {
	    if {[Fx:TypeCheck $schema $attr $w.e]} {
		return
	    }
	    if {[info exists unique] && $unique} {
		if {[Fx:UniqueCheck $schema $attr $w.e]} {
		    return
		}
	    }
	}
	set tabstop [expr $tabtop - 1]
	while {[info exists tab_array($tabstop)]} {
	    set class [winfo class $tab_array($tabstop)]
	    if {[winfo exists $tab_array($tabstop).r0]} {
		incr tabstop $increment
		continue
	    }
	    if {[string compare [lindex [$tab_array($tabstop) configure -state] 4] disabled] != 0} {
		if {[string compare $class Entry] == 0} {
		    focus $tab_array($tabstop)
		    return
		} elseif {[string compare $class Text] == 0} {
		    focus $tab_array($tabstop)
		    return
		}
	    }
	    incr tabstop -1
	}
    }
    method GoToNext {tabstop checks {increment 1}} {
	global fx:mode_variable
	global fx:search_modeval fx:readonly_modeval
	if {$checks && [string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
		[string compare ${fx:mode_variable} ${fx:readonly_modeval}] != 0} {
	    if {[Fx:TypeCheck $schema $attr $w.e]} {
		return
	    }
	    if {[info exists unique] && $unique} {
		if {[Fx:UniqueCheck $schema $attr $w.e]} {
		    return
		}
	    }
	}
	incr tabstop $increment
	while {[info exists tab_array($tabstop)]} {
	    set class [winfo class $tab_array($tabstop)]
	    if {[winfo exists $tab_array($tabstop).r0]} {
		incr tabstop $increment
		continue
	    }
	    if {[string compare [lindex [$tab_array($tabstop) configure -state] 4] disabled] != 0} {
		if {[string compare $class Entry] == 0} {
		    focus $tab_array($tabstop)
		    return
		} elseif {[string compare $class Text] == 0} {
		    focus $tab_array($tabstop)
		    return
		}
	    }
	    incr tabstop $increment
	}
	# overflow or underflow
	if {$increment == 1} {
	    if {[info exists common_searchfor_entry] && [winfo exists $common_searchfor_entry] && \
		    [string compare [lindex [$common_searchfor_entry configure -state] 4] normal] == 0} {
		focus $common_searchfor_entry
		return
	    } else {
		set tabstop 0
	    }
	} else {
	    if {$tabstop == -1 && [info exists common_searchfor_entry] && \
		    [winfo exists $common_searchfor_entry] && \
		    [string compare [lindex [$common_searchfor_entry configure -state] 4] normal] == 0} {
		focus $common_searchfor_entry
		return
	    } else {
		set tabstop [expr $tabtop - 1]
	    }
	}
	while {[info exists tab_array($tabstop)]} {
	    set class [winfo class $tab_array($tabstop)]
	    if {[string compare $class Entry] == 0 && \
		    [string compare [lindex [$tab_array($tabstop) configure -state] 4] normal] == 0} {
		focus $tab_array($tabstop)
		return
	    } elseif {[string compare $class Text] == 0 && \
			  [string compare [lindex [$tab_array($tabstop) configure -state] 4] normal] == 0} {
		focus $tab_array($tabstop)
		return
	    }
	    incr tabstop $increment
	}
	focus none
    }

    method BuildEntry {} {
	global $array fx_thack fx_config fx:mode_variable
	global fx:search_modeval fx:current_focus
	foreach i {height width default_values type read_only mandatory unique} {
	    if {[info exists fx_config($attr,$i)]} {
		set $i $fx_config($attr,$i)
	    }
	}
	if {[winfo exists $w.e]} {
	    destroy $w.e
	    if {[winfo exists $w.s]} {
		destroy $w.s
	    }
	    if {[info exists textvariable]} {
		uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
		uplevel \#0 [list trace vdelete fx_thack($w.e) w [list $this RefreshTextVar]]
	    }
	}
	switch $type {
	    Entry {
		entry $w.e -relief sunken -bd 2 -width $width -fg $entryfg
		if {[info exists textvariable]} {
		    $w.e configure -textvariable $textvariable 
		}
		pack $w.e -side right -expand on -fill x -anchor nw
		if {[string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
			[info exists read_only] && $read_only == 1} {
		    $w.e configure -state disabled
		}
		if {[info exists mandatory] && $mandatory == 1 && \
			[string compare [tk colormodel .] monochrome] != 0} {
		    $w.e configure -bg $fx_config(mandatory_field_bg)
		}
		set nexttab [list $this GoToNext $mytabstop 1]
		set lasttab [list $this GoToNext $mytabstop 1 -1]
		bind $w.e <FocusIn> [list $this ReFocus]
		bind $w.e <Tab> $nexttab
		bind $w.e <Shift-Tab> $lasttab
		bind $w.e <Down> $nexttab
		bind $w.e <Up> $lasttab
		bind $w.e <Control-n> $nexttab
		bind $w.e <Control-p> $lasttab
	    }
	    Text {
		scrollbar $w.s -relief sunken -command [list $w.e yview]
		pack $w.s -side $scrollbarside -fill y
		text $w.e -relief sunken -bd 2 -height $height -width $width \
		    -fg $entryfg -yscroll [list $w.s set]
		if {[info exists textvariable]} {
		    $w.e insert 0.0 [set $textvariable]
		    uplevel \#0 [list trace variable $textvariable wu [list $this RefreshText]]
		    uplevel \#0 [list trace variable fx_thack($w.e) w [list $this RefreshTextVar]]
		}
		pack $w.e -side right -expand on -fill both
		if {[string compare ${fx:mode_variable} ${fx:search_modeval}] != 0 && \
			[info exists read_only] && $read_only == 1} {
		    $w.e configure -state disabled
		}
		if {[info exists mandatory] && $mandatory == 1 && \
			[string compare [tk colormodel .] monochrome] != 0} {
		    $w.e configure -bg $fx_config(mandatory_field_bg)
		}
		bind $w.e <Tab> [list $this GoToNext $mytabstop 1]
		bind $w.e <Shift-Tab> [list $this GoToNext $mytabstop 1 -1]
	    }
	    Radiobutton {
		if {![info exists default_values]} {
		    entry $w.e -relief sunken -bd 2 -width $width -fg $entryfg
		    if {[info exists textvariable]} {
			$w.e configure -textvariable $textvariable 
		    }
		    break
		}
		frame $w.e -relief sunken -bd 2
		set x 0
		set row 0
		foreach i $default_values {
		    radiobutton $w.e.r$x -value $i -text $i -relief flat -fg $entryfg \
			-variable $textvariable
		    pack $w.e.r$x -side left -expand on -fill x
		    bind $w.e.r$x <Button-3> [list $this UndoRadiobutton %W]
		    if {[info exists mandatory] && $mandatory == 1 && \
			    [string compare [tk colormodel .] monochrome] != 0} {
			$w.e.r$x configure -bg $fx_config(mandatory_field_bg)
		    }
		    incr x
		}
		pack $w.e -side right -expand on -fill x -anchor nw
	    }
	}
	set focus $w.e
	if {[info exists afterreconfigure]} {
	    eval $afterreconfigure
	}
    }
    method ReFocus {} {
	global fx:current_focus

	if {[info exists fx:current_focus] && \
		[string compare [lindex [set fx:current_focus] 1] $w.e] != 0} {
	    if {![Fx:CurrentTypeCheck $schema] && ![Fx:CurrentUniqueCheck $schema]} {
		set fx:current_focus [list $attr $w.e]
	    } else {
		focus [lindex [set fx:current_focus] 1]
	    }
	} else {
	    set fx:current_focus [list $attr $w.e]
	}
    }
    method UndoRadiobutton {w} {
	set var [lindex [$w configure -variable] 4]
	set val [lindex [$w configure -value] 4]
	if {[string compare [uplevel \#0 [list set $var]] $val] == 0} {
	    uplevel \#0 [list set $var {}]
	}
    }
    method RefreshText {{n1 ""} {n2 ""} {op ""}} {
	global $array

	$w.e configure -state normal
	if {[string compare $op u] == 0} {
	    $w.e delete 0.0 end
	} else {
	    set i [$w.e index insert]
	    $w.e delete 0.0 end
	    set var [uplevel \#0 [list set $textvariable]]
	    $w.e insert 0.0 $var
	    $w.e mark set insert $i
	    $w.e yview -pickplace insert
	}
	if {[info exists read_only] && $read_only == 1} {
	    $w.e configure -state disabled
	}
    }
    method RefreshTextVar {{n1 ""} {n2 ""} {op ""}} {
	uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
	set tuple_changed 1
	uplevel \#0 [list set $textvariable [$w.e get 0.0 end]]
	uplevel \#0 [list trace variable $textvariable wu [list $this RefreshText]]
    }
    method Reconfigure {} {
	global fx_config

	if {$userconfig && [Fx:ConfigureEntry $schema $attr] == 1} {
	    BuildEntry
	}
    }
    method GetAttr {} {
	return $attr
    }
    method GetAttrPair {} {
	return [list $attr $textvariable]
    }
    method GetTextVariable {} {
	return $textvariable
    }
    method configure {config} {
	foreach i $config {
	    switch $i {
		Fx_Attribute::array {
		    if {[string compare $type Entry] == 0} {
			if {[info exists $textvariable]} {
			    uplevel \#0 [list trace vdelete $textvariable w {Fx_Entry :: TupleChanged 1}]
			}
			set textvariable ${array}($attr)
			catch "$w.e configure -textvariable $textvariable"
			uplevel \#0 [list trace variable $textvariable w {Fx_Entry :: TupleChanged 1}]
		    } elseif {[string compare $type Radiobutton] == 0} {
			set x 0
			if {[info exists $textvariable]} {
			    uplevel \#0 [list trace vdelete $textvariable w {Fx_Entry :: TupleChanged 1}]
			}
			set textvariable ${array}($attr)
			while {[catch "$w.e.r$x configure -variable $textvariable"] == 0} {
			    incr x
			}
			uplevel \#0 [list trace variable $textvariable w {Fx_Entry :: TupleChanged 1}]
		    } else {
			if {[info exists textvariable]} {
			    uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
			}
			set textvariable ${array}($attr)
			global ${array}
			uplevel \#0 [list trace vdelete $textvariable wu [list $this RefreshText]]
			set $textvariable {}
			uplevel \#0 [list trace variable $textvariable wu [list $this RefreshText]]
		    }
		}
		Fx_Entry::width {
		    switch $type {
			Entry {
			    global fx_config
			    $w.e configure -width $width
			    set fx_config($attr,width) $width
			}
			Text {
			    global fx_config
			    $w.e configure -width $width
			    set fx_config($attr,width) $width
			}
		    }
		}
	    }
	}
    }

    proc EnableReadOnlyWidgets {{all 0}} {
	foreach i $instances {
	    $i EnableReadOnly $all
	}
    }
    proc DisableReadOnlyWidgets {{all 0}} {
	foreach i $instances {
	    $i DisableReadOnly $all
	}
    }
    method DisableReadOnly {all} {
	if {$all || ([info exists read_only] && $read_only == 1)} {
	    if {[string compare $type Radiobutton] == 0} {
		set x 0
		foreach i $default_values {
		    $w.e.r$x configure -state disabled
		    incr x
		}
	    } else {
		$w.e configure -state disabled
	    }
	}
    }
    method EnableReadOnly {all} {
	if {$all || ([info exists read_only] && $read_only == 1)} {
	    if {[string compare $type Radiobutton] == 0} {
		set x 0
		foreach i $default_values {
		    $w.e.r$x configure -state normal
		    incr x
		}
	    } else {
		$w.e configure -state normal
	    }
	}
    }
    method GetEntry {} {
	return $w.e
    }
    proc GetInstances {} {
	return $instances
    }

    proc InitFocus {} {
	$firstentry GoToNext -1 0
    }

    proc AfterReconfigure {l} {
	set afterreconfigure $l
    }
    proc ScrollbarSide {s} {
	if {[string compare $s left] != 0 && [string compare $s right] != 0} {
	    puts "Warning: ScrollbarSide $s must be left or right"
	} else {
	    set scrollbarside $s
	}
    }
    proc EnableExcludedWidgets {} {
	foreach i $excluded_entries {
	    catch [list $i configure -state normal]
	}
    }
    proc DisableExcludedWidgets {} {
	foreach i $excluded_entries {
	    catch [list $i configure -state disabled]
	}
    }

    common afterreconfigure
    common scrollbarside left

    # Entry stuff
    public entryfg black
    public height 1
    public width 15
    protected textvariable
    
    public regexp_search 1 {
	global fx_config
	set fx_config(\$regexp_search\$,$attr) $regexp_search
    }
    public range_search 1 {
	global fx_config
	set fx_config(\$range_search\$,$attr) $range_search
    }
    public numeric_search 1 {
	global fx_config
	set fx_config(\$numeric_search\$,$attr) $numeric_search
    }
    public date_search 1 {
	global fx_config
	set fx_config(\$date_search\$,$attr) $date_search
    }

    # Generic stuff
    public type Entry
    public default_values {}
    public read_only
    public mandatory
    public unique

    public userconfig 1

    # Array of entries for tabbing
    common tab_array
    common tabtop 0
    protected mytabstop
    public searchfor_entry {} {set common_searchfor_entry $searchfor_entry}
    common common_searchfor_entry
    common firstentry
    common instances
    common excluded_entries {}
}

