
proc Fx:nullop {} {}

proc Fx:Dialog {t s} {
    fx_dialog .dialog $t $s error 0 Ok
}

proc Fx:CheckMandatoryFields {schema attr array} {
    global fx_config $array

    if {[llength $attr] == 0} {
	foreach i [qddb_schema leaves $schema] {
	    if {[info exists fx_config($i,mandatory)] && \
		    $fx_config($i,mandatory) == 1 && \
		    [string compare [string trim [set ${array}($i)]] ""] == 0} {
		fx_dialog .dialog "Mandatory field empty!" \
			 "You must fill in all mandatory fields ($i) or clear the record" error 0 Ok
		return 1
	    }
	}
    } else {
	foreach i [qddb_schema leaves $schema $attr] {
	    if {[info exists fx_config($i,mandatory)] && \
		    $fx_config($i,mandatory) == 1 && \
		    [string compare [string trim [set ${array}($i)]] ""] == 0} {
		fx_dialog .dialog "Mandatory field empty!" \
			 "You must fill in all mandatory fields or clear the record" error 0 Ok
		return 1
	    }	
	}
    }
    return 0
}

proc Fx:UniqueError {} {
    fx_dialog .dialog "Uniqueness error" "This field must contain a unique value.  Please re-enter." error 0 OK
}

proc Fx:CurrentUniqueCheck {schema} {
    global fx:current_focus

    return [Fx:UniqueCheck $schema [lindex ${fx:current_focus} 0] [lindex ${fx:current_focus} 1]]
}

proc Fx:UniqueCheck {schema attr entry} {
    global fx:mode_variable fx_config
    global fx:search_modeval fx:add_modeval fx:change_modeval
    if {![info exists fx_config($attr,unique)] || $fx_config($attr,unique) == 0} {
	return 0
    }
    set val [$entry get]
    if {[string compare ${fx:mode_variable} ${fx:search_modeval}] == 0 || [string compare $val ""] == 0} {
	return 0
    }
    switch -exact [winfo class $entry] {
	Entry { }
	default {return 0}
    }
    set stuff [$entry get]
    if {[string compare $stuff ""] == 0} {return 0}
    set k [qddb_search $schema -prunebyattr $attr word [$entry get]]
    set k [qddb_keylist process nullop -deldup_sameentry on $k]
    set x 0
    foreach i [qddb_keylist get $k] {
	set t [qddb_tuple read $schema $i]
	if {[llength $t] > 0} {
	    incr x
	    catch [list qddb_tuple delete $t]
	}
    }
    if {[string compare ${fx:add_modeval} ${fx:mode_variable}] == 0} {
	if {$x > 0} {
	    Fx:UniqueError
	    focus $entry
	    return 1
	}
    } elseif {[string compare ${fx:change_modeval} ${fx:mode_variable}] == 0} {
	if {$x > 1} {
	    Fx:UniqueError
	    focus $entry
	    return 1
	}
    }
    return 0
}

proc Fx:TypeError {type val} {
    fx_dialog .dialog "Type error" "Invalid $type: $val  Please re-enter." error 0 OK
}

proc Fx:CurrentTypeCheck {schema} {
    global fx:current_focus

    return [Fx:TypeCheck $schema [lindex ${fx:current_focus} 0] [lindex ${fx:current_focus} 1]]
}

proc Fx:TypeCheck {schema attr entry} {
    global fx:mode_variable
    global fx:search_modeval
    if {[string compare ${fx:mode_variable} ${fx:search_modeval}] == 0} {
	return 0
    }
    set type [qddb_schema option type $schema $attr]
    switch -exact [winfo class $entry] {
	Entry {set val [$entry get]}
	default {return 0}
    }
    set err 0
    switch -exact $type {
	integer {
	    if {[catch "expr int($val)"] == 0} {
		return 0
	    } else {
		set err 1
	    }
	}
	real {
	    if {[catch "expr double($val)"] == 0} {
		return 0
	    } else {
		set err 1
	    }
	}
    }
    if {$err != 0} {
	Fx:TypeError $type [$entry get]
	focus $entry
	return 1
    } elseif {[string compare $type "date"] == 0} {
	if {![qddb_util isdate [$entry get]]} {
	    Fx:TypeError $type [$entry get]
	    focus $entry
	    return 1
	}
    }
    return 0
}

proc Fx:AboutBox {} {
    global qddb_library qddb_version fx_config

    if {[winfo exists .aboutBox]} {
	wm withdraw .aboutBox
	wm deiconify .aboutBox
	update idletasks
        return
    }
    toplevel .aboutBox
    wm title .aboutBox "About Qddb"
    if {[info exists fx_config(geom,\$AboutBox\$)]} {
	set x [split $fx_config(geom,\$AboutBox\$) +]
	set y [lindex $x 2]
	set x [lindex $x 1]
	wm geometry .aboutBox +$x+$y
    }
    set x .aboutBox.buttons
    frame $x
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command {
	global fx_config
	set fx_config(geom,\$AboutBox\$) [wm geometry .aboutBox]
	destroy .aboutBox
    }
    pack $x.ok -fill x

    if {[string compare "[info commands pinfo]" ""] == 0} {
	label .aboutBox.qddb -bitmap @$qddb_library/fx/pixmaps/qddb2.xbm
    } else {
	if {[winfo depth .] >= 15} {
	    label .aboutBox.qddb -bitmap @$qddb_library/fx/pixmaps/qddb_color2.xpm	    
	} else {
	    label .aboutBox.qddb -bitmap @$qddb_library/fx/pixmaps/qddb2.xpm
	}
    }
    pack .aboutBox.qddb -side top

    message .aboutBox.version -justify center -aspect 400 \
        -text "Quick and Dirty DataBase\nVersion ${qddb_version}\n"
    pack .aboutBox.version -side top

    message .aboutBox.copyright -justify center -aspect 400 \
	-text "Copyright(c) 1993, 1994\nHerrin Software Development, Inc.\nAll rights reserved.\n" 
    pack .aboutBox.copyright -side top

    message .aboutBox.license -justify left -aspect 250 \
	-text "Qddb is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License Version 2 as published by the Free Software Foundation.  Qddb is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.  You should have received a copy of the GNU General Public License along with Qddb; see the file LICENSE.  If not, write to:\n\n    Herrin Software Development, Inc.\n    R&D Division\n    41 South Highland Ave.\n    Prestonsburg, KY  41653"
pack .aboutBox.license -side top

    message .aboutBox.subscription -justify left -aspect 250 \
	-text "Qddb subscriptions may be purchased for a yearly rate of \$75. Subscriptions include a printed manual, a diskette containing the software and numerous examples, and a newsletter for each new release of the software (up to 4/year).  Send your mailing address and check or money order(U.S. funds only please) payable to:\n\n    Herrin Software Development, Inc.\n    Qddb Subscriptions\n    41 South Highland Ave.\n    Prestonsburg, KY  41653\n\nProfits from subscriptions fund further Qddb development.  HSD also builds custom Qddb applications for a one-time consulting fee."
    pack .aboutBox.subscription -side top

}

proc Fx:FAQBox {} {
    global qddb_library fx_config qddb_version

    if {[winfo exists .faqBox]} {
	wm withdraw .faqBox
	wm deiconify .faqBox
	update idletasks
        return
    }
    toplevel .faqBox
    wm title .faqBox "Qddb Frequently Asked Questions"
    set x .faqBox.buttons
    frame $x
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command "
	set [list fx_config(geom,\$faqBox\$)] \[wm geometry .faqBox\]
        destroy .faqBox
    "
    pack $x.ok -fill x

    if {[string compare "[info commands pinfo]" ""] == 0} {
	label .faqBox.qddb -bitmap @$qddb_library/fx/pixmaps/qddb2.xbm
    } else {
	if {[winfo depth .] >= 15} {
	    label .faqBox.qddb -bitmap @$qddb_library/fx/pixmaps/qddb_color2.xpm
	} else {
	    label .faqBox.qddb -bitmap @$qddb_library/fx/pixmaps/qddb2.xpm
	}
    }
    pack .faqBox.qddb -side top

    message .faqBox.faq -justify center -aspect 400 \
	-text "Frequently Asked Questions"
    pack .faqBox.faq -side top

    message .faqBox.version -justify center -aspect 400 \
        -text "Quick and Dirty DataBase\nVersion ${qddb_version}\n"
    pack .faqBox.version -side top

    message .faqBox.copyright -justify center -aspect 400 \
	-text "Copyright(c) 1993, 1994, 1995\nHerrin Software Development, Inc.\nAll rights reserved.\n" 
    pack .faqBox.copyright -side top

    set fd [open $qddb_library/FAQ "r"]
    set FAQ [read $fd]
    close $fd
    set x .faqBox.f
    frame $x
    pack $x -side top -expand on -fill both
    scrollbar $x.s -orient vertical -relief sunken -command [list $x.c yview]
    pack $x.s -side right -fill y
    text $x.c -relief sunken -bd 2 -yscroll [list $x.s set] -wrap word -setgrid on
    pack $x.c -side left -expand on -fill both
    $x.c insert 0.0 $FAQ
    $x.c configure -state disabled
    if {[info exists fx_config(geom,\$faqBox\$)]} {
	wm geometry .faqBox $fx_config(geom,\$faqBox\$)
    } else {
	wm geometry .faqBox +70+0
    }
}

proc Fx:KeyBindingsHelp {} {
    global qddb_library fx_config qddb_version

    if {[winfo exists .keybindBox]} {
	wm withdraw .keybindBox
	wm deiconify .keybindBox
	update idletasks
        return
    }
    toplevel .keybindBox
    wm title .keybindBox "Fx Key Bindings"
    set x .keybindBox.buttons
    frame $x
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command "
	set [list fx_config(geom,\$keybindBox\$)] \[wm geometry .keybindBox\]
        destroy .keybindBox
    "
    pack $x.ok -fill x

    message .keybindBox.title -justify center -aspect 600 -text \
	"Qddb Fx Toolkit Key Bindings"
    pack .keybindBox.title -side top

    set f .keybindBox.f
    frame $f
    pack $f -side top -expand on -fill both
    set f1 {
	{ "<Tab>" "Move cursor to next field" }
	{ "<Shift-Tab>" "Move cursor to last field" }
	{ "<Control-a>" "Go to beginning of line" }
	{ "<Control-e>" "Go to end of line" }
	{ "<Control-b>" "Move back one char" }
	{ "<Control-d>" "Delete next char" }
	{ "<Control-e>" "Move forward one char" }
    }
    label $f.l0 -text "Generic Key Bindings" -relief raised
    pack $f.l0 -side top -expand on -fill x
    if {[string compare [tk colormodel .] monochrome] != 0} {
	$f.l0 configure -fg hotpink
    }
    frame $f.f1 -bd 1 -relief sunken
    pack $f.f1 -side left -expand on -fill both
    set x 0
    foreach i $f1 {
	frame $f.f1.f$x -bd 1
	pack $f.f1.f$x -side top -expand on -fill x
	label $f.f1.f$x.l1 -text [lindex $i 0] -anchor e -width 12 -bd 1 -relief sunken
	label $f.f1.f$x.l2 -text [lindex $i 1] -anchor w -bd 1 -relief sunken
	pack $f.f1.f$x.l1 -side left
	pack $f.f1.f$x.l2 -side left -expand on -fill x
	incr x
    }
    set f2 {
	{ "<Control-h>" "Back one char, delete char" }
	{ "<Control-k>" "Kill to end of line" }
	{ "<Control-u>" "Kill to beginning of line" }
	{ "<Control-w>" "Cut selected text into buffer" }
        { "<Alt-w>"     "Copy selected text into buffer" }
	{ "<Control-y>" "Paste buffer contents at cursor position" }
	{ "<Button-3>" "Paste selection at mouse position" }
    }
    frame $f.f2 -bd 1 -relief sunken
    pack $f.f2 -side right -expand on -fill both
    set x 0
    foreach i $f2 {
	frame $f.f2.f$x -bd 1
	pack $f.f2.f$x -side top -expand on -fill x
	label $f.f2.f$x.l1 -text [lindex $i 0] -anchor e -width 12 -bd 1 -relief sunken
	label $f.f2.f$x.l2 -text [lindex $i 1] -anchor w -bd 1 -relief sunken
	pack $f.f2.f$x.l1 -side left
	pack $f.f2.f$x.l2 -side left -expand on -fill x
	incr x
    }
    set entryonly {
	{ "<Down>" "Move cursor to next field" }
	{ "<Up>" "Move cursor to last field" }
	{ "<Control-n>" "Move cursor to next field" }
	{ "<Control-p>" "Move cursor to last field" }
	{ "<Return>" "In Search Mode, search" }
	{ "" "" }
    }
    set x [llength $f1]
    label $f.f1.l0 -text "Entry-specific Bindings" -relief raised
    if {[string compare [tk colormodel .] monochrome] != 0} {
	$f.f1.l0 configure -fg hotpink
    }
    pack $f.f1.l0 -side top -expand on -fill x
    foreach i $entryonly {
	frame $f.f1.f$x -bd 1
	pack $f.f1.f$x -side top -expand on -fill x
	label $f.f1.f$x.l1 -text [lindex $i 0] -anchor e -width 12 -bd 1 -relief sunken
	label $f.f1.f$x.l2 -text [lindex $i 1] -anchor w -bd 1 -relief sunken
	pack $f.f1.f$x.l1 -side left
	pack $f.f1.f$x.l2 -side left -expand on -fill x
	incr x
    }
    set textonly {
	{ "<Down>" "Move cursor to next line" }
	{ "<Up>" "Move cursor to last line" }
	{ "<Control-n>" "Move cursor to next line" }
	{ "<Control-o>" "Open current line" }
	{ "<Control-p>" "Move cursor to last line" }
	{ "<Return>" "Move cursor to next line" }
    }
    set x [llength $f2]
    label $f.f2.l0 -text "Text-specific Bindings" -relief raised
    if {[string compare [tk colormodel .] monochrome] != 0} {
	$f.f2.l0 configure -fg hotpink
    }
    pack $f.f2.l0 -side top -expand on -fill x
    foreach i $textonly {
	frame $f.f2.f$x -bd 1
	pack $f.f2.f$x -side top -expand on -fill x
	label $f.f2.f$x.l1 -text [lindex $i 0] -anchor e -width 12 -bd 1 -relief sunken
	label $f.f2.f$x.l2 -text [lindex $i 1] -anchor w -bd 1 -relief sunken
	pack $f.f2.f$x.l1 -side left
	pack $f.f2.f$x.l2 -side left -expand on -fill x
	incr x
    }
    if {[info exists fx_config(geom,\$keybindBox\$)]} {
	wm geometry .keybindBox $fx_config(geom,\$keybindBox\$)
    } else {
	wm geometry .keybindBox +70+0
    }
}

proc fx_dialog {w title text bitmap default args} {
    global fx_priv fx_perform_global_grabs

    # 1. Create the top-level window and divide it into top
    # and bottom parts.
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $title
    wm iconname $w Dialog
    frame $w.top -relief raised -bd 1
    pack $w.top -side top -fill both
    frame $w.bot -relief raised -bd 1
    pack $w.bot -side bottom -fill both
    # 2. Fill the top part with bitmap and message.
    message $w.msg -width 3i -text $text \
        -font -Adobe-Times-Medium-R-Normal-*-180-*
    pack $w.msg -in $w.top -side right -expand 1 -fill both -padx 5m -pady 5m
    if {$bitmap != ""} {
	label $w.bitmap -bitmap $bitmap
	pack $w.bitmap -in $w.top -side left -padx 5m -pady 5m
    }
    # 3. Create a row of buttons at the bottom of the dialog.
    set i 0
    foreach but $args {
	button $w.button$i -text $but -command "set fx_priv(button) $i"
	if {$i == $default} {
	    frame $w.default -relief sunken -bd 1
	    raise $w.button$i $w.default
	    pack $w.default -in $w.bot -side left -expand 1 -padx 3m -pady 2m
	    pack $w.button$i -in $w.default -padx 2m -pady 2m \
		    -ipadx 2m -ipady 1m
	    bind $w <Return> "$w.button$i flash; set fx_priv(button) $i"
	} else {
	    pack $w.button$i -in $w.bot -side left -expand 1 \
		    -padx 3m -pady 3m -ipadx 2m -ipady 1m
	}
	incr i
    }
    # 4. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.
    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
        - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
        - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w
    # 5. Set a grab and claim the focus too.
    set oldFocus [focus]
    if {$fx_perform_global_grabs} {
	grab -global $w
    } else {
	grab $w
    }
    focus $w
    # 6. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.
    tkwait variable fx_priv(button)
    destroy $w
    focus $oldFocus
    return $fx_priv(button)
}
