
proc Fx:InitResources {} {
    global fx_font fx_classes fx_font_config

    if {![info exists fx_font]} {
	foreach i $fx_classes {
	    set fx_font($i) -*-$fx_font_config(default_family)-$fx_font_config(default_weight)-[string index $fx_font_config(default_slant) 0]-*-*-*-[lindex $fx_font_config(sizes) [lsearch -exact $fx_font_config(sizenames) $fx_font_config(default_size)]]-*-*-*-*-*-*
	    option add *$i.font $fx_font($i)
	}
	set fx_font(Listbox) -*-courier-bold-r-*-*-*-140-*-*-*-*-*-*
	option add *Listbox.font -*-courier-bold-r-*-*-*-140-*-*-*-*-*-*
    } else {
	foreach i [array names fx_font] {
	    option add *${i}.font $fx_font($i)
	}
    }
}

set fx_resources {
    Button.activeForeground
    Button.activeBackground
    Button.background
    Button.foreground
    Button.disabledForeground
    Button.font
    Canvas.background
    Canvas.foreground
    Canvas.selectBackground
    Canvas.selectForeground
    Checkbutton.activeBackground
    Checkbutton.activeForeground
    Checkbutton.background
    Checkbutton.foreground
    Checkbutton.disabledForeground
    Checkbutton.font
    Entry.background
    Entry.foreground
    Entry.font
    Entry.selectBackground
    Entry.selectForeground
    Frame.background
    Label.background
    Label.foreground
    Label.font
    Listbox.background
    Listbox.foreground
    Listbox.font
    Listbox.selectBackground
    Listbox.selectForeground
    Menu.activeBackground
    Menu.activeForeground
    Menu.background
    Menu.foreground
    Menu.font
    Menu.disabledForeground
    Menubutton.activeBackground
    Menubutton.activeForeground
    Menubutton.background
    Menubutton.foreground
    Menubutton.disabledForeground
    Menubutton.font
    Message.background
    Message.foreground
    Message.font
    Radiobutton.activeBackground
    Radiobutton.activeForeground
    Radiobutton.background
    Radiobutton.foreground
    Radiobutton.disabledForeground
    Radiobutton.font
    Scale.activeForeground
    Scale.background
    Scale.foreground
    Scale.font
    Scrollbar.activeForeground
    Scrollbar.background
    Scrollbar.foreground
    Scrollbar.Width
    Text.background
    Text.foreground
    Text.font
    Text.selectBackground
    Text.selectForeground
}

set fx_classes {
    Button
    Canvas
    Checkbutton
    Entry
    Frame
    Label
    Listbox
    Menu
    Menubutton
    Message
    Radiobutton
    Scale
    Scrollbar
    Text
}
