
/* TclTable.c - TCL interface routines for manipulating lists, tables, etc.
 *
 * Copyright (C) 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */


#include "tcl.h"
#include "Qddb.h"
#include "tclQddb.h"

/* TclQddb_TableProc --
 *
 * qddb_table define <opts>
 *	-rows <initial number of rows>
 *	-types <complete column list of (string,real,integer,date)>
 *	-variable <Tcl variable name>
 *      -extensionvariable <Tcl variable name>
 * qddb_table listofrows <table_desc>
 * qddb_table append ?-rows number? <table_desc>
 * qddb_table sort <opts> <table_desc>
 *	-ascending <column list>
 *	-sortby <column list>
 * qddb_table set ?-row <starting rownum>? <table_desc> <list of rows>
 * qddb_table get <table_desc>
 * qddb_table op ?-column|-row number? sum|avg|count|prod|max|min|stddev
 * qddb_table delete <table_desc>|all
 */

int TclQddb_TableProc(clientData, interp, argc, argv)
    ClientData			clientData;
    Tcl_Interp			*interp;
    int				argc;
    char			*argv[];
{
    if (argc < 3 || argc > 10) {
	Tcl_AppendResult(interp, argv[0], ": wrong # args", NULL);
	return TCL_ERROR;
    }
    switch (argv[1][0]) {
    case 'd':
	if (strcmp(argv[1], "define") != 0) {
	    Tcl_AppendResult(interp, argv[0], ": invalid command ", argv[1], NULL);
	    return TCL_ERROR;
	}
	if (argc != 3) {
	    Tcl_AppendResult(interp, argv[0], ": wrong # args for \"", argv[0], "\"", NULL);
	    return TCL_ERROR;
	}
	break;
    default:
	Tcl_AppendResult(interp, argv[0], ": invalid command ", argv[1], NULL);
	return TCL_ERROR;
    }
    return TCL_OK;
}

void TclQddb_DeleteTableProc(clientData)
    ClientData		clientData;
{

}
