'\"
'\" qddb/ManPages/man1/qddb_view.n
'\" 
'\" Copyright (C) 1993, 1994 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH qddb_view 1 "9 Sept 1994" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 9 Sept 1994
.SH NAME
qddb_view \- Create/manipulate Qddb views.
.SH SYNOPSIS
.ft B
.nf
qddb_view define <tuple desc>|<row desc> <attribute name/TCL var pairs>
qddb_view set <view desc> <row desc>
qddb_view get <view desc>
qddb_view delete <view desc>|all

.SH DESCRIPTION
A \fIview\fR is a set of attributes within a single row
of a Qddb tuple.   A \fIrow\fR is defined as any combination
of attributes where any two attributes in the row are within
the same instance of their nearest common ancestor in the schema.
For example, the schema:
.nf
        Client (
                Name ( First Middle Last )*
                Address ( Street City State Zip )*
        )*
.fi
may have a complete row consisting of:
.nf
        Client.Name.First
        Client.Name.Middle
        Client.Name.Last
        Client.Address.Street
        Client.Address.City
        Client.Address.State
        Client.Address.Zip
.fi
Any two of these attributes in one row must be in the same instance
of \fIClient\fR and the attributes Client.Address.City
and Client.Address.State must both be in the same
instance of Client.Address if they are both in the same row.
So, for the following tuple in readable format conforming to
the schema presented above:
.nf
        Client (
                Name (
                        First = "Eric"
                        Middle = "H."
                        Last = "Herrin"
                )
                Name (
                        First = "Sharon"
                        Last = "Rosh"
                )
                Address (
                        Street = "123 Howard Drive"
                        City = "Lexington"
                        State = "Kentucky"
                        Zip = "40506"
                )
                Address (
                        Street = "321 Jimbob Lane"
                        City = "Rallies"
                        State = "Virginia"
                        Zip = "12345"
                )
        )
.fi
the possible rows are:
.nf
Eric:H.:Herrin:123 Howard Drive:Lexington:Kentucky:40506
Eric:H.:Herrin:321 Jimbob Lane:Rallies:Virginia:12345
Sharon::Rosh:123 Howard Drive:Lexington:Kentucky:40506
Sharon::Rosh:321 Jimbob Lane:Rallies:Virginia:12345
.fi

.TP
\fIqddb_view define\fR
defines a view on the Qddb tuple described by <tuple_desc>.  The
<attribute,var> list is in the format:
.nf
        { {Client.Name.First array(Client.Name.First)}
          {Client.Name.Last  array(Client.Name.Last)}
          {Client.Address.Street street_var}
        }
.fi
and will associate the TCL variable \fBarray(Client.Name.First)\fR
with the attribute \fBClient.Name.First\fR in the row described
by the view.   When a view is defined, the first instance of each
attribute is used in the row.   The view may be changed by
using \fBqddb_view set\fR or \fBqddb_instance switch\fR.
Multiple views on a single tuple may be defined.  The specified
variables are \fBglobal\fR.

.TP
\fIqddb_view set\fR
switches the row used in <view_desc> to the row described
by <row_desc>.

.TP
\fIqddb_view get\fR
returns a new <row_desc> for the current row used in <view_desc>.

.TP
\fIqddb_view delete\fR
deletes the view described by the <view_desc>.   The
special <view_desc> \fBall\fR instructs Qddb to remove
all views from memory.

.SH SEE ALSO
qddb_instance(n), qddb_keylist(n),  qddb_rows(n), qddb_schema(n), 
qddb_search(n), qddb_tuple(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
.SH COPYRIGHT
.nf
Copyright (C) 1993, 1994 Herrin Software Development, Inc.
All rights reserved.
.fi
.PP
This manual page is part of Qddb.
.PP
Qddb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License Version 2
as published by the Free Software Foundation.
.PP
Qddb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with Qddb; see the file LICENSE.  If not, write to:
.sp
.nf
        Herrin Software Development, Inc. 
        R&D Division
        41 South Highland Ave. 
        Prestonsburg, KY 41653 
.fi   