'\"
'\" qddb/ManPages/mann/fx.n
'\" 
'\" Copyright (C) 1993, 1994 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH Fx 1 "10 Jan 1994" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 10 Jan 1994
.SH NAME
Fx \- The Fx toolkit for building custom Qddb interfaces.
.SH SYNOPSIS
.ft B
.nf
Fx:Init
Fx_Menubar
Fx_Frame
Fx_Entry

.SH DESCRIPTION
The 
.B Fx
toolkit allows programmers to easily build custom Qddb 
applications.   You are provided with a set of default menubar
options (via Fx_Menubar), and you can organize your attributes
any way you like with a combination of Fx_Frame and Fx_Entry.
You can add menu buttons, menu items, specify default values,
change the entry type between Text, Entry and Radiobutton,
and specify mandatory and read-only fields.

For example, suppose you have the following Schema.

.nf
    # Sample MyRelation/Schema file
    a ( b c d )*
.fi

An Fx toolkit program for this Schema might look like:

.nf
    #!/usr/local/qddb/bin/qwish -f
    lappend auto_path $qddb_library/fx $blt_library
    set s [qddb_schema open MyRelation]
    # You *must* call Fx:Init $s to initialize Fx
    Fx:Init $s
    Fx_Menubar menubar -w .mb -schema $s -array gv_attr
    set search_entry [menubar SearchForEntry]
    # define all the instances and how they are viewed.
    # -setschema should be set on the first
    # call to Fx_Entry and Fx_Frame
    Fx_Frame a -w .a -setschema $s -attr a -side top \\
            -anchor nw -relief raised
    Fx_Entry a.b -w .a.b -searchfor_entry $search_entry -attr a.b \\
            -relief sunken -bd 3 -side left -setschema $s
    # configure the Fx_Frame's focus (for adding new entries)
    a configure -focus [a.b GetEntry]

    Fx_Entry a.c -w .a.c -attr a.c -relief sunken -bd 3 -side left
    pack .a.b -side left -expand on -fill x
    pack .a.c -side left -expand on -fill x
    # Note that a.d doesn't have to be in the same physical frame as 
    # its siblings in the Schema.
    Fx_Entry d -w .d -attr a.d -relief sunken -bd 3 -side left
    pack .d -side bottom -expand on -fill x
    # Link up the frames and entries with the menubar
    menubar configure -instances [Fx_Entry :: GetInstances] \\
            -frames [Fx_Frame :: GetInstances]
    # Go to Search Mode to start
    menubar SearchModeProc
.fi

.SH NOTES
You must specify --with-itcl when configuring Qddb to install
the Fx toolkit.   Fx depends on [Incr Tcl].

.SH SEE ALSO
Fx_Menubar(n), Fx_Frame(n), Fx_Entry(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
.SH COPYRIGHT
.nf
Copyright (C) 1993, 1994 Herrin Software Development, Inc.
All rights reserved.
.fi
.PP
This manual page is part of Qddb.
.PP
Qddb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License Version 2
as published by the Free Software Foundation.
.PP
Qddb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with Qddb; see the file LICENSE.  If not, write to:
.sp
.nf
        Herrin Software Development, Inc. 
        R&D Division
        41 South Highland Ave. 
        Prestonsburg, KY 41653 
.fi