# Things you might want to put in TEST:
# -DDEBUG		debugging hooks
# -I.			regexp.h from current directory, not /usr/include
TEST=

# Things you might want to put in PROF:
# -Dstatic='/* */'	make everything global so profiler can see it.
# -p			profiler
PROF=

CFLAGS=-O -DQDDB_TEST -I../../Headers -I/usr/contrib/include $(TEST) $(PROF)
LINTFLAGS=$(TEST) -ha
LDFLAGS=

OBJ=regexp.o regsub.o
LSRC=regexp.c regsub.c regerror.c

try:	try.o $(OBJ)
	cc $(LDFLAGS) try.o $(OBJ) -o try

# Making timer will probably require putting stuff in $(PROF) and then
# recompiling everything; the following is just the final stage.
timer:	timer.o $(OBJ)
	cc $(LDFLAGS) $(PROF) timer.o $(OBJ) -o timer

timer.o:	timer.c timer.t.h

timer.t.h:	tests
	sed 's/	/","/g;s/\\/&&/g;s/.*/{"&"},/' tests >timer.t.h

# Regression test.
r:	try tests
	@echo 'No news is good news...'
	try <tests

lint:	timer.t.h
	@echo 'Complaints about multiply-declared regerror() are legit.'
	lint $(LINTFLAGS) $(LSRC) try.c
	lint $(LINTFLAGS) $(LSRC) timer.c

regexp.o:	regexp.c ../../Headers/Regexp.h regmagic.h
regsub.o:	regsub.c ../../Headers/Regexp.h regmagic.h

clean:
	rm -f *.o core mon.out timer.t.h dMakefile dtr try timer

dtr:	r makedtr $(DTR)
	makedtr $(DTR) >dtr

dMakefile:	Makefile
	sed '/^L*ENV=/s/ *-DERRAVAIL//' Makefile >dMakefile
