
/* qddb/Lib/LibQddb/Hash.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

/* EXPORTED:
 *	void Qddb_InitHash(Schema *)
 *	void Qddb_MakeHash(Schema *, char *)
 *	unsigned int Qddb_GetHashTableEntry(Schema *, size_t)
 */

static int Qddb_ReadHashEntry _ANSI_ARGS_((Schema *, size_t, size_t));

void Qddb_InitHash(schema)
    Schema		*schema;
{
    if (schema->UseCachedHashing == False) {
	schema->HashTable = (Hash *)Calloc(sizeof(Hash)*schema->HashSize);
    } else {
	schema->HashTable = (Hash *)Calloc(sizeof(Hash)*schema->CacheSize);
    }
}

void Qddb_MakeHash(schema, RelationFN)
    Schema		*schema;
    char		*RelationFN;
{
    char		HashFN[MAXFILENAMELEN], *Buffer;
    char		*Line, *EndOfLine;
    int			HashFile = schema->hashtable_fd;
    size_t		num, place;
    off_t		SizeOfHashFile;

    if (schema->UseCachedHashing == True)
	return;
    strcpy(HashFN, RelationFN);
    strcat(HashFN, "/HashTable");
    SizeOfHashFile = SizeOfFile(HashFile);
    if (SizeOfHashFile == 0)
	return;
    Buffer = Malloc(sizeof(char)*(size_t)SizeOfHashFile);
    Read(HashFile, Buffer, (size_t)SizeOfHashFile);
    Line = EndOfLine = Buffer; 
    while (EndOfLine < Buffer+SizeOfHashFile) {
	SkipSpaces(&EndOfLine);
	Line = EndOfLine;
	while (!isspace(*EndOfLine))
	    EndOfLine++;
	*EndOfLine = '\0';
	EndOfLine++;
	SkipSpaces(&EndOfLine);
	num = atoi(Line);
	Line = EndOfLine;
	while (!isspace(*EndOfLine))
	    EndOfLine++;
	*EndOfLine = '\0';
	EndOfLine++;
	SkipSpaces(&EndOfLine);
	place = atoi(Line);
	Line = EndOfLine;
	schema->HashTable[place].num = num;
	while (!isspace(*EndOfLine))
	    EndOfLine++;
	*EndOfLine = '\0';
	EndOfLine++;
	SkipSpaces(&EndOfLine);
	schema->HashTable[place].pos = atoi(Line);
	Line = EndOfLine;
	while (!isspace(*EndOfLine))
	    EndOfLine++;
	*EndOfLine = '\0';
	EndOfLine++;
	SkipSpaces(&EndOfLine);
	schema->HashTable[place].len = atoi(Line);
	Line = EndOfLine;
    }
    Free(Buffer);
}


int Qddb_GetHashTableEntry(schema, HashVal)
    Schema			*schema;
    size_t			HashVal;
{
    size_t			i;
    static int			NextCacheEntryToPurge = -1;

    if (schema->UseCachedHashing == False)
	return HashVal;
    for (i = 0; i < schema->TopOfCache; i++) {
	if (schema->HashTable[i].index == HashVal)
	    break;
    }
    if (i == schema->TopOfCache) { /* Entry not in cache */
	if (schema->TopOfCache == schema->CacheSize) {
	    if (NextCacheEntryToPurge >= schema->CacheSize) {
		if (Qddb_ReadHashEntry(schema, 0, HashVal) == -1)
		    return -1;
		i = 0;
		NextCacheEntryToPurge = 1;
	    } else {
		if (Qddb_ReadHashEntry(schema, (size_t)NextCacheEntryToPurge, HashVal) == -1)
		    return -1;
		i  = NextCacheEntryToPurge;
		NextCacheEntryToPurge++;
	    }
	} else {
	    if (Qddb_ReadHashEntry(schema, i, HashVal) == -1) {
		return -1;
	    }
	    schema->TopOfCache++;
	}
    }
    return i;
}

static int Qddb_ReadHashEntry(schema, CacheVal, HashVal)
    Schema		*schema;
    size_t		CacheVal, HashVal;
{
    char		HashLine[HASHLINESIZE+1], *ch, *ch1;
    Hash		*HashEntry = &schema->HashTable[CacheVal];
    int			HashFile = schema->hashtable_fd;

    if (SizeOfFile(HashFile) == 0) {
	return -1;
    }
    lseek(HashFile, (off_t)HASHLINESIZE*HashVal, 0);
    Read(HashFile, HashLine, HASHLINESIZE);
    HashLine[HASHLINESIZE] = '\0';
    HashEntry->num = (size_t)strtoul(HashLine, &ch, 10);
    HashEntry->index = (size_t)strtoul(ch, &ch1, 10);
    HashEntry->pos = (off_t)strtoul(ch1, &ch, 10);
    HashEntry->len = (size_t)strtoul(ch, &ch1, 10);
    return 0;
}

