
/* Lib/LibQddb/Date.c
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 *
 * ---------------------
 *
 * Copyright 1991-1994 Karl Lehenbauer and Mark Diekhans.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Karl Lehenbauer and
 * Mark Diekhans make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

#include "Qddb.h"

/*
 *-----------------------------------------------------------------------------
 *
 * Qddb_GetTimeZone --
 *   Determines the current timezone.  The method varies wildly between
 * different Unix implementations, so its hidden in this function.
 *
 * Parameters:
 *   o currentTime (I) - The clock value that is to be used for the current
 *     time.  This is really a time_t, but is long so it can be in tclExtend.h
 *     without requiring time_t.
 *
 * Returns:
 *    Minutes east of GMT.
 *-----------------------------------------------------------------------------
 */
int
Qddb_GetTimeZone (currentTime)
    long  currentTime;
{
#if defined(HAVE_TM_TZADJ) && HAVE_TM_TZADJ == 1
    time_t      curTime = (time_t) currentTime;
    struct tm  *timeDataPtr = localtime (&curTime);
    int         timeZone;

    timeZone = timeDataPtr->tm_tzadj  / 60;
    if (timeDataPtr->tm_isdst)
        timeZone += 60;

    return timeZone;
#elif defined(HAVE_TM_GMTOFF) && HAVE_TM_GMTOFF == 1
    struct tm *timeDataPtr = localtime (&currentTime);
    int        timeZone;

    timeZone = -(timeDataPtr->tm_gmtoff / 60);
    if (timeDataPtr->tm_isdst)
        timeZone += 60;

    return timeZone;
#elif defined(HAVE_TIMEZONE_VAR) && HAVE_TIMEZONE_VAR == 1
    static int setTZ = False;
    int        timeZone;

    if (!setTZ) {
        tzset ();
        setTZ = True;
    }
    timeZone = timezone / 60;

    return timeZone;
#elif defined(HAVE_GETTIMEOFDAY) && HAVE_GETTIMEOFDAY == 1
    struct timeval  tv;
    struct timezone tz;
    int             timeZone;

    gettimeofday (&tv, &tz);
    timeZone = tz.tz_minuteswest;

    return timeZone;
#else
    error: autoconf did not figure out how to determine the timezone.
#endif
}

