
/* qddb/Headers/Utils.h
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#if !defined(_QDDB_UTILS_H_)
#define _QDDB_UTILS_H_

#define MAXATTRTAB	1000

void			PANIC _ANSI_ARGS_((char *));
int			Open _ANSI_ARGS_((char *, int, int));
int			OpenDatabase _ANSI_ARGS_((char *, int));
int			OpenChangeFile _ANSI_ARGS_((char *, size_t, int));
int			OpenAdditionFile _ANSI_ARGS_((char *, size_t, int));
int			OpenHashTable _ANSI_ARGS_((char *, int));
void 			Read _ANSI_ARGS_((int, char *, size_t));
void 			Write _ANSI_ARGS_((int, char *, size_t));
size_t	 		SizeOfFile _ANSI_ARGS_((int));
void 			Qddb_ReadEntry _ANSI_ARGS_((int, Entry *, off_t, size_t, Boolean));
int 			Qddb_ReadEntryByKeyList _ANSI_ARGS_((int, char *, Entry *, KeyList *, Boolean));
int 			Qddb_ReadEntryByKeyList2 _ANSI_ARGS_((int, char *, Entry *, KeyList *, Boolean));
void			WriteEntry _ANSI_ARGS_((Schema *, int, Entry));
int			EntryChanged _ANSI_ARGS_((char *, size_t *));
Boolean			EntryInvalid _ANSI_ARGS_((Entry));
void			Qddb_InvalidateEntry _ANSI_ARGS_((Schema *, off_t, size_t));
void			Qddb_InvalidateEntryByNumber _ANSI_ARGS_((Schema *, size_t));
size_t			GetEntryNumber _ANSI_ARGS_((Entry));
int			LockSection _ANSI_ARGS_((int, int, off_t, off_t, Boolean));
int			UnlockSection _ANSI_ARGS_((int, off_t, off_t));
void			Close _ANSI_ARGS_((int));
char			*Qddb_FindRelation _ANSI_ARGS_((char *));
int			StrcmpNoupper _ANSI_ARGS_((char *, char *));
Boolean			IsNumericString _ANSI_ARGS_((char *));
void			SkipSpaces _ANSI_ARGS_((char **));
void			StripBackslashes _ANSI_ARGS_((char *));
char			*ReducedAttrToFullAttr _ANSI_ARGS_((Schema *, char *));
char			*FullAttrToReducedAttr _ANSI_ARGS_((Schema *, char *));
char			*ConvertFullAttrToReducedAttr _ANSI_ARGS_((Schema *, char *));
char			*ConvertReducedAttrToFullAttr _ANSI_ARGS_((Schema *, char *));
void			AddToReducedAttributeTable _ANSI_ARGS_((Schema *, char *));
void			ReadReducedAttributeTable _ANSI_ARGS_((Schema *));
char			*InstanceToString _ANSI_ARGS_((size_t *, size_t));
int			StringToInstance _ANSI_ARGS_((char *, size_t *));
char			*Qddb_DateStringToTime _ANSI_ARGS_((char *));
char			*Qddb_DateTimeToString _ANSI_ARGS_((char *, char *));
void 			DeleteEntryByNumber _ANSI_ARGS_((Schema *, size_t));
void 			DeleteEntryByKeyList _ANSI_ARGS_((Schema *, KeyList *));
KeyList 		*CatRelation _ANSI_ARGS_((char *));
char			*Qddb_FieldString _ANSI_ARGS_((char *, size_t));

void			Qddb_SplitBufferIntoLines _ANSI_ARGS_((Entry *, char *, size_t));
char			*Qddb_GetFile _ANSI_ARGS_((int));
void			Qddb_SetBuffer _ANSI_ARGS_((char *));
size_t			Qddb_ReadBuffer _ANSI_ARGS_((char *, size_t));
void			Qddb_InitBuffer _ANSI_ARGS_((void));
char			*Qddb_GetBuffer _ANSI_ARGS_((void));
void			Qddb_ConcatBuffer _ANSI_ARGS_((char *));
char			*Qddb_PrintErrno _ANSI_ARGS_((int));
int 			Qddb_TranslateExternalID _ANSI_ARGS_((Schema *, char *, size_t *, char **));

int			Qddb_CheckDate _ANSI_ARGS_((char *));

int			Qddb_GetDate _ANSI_ARGS_((char *, time_t, long, time_t *));
int			Qddb_GetTimeZone _ANSI_ARGS_((long));
char			*Qddb_FindKey _ANSI_ARGS_((char *, size_t *));
char			*Qddb_StripKey _ANSI_ARGS_((char *, size_t));

int			yyerror _ANSI_ARGS_((char *));
#endif

