/* qddb/Headers/Sql.h
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#if !defined(_QDDB_SQL_H_)
#define _QDDB_SQL_H_

#define MAXOPENRELATIONS	32
#define MAXALIASES		16
#define MAXALIASLEN		16

typedef void SqlReturn;

typedef struct {
    char		PathName[MAXPATHLEN];
    char		Name[MAXFILENAMELEN];
    Hash		*HashTable;
    unsigned int	HashSize;
    Schema		*Schema;
    char		**Aliases;
    Boolean		Valid;
} SqlRelation;

typedef struct {
    KeyList		KeyList;
    SqlRelation		Relation;
} SqlKeyList;


/* structures internal to the SQL parser (and interpreter in general).
 */

/* Constants */
union constant {
    char		*String;
    int			Integer;
    double		Real;
};

typedef enum {
    STRINGCONS, INTEGERCONS, REALCONS
} ConstantType;


typedef struct {
    union constant	Val;
    ConstantType	Type;
} Constant;

/* Identifiers */
typedef struct {
    char		*TableName;
    char		*ColumnName;
    unsigned int	Column;
} Identifier;

/* CommaList: a list of integers for various uses in the interpreter */
typedef struct clistnode {
    unsigned int	Index;
    unsigned int	Next;
} ClistNode;

typedef unsigned int	Clist;

/* OpStack: a list of operations and values to perform.
 */
typedef enum {
    LESSTHAN, LESSEQUAL, 
    GREATERTHAN, GREATEREQUAL, 
    EQUAL, NOTEQUAL,
    SUBTRACT, ADD,
    MULTIPLY, DIVIDE,
    INTERSECTIONOP, UNIONOP,
    NONE
} Operation;

typedef enum {
    OPCONSTANT,
    OPIDENT,
    OPSTACK,
    OPKEYLIST
} PrimaryType;

typedef struct {
    PrimaryType		Type;
    unsigned int	Index;
} Primary;

typedef struct {
    Operation		Op;
    Primary		Val;
} OpStack;

typedef struct {
    unsigned int	Top, Bottom;
} OpStackList;

/* For select statements */
typedef struct {
    unsigned int	Select, From, Where;
} TabExp;

/* NIL is a value that cannot be an index into one of the QSQL internal
 * arrays (2^31-1)
 */
#define NIL		(2147483647)

#define CONSTANTSIZE	100
#define STRINGSIZE	50000
#define IDENTIFIERSIZE	1000
#define CLISTSSIZE	10000
#define OPSSIZE		100
#define OPSTACKLISTSIZE	100
#define TABEXPSIZE	20

#endif

