
/* qddb/Headers/KeyList.h
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#if !defined(_QDDB_KEYLIST_H_)
#define _QDDB_KEYLIST_H_

typedef unsigned int KeyListType;
/* KeyListType values */
#define ORIGINAL  (unsigned)0x0001
#define CHANGE    (unsigned)0x0002
#define ADDITION  (unsigned)0x0004
#define NEWENTRY  (unsigned)0x0008
#define ANYRESULT (unsigned)0x0010

#define QDDB_KEYLIST_FLAG_COPY			0x0001
#define QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY	0x0002
#define QDDB_KEYLIST_FLAG_DELDUP_SAMEATTR	0x0004
#define QDDB_KEYLIST_FLAG_EXACT			0x0008
/* for PROC_MARK */
#define QDDB_KEYLIST_FLAG_MARKASANY		0x0010
#define QDDB_KEYLIST_FLAG_MARKFROMINCORE	0x0020
#define QDDB_KEYLIST_FLAG_MARKFROMDATATREE	0x0040
/* for PROC_PRUNE */
#define QDDB_KEYLIST_FLAG_PRUNEBYROW		0x0080
#define QDDB_KEYLIST_FLAG_PRUNEBYATTR		0x0100

/* Qddb_KeyListOp operations */
#define QDDB_KEYLIST_OP_UNION			0x0001
#define QDDB_KEYLIST_OP_INTERSECTION		0x0002
#define QDDB_KEYLIST_OP_EXCLUSION		0x0004

/* Qddb_KeyListProcess operations */
#define QDDB_KEYLIST_PROC_MARK 			0x0001
#define QDDB_KEYLIST_PROC_PRUNE			0x0002
#define QDDB_KEYLIST_PROC_SORT 			0x0004
#define QDDB_KEYLIST_PROC_SPLIT			0x0008
#define QDDB_KEYLIST_PROC_NULLOP		0x0010

/* KeyList comparison macros */
#define QDDB_KEYLIST_TYPE( x )		((x)->Type & (ORIGINAL|CHANGE|ADDITION|NEWENTRY))
#define QDDB_KEYLIST_ISANY( x )		(((x)->Type & ANYRESULT) != 0)
#define QDDB_KEYLIST_SET_TYPE( x, y )	((x)->Type = \
					 ((((unsigned)(x)->Type & ~(ORIGINAL|CHANGE|ADDITION|NEWENTRY)) | y)))
#define QDDB_KEYLIST_SET_ANY(x)		((x)->Type |= ANYRESULT)

#define QDDB_KEYLIST_SAMEENTRY(Src, i)	(((QDDB_KEYLIST_TYPE(Src) == ORIGINAL && \
					  QDDB_KEYLIST_TYPE(i) == ORIGINAL && (i)->Start == (Src)->Start) \
					 || (QDDB_KEYLIST_TYPE(i) != ORIGINAL && \
					     QDDB_KEYLIST_TYPE(i) == QDDB_KEYLIST_TYPE(Src) && \
					     (i)->Number == (Src)->Number)))

#define QDDB_KEYLIST_SAMEATTR(Src, i)	((((QDDB_KEYLIST_TYPE(Src) == ORIGINAL && \
					  QDDB_KEYLIST_TYPE(i) == ORIGINAL && (i)->Start == (Src)->Start) \
					 || (QDDB_KEYLIST_TYPE(i) != ORIGINAL && \
					     QDDB_KEYLIST_TYPE(i) == QDDB_KEYLIST_TYPE(Src) \
					     && (i)->Number == (Src)->Number)) \
					  && (Src)->Attribute == (i)->Attribute && \
					  strcmp((Src)->Instance, (i)->Instance) == 0))

#define QDDB_KEYLIST_DELDUP_MATCH(Src, i, flags) \
            (((flags & QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY) != 0 && QDDB_KEYLIST_SAMEENTRY(Src, i)) || \
	    ((flags & QDDB_KEYLIST_FLAG_DELDUP_SAMEATTR) != 0 && QDDB_KEYLIST_SAMEATTR(Src, i)))

typedef struct {
    char		**attrs;
    int			attr_len;
} Qddb_PruneArgs;

typedef struct kl {
    off_t		Start;
    size_t		Length, Attribute, Number;
    char 		*Instance;
    KeyListType		Type;
    struct kl		*next;
} KeyList;

#define QDDB_KEYLIST_HASH_NUM		1024
#define QDDB_KEYLIST_HASH_VAL(x)	( x % QDDB_KEYLIST_HASH_NUM )

KeyList *Qddb_KeyListOp _ANSI_ARGS_((Schema *, KeyList *, KeyList *, int, int));
void *Qddb_KeyListProcess _ANSI_ARGS_((Schema *, KeyList *, void *, int, int));
KeyList *Qddb_KeyListConcat _ANSI_ARGS_((KeyList *, KeyList *, KeyList **)); /* fast KeyList concat */
#endif
