/*
   engtest.c
   ---------

   Testing the database engine

   by Bjoern Lemke, 15-12-94

*/

#include <stdio.h>
#include "eng.h"

#define TESTREL "testrel"
#define ATTSTRING "Attribute List"

main(int argc, char **argv)
{
  AttList pkey, atts;
  char pkbuf[100], attbuf[100], pkbuf2[100];
  Relation *rel;
  int i;
  float floatval;
  long longval;
  char *bufptr;

  switch(argv[2][0]) {
  case 'i':
    pkey.num_f = 2;
    pkey.type[0]=T_LONG;
    pkey.type[1]=T_CHAR;
    strcpy(pkey.name[0], "PK1");
    strcpy(pkey.name[1], "PK2");
    pkey.size[0]=4;
    pkey.size[1]=20;
    printf("initialize .... -> %d\n", eng_init(argv[1], argv[1], &pkey));
    break;
  case 'x':
    atts.num_f = 2;
    atts.type[0]=T_FLOAT;
    atts.type[1]=T_CHAR;
    strcpy(atts.name[0], "A1");
    strcpy(atts.name[1], "A2");
    atts.size[0]=8;
    atts.size[1]=42;
    printf("extend .... -> %d\n", eng_extend(argv[1], &atts));
    break;
  case 'a':
    rel = eng_begin(argv[1], WRITE);
    if (rel != NULL) {
      printf("Writing tuple:\n");
      sprintf(pkbuf, "Pkey%s", argv[3]);
      strcpy(attbuf+sizeof(fd_set), ATTSTRING);
      printf("eng_add returned %d\n", eng_add(rel, pkbuf, attbuf));
    }
    eng_commit(rel);
    break;
  case 'A':
    rel = eng_begin(argv[1], WRITE);
    if (rel != NULL) {
      printf("Writing uncommitted tuple:\n");
      sprintf(pkbuf, "Pkey%s", argv[3]);
      strcpy(attbuf+sizeof(fd_set), ATTSTRING);
      printf("eng_add returned %d\n", eng_add(rel, pkbuf, attbuf));
    }
    break;
  case 'd':
    rel = eng_begin(argv[1], WRITE);
    if (rel != NULL) {
      printf("Deleting tuple %s\n", argv[3]);
      sprintf(pkbuf, "Pkey%s", argv[3]);
      printf("eng_del returned %d\n", eng_del(rel, pkbuf));
    }
    eng_commit(rel);
    break;
  case 'D':
    rel = eng_begin(argv[1], WRITE);
    if (rel != NULL) {
      printf("Deleting uncommitted tuple %s\n", argv[3]);
      sprintf(pkbuf, "Pkey%s", argv[3]);
      printf("eng_del returned %d\n", eng_del(rel, pkbuf));
    }
    break;
  case 'u':
    rel = eng_begin(argv[1], WRITE);
    if (rel != NULL) {
      printf("Updating tuple:\n");
      sprintf(pkbuf, "Pkey%s", argv[3]);
      sprintf(pkbuf2, "Pkey%s", argv[4]);
      strcpy(attbuf+sizeof(fd_set), ATTSTRING);
      printf("eng_upd returned %d\n", eng_upd(rel, pkbuf, pkbuf2, attbuf));
    }
    eng_commit(rel);
    break;
  case 'U':
    rel = eng_begin(argv[1], WRITE);
    if (rel != NULL) {
      printf("Updating uncommitted tuple:\n");
      sprintf(pkbuf, "Pkey%s", argv[3]);
      sprintf(pkbuf2, "Pkey%s", argv[4]);
      strcpy(attbuf+sizeof(fd_set), ATTSTRING);
      printf("eng_upd returned %d\n", eng_upd(rel, pkbuf, pkbuf2, attbuf));
    }
    break;
  case 'p':
    rel = eng_begin(argv[1], READ);
    if (rel != NULL) {
      printf("HEADER INFO(%d):\n", rel->maxidx);
      printf("Size of Pkey: %d\n", rel->pksize);
      printf("Size of Attributes: %d\n", rel->attsize);
      printf("Maxidx: %d\n", rel->maxidx);
      for (i=0; i< rel->maxidx; i++) {
	printf("Relation %s\n", rel->relname);
	printf("Pos %d: Name=%s Atype=%d Start=%d Type=%d\n",
	       i,
	       rel->name[i],
	       rel->atype[i],
	       rel->start[i],
	       rel->type[i]);
      }
      printf("TUPLES:\n");
      if (eng_fetch(rel,  pkbuf, attbuf, FIRST) == MORETUP) {
	do {
	  for (i=0; i<rel->maxidx; i++) {
	    if (rel->atype[i] == PKEY)
	      bufptr = pkbuf;
	    else if (rel->atype[i] == ORDY)
	      bufptr = attbuf;
	    
	    if (rel->atype[i] != SEP)
	      switch (rel->type[i]) {
	      case T_CHAR:
		printf("%s ", bufptr + rel->start[i]);
		break;
	      case T_FLOAT:
		bcopy(bufptr + rel->start[i], &floatval, sizeof(float));
		printf("%s: %f ", rel->name[i], floatval);
		break;
	      case T_LONG:
		bcopy(bufptr + rel->start[i], &longval, sizeof(long));
		printf("%s: %d ", rel->name[i], longval);
		break;
	      }
	  }
	  printf("\n");
	} while(eng_fetch(rel, pkbuf, attbuf, NEXT) != ENDOFTUP);
      }
    }
    eng_commit(rel);
    break;
  case 'r':
    eng_reset(argv[1]);
    break;
  }
}
  
