/*----------------------------------------------------------------------*
** File: pql_conf.h
** 
** 
** Project:	PQL
** =====================================================================*
** Description:	PQL (SQL Subset II) - trigger values
**
**  Author:	Bjoern Lemke
**  E-Mail:	lemke@lf.net
**
** Copyright (c) 1994 Bjoern Lemke.
**----------------------------------------------------------------------*/

/* the maximum length of table names */
#define MAXTNLEN 50

/* the maximum length of attribute names */
#define MAXATTLEN 50

/* table size of the attribute tables 
   ( maximum number of attributes in one job) */
#define ATABLESIZE 100 

/* maximum length of strings (type T_CHAR) */
#define STRINGLEN 100 

/* maximum length of names */
#define NAMELEN 100

/* size of a conjunction join buffer where selected tuples 
   are stored temporary */
#define TBUFSIZE 1000000

/* result buffer for subqueries */
#define SQBUFSIZE 100000

/* maximum length of a single tuple */
#define MAXTUPLEN 1000 /* max size of a single tuple */

/* maximum table join count; how many tables can be joined */
#define MAXTABLES 10 

/* maximum attribute join count; how many attributes can be joined */
#define MAXJOINATTS 100  /* how many attributes ca be joined */

/* maximum number of allowed conjunctions for the optimized DNF join 
   evaluation */
#define MAXCJ 20 

/* maximum number of agregations in the selection list */ 
#define MAXAGREGATE 10

/* maximum number of evaluated groups */
#define MAXGROUPS 200

/* maximum number of levels for subqueries */
#define MAXLEVEL 10

/* default variable defintions */
#define VN_DBPATH "path"
#define VN_VERSEP "vsep"
#define VN_HORSEP "hsep"
#define VN_ATTMODE "amode"
#define VN_NFIELD "nfield"

#define DBPATH "/prj/db/"
#define VERSEP "NL"
#define HORSEP "TAB"
#define ATTMODE "off"
#define NFIELD "NULL"

#define HISTFILE ".pqlhistory"
#define HISTLINES 100
