/*-------------------------------------------------------------------------
 *
 * pqutils.h--
 *    some functions to make interacting with libpq a little easier
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * pqutils.h,v 1.1.1.1 1994/11/07 05:20:11 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef PQUTILS_H
#define PQUTILS_H

/* use this for memory checking of alloc and free using Tcl's memory check
  package*/
#ifdef TCL_MEM_DEBUG
#include <tcl.h>
#define palloc(x) ckalloc(x)
#define pfree(x) ckfree(x)
#define malloc(x) ckalloc(x)
#define free(x) ckfree(x)
#define realloc(x,y) ckrealloc(x,y)
#endif

#include "libpq-fe.h"

/* execute the query and also check for error result */
extern char* pq_exec(char* querybuf, char* where); 

/* execute the query and also check for error result,
   if there is no error, return the PortalBuffer associated with the result
 */
extern PortalBuffer* do_query(char* querybuf, char* where); 

  /* get an attribute from the buffer, by tuple number and attribute number */
  /* NOTE: the CALLER is responsible for freeing the string returned */
  /* NULL attributes are converted to the NULLATTR_STRING */
extern char* get_attr(PortalBuffer* portalbuf, int tupno, int attno); 

  /* get attr from a binary portal.  assume result is a varlena 
    and allocate sufficient space for it.  copy it into the struct varlena*
    note that the result is NOT a string, but a contiguous chunk of bytes
    representating the data*/
extern void* bin_get_attr(PortalBuffer* portalbuf, int tupno, int attno);

/* use this if you know that the attribute is a long.
   this saves the effort of allocating and freeing space for the string 
   if the attribute is null, 0 is returned */
extern long get_attr_long(PortalBuffer* portalbuf, int tupno, int attno); 

/* same as get_attr_long except used for iportals */
extern long bin_get_attr_long(PortalBuffer* portalbuf, int tupno, int attno); 

extern char* bin_get_attr_char16(PortalBuffer* portalbuf, int tupno, int attno); 
extern char* bin_get_attr_text(PortalBuffer* portalbuf, int tupno, int attno); 

/* 
   parse an text[]:
   given a string and an integer length, parse into an array of char*,
   input strings are of the form   {"A","B","C","D"} 

   the CALLER is responsible for allocating sufficient number of char*'s
   in the string array,

   parseTextArray will allocate space for each individual char*
 */
extern void parseTextArray(char*, int, char**);

/** takes a text varlena and returns a char* 
    the CALLER is responsible for freeing the memory of the char* returned **/
char* text2str(text* textarg);

/** takes a null-terminated char* and returns a text*
    the CALLER is responsible for freeing the memory of the text* returned **/
text* str2text(char* str);

#define NULLATTR_STRING "(null)"

#define PQUTILS_DEBUG 0
#define PQUTILS_WARN 1
#define PQUTILS_ERROR 2

void pqutils_err(/* int level, char* format, char* params */);  /* in reality an varargs interface */ 

/* set this variable to turn on debugging printf's of pqutils routines */
extern int g_pqutil_debug;

/* PQUTIL_DEBUG_EXEC     - to debug any PQexec's
   PQUTIL_DEBUG_GETATTR  - to debug get_attr()
   PQUTIL_DEBUG_ALL      - all debugging printfs
*/

#define PQUTIL_DEBUG_EXEC     (1<<1)  
#define PQUTIL_DEBUG_GETATTR  (1<<2)
#define PQUTIL_DEBUG_ALL      0xFFFF

#endif

