/*-------------------------------------------------------------------------
 *
 * globals.c--
 *    global variable declarations
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/backend/utils/init/globals.c,v 1.8 1995/02/14 21:32:10 andrew Exp
 *
 * NOTES
 *    Globals used all over the place should be declared here and not
 *    in other modules.  
 *
 *-------------------------------------------------------------------------
 */
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <sys/file.h>
#include <sys/types.h>
#include <math.h>

#include "postgres.h"
#include "miscadmin.h"		/* where the declarations go */

#include "access/heapam.h"
#include "utils/tqual.h"
#include "storage/sinval.h"
#include "storage/sinvaladt.h"
#include "storage/lmgr.h"
#include "utils/elog.h"

#include "catalog/catname.h"

int		Portfd = -1;
int		Noversion = 0;

int		MasterPid;

char		OutputFileName[MAXPGPATH] = "";

BackendId	MyBackendId;
BackendTag	MyBackendTag;

Name		UserName;
Name            DatabaseName;
String		DatabasePath;

bool		MyDatabaseIdIsInitialized = false;
Oid		MyDatabaseId = InvalidOid;
bool		TransactionInitWasProcessed = false;

bool		IsUnderPostmaster = false;
bool		IsPostmaster = false;

int             Quiet = 1;
short		DebugLvl = 0;

static NameData   UserNameData;
static NameData   DatabaseNameData;
static NameData   pg_aggregate_namedata =  { "pg_aggregate" };
static NameData   pg_am_namedata = { "pg_am" };
static NameData   pg_amop_namedata = { "pg_amop" };
static NameData   pg_amproc_namedata = { "pg_amproc" };
static NameData   pg_attribute_namedata = { "pg_attribute" };
static NameData   pg_database_namedata = { "pg_database" };
static NameData   pg_defaults_namedata = { "pg_defaults" };
static NameData   pg_demon_namedata = { "pg_demon" };
static NameData   pg_group_namedata = { "pg_group" };
static NameData   pg_index_namedata = { "pg_index" };
static NameData   pg_inheritproc_namedata = { "pg_inheritproc" };
static NameData   pg_inherits_namedata = { "pg_inherits" };
static NameData   pg_ipl_namedata = { "pg_ipl" };
static NameData   pg_language_namedata = { "pg_language" };
static NameData   pg_large_object_namedata = { "pg_large_object" };
static NameData   pg_listener_namedata = { "pg_listener" };
static NameData   pg_log_namedata = { "pg_log" };
static NameData   pg_magic_namedata = { "pg_magic" };
static NameData   pg_naming_namedata = { "pg_naming" };
static NameData   pg_opclass_namedata = { "pg_opclass" };
static NameData   pg_operator_namedata = { "pg_operator" };
static NameData   pg_parg_namedata = { "pg_parg" };
static NameData   pg_proc_namedata = { "pg_proc" };
static NameData   pg_class_namedata = { "pg_class" }; 
static NameData   pg_rewrite_namedata = { "pg_rewrite" };
static NameData   pg_server_namedata = { "pg_server" };
static NameData   pg_statistic_namedata = { "pg_statistic" };
static NameData   pg_time_namedata = { "pg_time" };
static NameData   pg_type_namedata = { "pg_type" };
static NameData   pg_user_namedata = { "pg_user" };
static NameData   pg_variable_namedata = { "pg_variable" };
static NameData   pg_version_namedata = { "pg_version" };

Name            Name_pg_aggregate;
Name            Name_pg_am;
Name            Name_pg_amop;
Name            Name_pg_amproc;
Name            Name_pg_attribute;
Name            Name_pg_database;
Name            Name_pg_defaults;
Name            Name_pg_demon;
Name            Name_pg_group;
Name            Name_pg_index;
Name            Name_pg_inheritproc;
Name            Name_pg_inherits;
Name            Name_pg_ipl;
Name            Name_pg_language;
Name            Name_pg_large_object;
Name            Name_pg_listener;
Name            Name_pg_log;
Name            Name_pg_magic;
Name            Name_pg_naming;
Name            Name_pg_opclass;
Name            Name_pg_operator;
Name            Name_pg_parg;
Name            Name_pg_proc;
Name            Name_pg_class;
Name            Name_pg_rewrite;
Name            Name_pg_server;
Name            Name_pg_statistic;
Name            Name_pg_time;
Name            Name_pg_type;
Name            Name_pg_user;
Name            Name_pg_variable;
Name            Name_pg_version;

/* the following names are synonyms for Name_pg_*,
   unfortunately, both sets of names are used throughout the code */

Name	AggregateRelationName;
Name	AccessMethodRelationName;
Name	AccessMethodOperatorRelationName;
Name	AccessMethodProcedureRelationName;
Name	AttributeRelationName;
Name	DatabaseRelationName;
Name	DefaultsRelationName;
Name	DemonRelationName;
Name	GroupRelationName;
Name	IndexRelationName;
Name	InheritProcedureRelationName;
Name	InheritsRelationName;
Name	InheritancePrecidenceListRelationName;
Name	LanguageRelationName;
Name	ListenerRelationName;
Name    LogRelationName;
Name	MagicRelationName;
Name	OperatorClassRelationName;
Name	OperatorRelationName;
Name	ProcedureArgumentRelationName;
Name	ProcedureRelationName;
Name	Prs2PlansRelationName;
Name	Prs2RuleRelationName;
Name	Prs2StubRelationName;
Name	RelationRelationName;
Name	RewriteRelationName;
Name	ServerRelationName;
Name	StatisticRelationName;
Name    TimeRelationName;
Name	TypeRelationName;
Name	UserRelationName;
Name	VariableRelationName;
Name	VersionRelationName;

Name IndexedCatalogNames[] = {
    &pg_attribute_namedata,
    &pg_proc_namedata,
    &pg_type_namedata,
    &pg_naming_namedata,
    &pg_class_namedata,
    (Name) NULL
};


/* ----------------
 *	WARNING  WARNING  WARNING  WARNING  WARNING  WARNING
 *
 *	keep SharedSystemRelationNames[] in SORTED order!  A binary search
 *	is done on it in catalog.c!
 *
 *	XXX this is a serious hack which should be fixed -cim 1/26/90
 * ----------------
 */
Name SharedSystemRelationNames[10] = {
	&pg_database_namedata,
	&pg_defaults_namedata,
	&pg_demon_namedata,
	&pg_group_namedata,
	&pg_log_namedata,
	&pg_magic_namedata,
	&pg_server_namedata,
	&pg_time_namedata,
	&pg_user_namedata,
	&pg_variable_namedata
};

/* set up global variables, pointers, etc. */
void InitGlobals()
{
    UserName = &UserNameData;
    DatabaseName = &DatabaseNameData;
    DatabasePath = malloc(MAXPGPATH);
    
    Name_pg_aggregate = &pg_aggregate_namedata;
    Name_pg_am = &pg_am_namedata;
    Name_pg_amop = &pg_amop_namedata;
    Name_pg_amproc = &pg_amproc_namedata;
    Name_pg_attribute = &pg_attribute_namedata;
    Name_pg_database = &pg_database_namedata;
    Name_pg_defaults = &pg_defaults_namedata;
    Name_pg_demon = &pg_demon_namedata;
    Name_pg_group = &pg_group_namedata;
    Name_pg_index = &pg_index_namedata;
    Name_pg_inheritproc = &pg_inheritproc_namedata;
    Name_pg_inherits = &pg_inherits_namedata;
    Name_pg_ipl = &pg_ipl_namedata;
    Name_pg_language = &pg_language_namedata;
    Name_pg_large_object = &pg_large_object_namedata;
    Name_pg_listener = &pg_listener_namedata;
    Name_pg_log = &pg_log_namedata;
    Name_pg_magic = &pg_magic_namedata;
    Name_pg_naming = &pg_naming_namedata;
    Name_pg_opclass = &pg_opclass_namedata;
    Name_pg_operator = &pg_operator_namedata;
    Name_pg_parg = &pg_parg_namedata;
    Name_pg_proc = &pg_proc_namedata;
    Name_pg_class = &pg_class_namedata;
    Name_pg_rewrite = &pg_rewrite_namedata;
    Name_pg_server = &pg_server_namedata;
    Name_pg_statistic = &pg_statistic_namedata;
    Name_pg_time = &pg_time_namedata;
    Name_pg_type = &pg_type_namedata;
    Name_pg_user = &pg_user_namedata;
    Name_pg_variable = &pg_variable_namedata;
    Name_pg_version = &pg_version_namedata;
    
    AggregateRelationName = Name_pg_aggregate;
    AccessMethodRelationName = Name_pg_am;
    AccessMethodOperatorRelationName = Name_pg_amop;
    AccessMethodProcedureRelationName = Name_pg_proc;
    AttributeRelationName = Name_pg_attribute;
    DatabaseRelationName = Name_pg_database;
    DefaultsRelationName = Name_pg_defaults;
    DemonRelationName = Name_pg_demon;
    GroupRelationName = Name_pg_group;
    IndexRelationName = Name_pg_index;
    InheritProcedureRelationName = Name_pg_inheritproc;
    InheritsRelationName = Name_pg_inherits;
    InheritancePrecidenceListRelationName = Name_pg_ipl;
    LanguageRelationName = Name_pg_language;
    ListenerRelationName = Name_pg_listener;
    LogRelationName = Name_pg_log;
    MagicRelationName = Name_pg_magic;
    OperatorClassRelationName = Name_pg_opclass;
    OperatorRelationName = Name_pg_operator;
    ProcedureArgumentRelationName = Name_pg_parg;
    ProcedureRelationName = Name_pg_proc;
    RelationRelationName = Name_pg_class;
    RewriteRelationName = Name_pg_rewrite;
    ServerRelationName = Name_pg_server;
    StatisticRelationName = Name_pg_statistic;
    TimeRelationName = Name_pg_time;
    TypeRelationName = Name_pg_type;
    UserRelationName = Name_pg_user;
    VariableRelationName = Name_pg_variable;
    VersionRelationName = Name_pg_version;

    MasterPid = getpid();
}

