/*-------------------------------------------------------------------------
 *
 * xid.c--
 *    POSTGRES transaction identifier code.
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/backend/access/transam/xid.c,v 1.3 1995/02/13 19:47:10 andrew Exp
 *
 * OLD COMMENTS
 * XXX WARNING
 *	Much of this file will change when we change our representation
 *	of transaction ids -cim 3/23/90
 *
 * It is time to make the switch from 5 byte to 4 byte transaction ids
 * This file was totally reworked. -mer 5/22/92
 *
 *-------------------------------------------------------------------------
 */
#include <stdio.h>
#include "postgres.h"
#include "utils/palloc.h"
#include "utils/elog.h"
#include "utils/memutils.h"
#include "utils/nabstime.h"

/* #include "access/transam.h" */

extern TransactionId NullTransactionId;
extern TransactionId DisabledTransactionId;
extern TransactionId AmiTransactionId;
extern TransactionId FirstTransactionId;

/* ----------------------------------------------------------------
 * 	TransactionIdIsValid
 *
 *	Macro-ize me.
 * ----------------------------------------------------------------
 */
bool
TransactionIdIsValid(TransactionId transactionId)
{
    return ((bool) (transactionId != NullTransactionId) );
}

/* ----------------------------------------------------------------
 *	StringFormTransactionId
 *
 *	Not sure if this is still needed -mer 5/22/92
 * ----------------------------------------------------------------
 */
TransactionId
StringFormTransactionId(String representation)
{
    return (atol(representation));
}

/* XXX char16 name for catalogs */
TransactionId
xidin(String representation)
{
    return (StringFormTransactionId(representation));
}

/* ----------------------------------------------------------------
 *	TransactionIdFormString
 * ----------------------------------------------------------------
 */
String
TransactionIdFormString(TransactionId transactionId)
{
    String			representation;
    
    /* maximum 32 bit unsigned integer representation takes 10 chars */
    representation = palloc(11);
    
    (void)sprintf(representation, "%u", transactionId);
    
    return (representation);
}

/* XXX char16 name for catalogs */
String
xidout(TransactionId transactionId)
{
    return(TransactionIdFormString(transactionId));
}

/* ----------------------------------------------------------------
 *	StoreInvalidTransactionId
 *
 *	Maybe do away with Pointer types in these routines.
 *      Macro-ize this one.
 * ----------------------------------------------------------------
 */
void
StoreInvalidTransactionId(TransactionId *destination)
{
    *destination = NullTransactionId;
}

/* ----------------------------------------------------------------
 *	TransactionIdStore
 *
 *      Macro-ize this one.
 * ----------------------------------------------------------------
 */
void
TransactionIdStore(TransactionId transactionId,
		   TransactionId *destination)
{
    *destination = transactionId;
}

/* ----------------------------------------------------------------
 *	TransactionIdEquals
 * ----------------------------------------------------------------
 */
bool
TransactionIdEquals(TransactionId id1, TransactionId id2)
{
    return ((bool) (id1 == id2));
}

/* ----------------------------------------------------------------
 *	TransactionIdIsLessThan
 * ----------------------------------------------------------------
 */
bool
TransactionIdIsLessThan(TransactionId id1, TransactionId id2)
{
    return ((bool)(id1 < id2));
}

/* ----------------------------------------------------------------
 *	xideq
 * ----------------------------------------------------------------
 */

/*
 *	xideq		- returns 1, iff xid1 == xid2
 *				  0  else;
 */
bool
xideq(TransactionId xid1, TransactionId xid2)
{
    return( (bool) (xid1 == xid2) );
}



/* ----------------------------------------------------------------
 *	TransactionIdIncrement
 * ----------------------------------------------------------------
 */
void
TransactionIdIncrement(TransactionId *transactionId)
{
    
    (*transactionId)++;
    if (*transactionId == DisabledTransactionId)
	elog(FATAL, "TransactionIdIncrement: exhausted XID's");
    return;
}

/* ----------------------------------------------------------------
 *	TransactionIdAdd
 * ----------------------------------------------------------------
 */
void
TransactionIdAdd(TransactionId *xid, int value)
{
    *xid += value;
    return;
}

/* ----------------------------------------------------------------
 *	TransactionIdGetApproximateTime
 * ----------------------------------------------------------------
 */
AbsoluteTime
TransactionIdGetApproximateTime(TransactionId *transactionId)
{
    AbsoluteTime temp;
    temp = (*transactionId) / TransactionsPerSecondAdjustment;
    return(temp);
}
