#include <stdio.h>
#include <signal.h>
#include "ldbf.h"
#include <fcntl.h>
static int sock;
extern int ldbf_errno;

void sigHandler(int sig)
{
   printf("Recieved signal %d on socket %d\n",sig,sock);
   ldbfShutdown(sock);
   exit(0);
}

main(argc,argv)
	int	argc;
	char	*argv[];
{
	int	count,ok=0,i;
	char	buf[60],ss[50],comm[30],dbname[50];
        DB      *data = 0;
        TAGINFO *taginfo;

        strcpy(buf,"localhost");
        if(argc > 1) strcpy(buf,argv[1]);
	if ((sock = ldbfConnect(buf)) < 0)
	{
		fprintf(stderr,"Couldn't connect to LDBF server on %s\n%d\n",
			buf,ldbf_errno);
		exit(1);
	}
   signal(SIGINT,sigHandler);
   memset(dbname,0,sizeof(dbname));
   while(strcmp("quit",ss) != 0) { 
     printf("\nStatus:%d:%d %s\n",ok,ldbf_errno,ldbferr_text(ldbf_errno));
     memset(ss,0,sizeof(ss));
     memset(comm,0,sizeof(comm));
     memset(buf,0,sizeof(buf));
     printf("ldbf>");gets(ss);
     getword(1,ss," ",comm); 
     trim(comm);
     if(!strcmp(ss,"help") || !strcmp(ss,"?")) {
      printf("Available commands:\n");
      printf("          open databasename [EXCL] - open database \n\
          print - print content of current record \n\
          append  - add new empty record at the end of database\n\
          close - close database \n\
          stru - show structure of database \n\
          taginfo - show all index tags \n\
          tag tagname - select active tag \n\
          goto recnumber- go to specified record \n\
          seek value - seek record using current active tag\n\
          delete - delete current record \n\
          recall - undelete current record \n\
          replace field value - replace field of current record\n\
          skip recnumber - skip specified number of records \n\
          status - print status of database\n\
          update - update changed record\n\
          lock - locks current record\n\
          unlock - unlocks current record\n\
          flock - locks entire database\n\
          funlock - unlocks database\n\
          reindex - reindexes database\n\
          pack - packs database\n\
          zap - zaps database\n\
          begin - start transaction\n\
          abort - abort transaction\n\
          commit - commit transaction\n\
          quit - quit from LDBF client\n");
       continue;
     }
     if(!data && strcmp(comm,"open") && strcmp(comm,"quit")) {
       printf("Database must be opened before\n");
       continue;
     }
     if(strcmp(comm,"open") == 0 && !data) {
        if(wordcnt(ss," ") < 2) {
          printf("Enter name of database:");
          gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        if(strstr(ss,"EXCL")) i = O_EXCL; else i = 0; 
        data = ldbfOpen(sock,buf,i);
        if(data) {
          strcpy(dbname,buf);
          if(i == O_EXCL) printf("%s opened in exclusive mode\n",dbname);
        }
        continue;
     }
     if(strcmp(comm,"replace") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter name of field to replace:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        } 
        if(wordcnt(ss," ") < 3) {
           printf("Enter new value of field:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        }
        getword(2,ss," ",buf);
        getword(3,ss," ",comm);
        trim(buf); 
        ldbfAssign(ldbfField(data,buf),comm);
        continue;
    }
     if(strcmp(comm,"skip") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter number of records to skip:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        if(atol(buf) == 0) continue;
        ok = ldbfSkip(data,atol(buf));
        continue;
    }
     if(strcmp(comm,"tag") == 0) {
        if(wordcnt(ss," ") < 2) {
          printf("Enter name of tag to select:");
          gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        strcpy(data->tag,buf);
        continue;
     }
     if(strcmp(comm,"lock") == 0) {
        ok = ldbfLock(data,data->recno);
        continue;
    }
    if(strcmp(comm,"flock") == 0) {
        ok = ldbfFlock(data);
        continue;
    }
    if(strcmp(comm,"close") == 0) {
        ldbfClose(data);
        data = 0;
        continue;
    }
     if(strcmp(comm,"goto") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter number of record:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        if(atol(buf) <= 0) continue;
        ok = ldbfGoto(data,atol(buf));
        continue;
    }
     if(strcmp(comm,"seek") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter data for seek:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        ok = ldbfSeek(data,buf);
        continue;
     }
     if(strcmp(comm,"append") == 0) {
        ok = ldbfAppend(data);
        continue;
     }
     if(strcmp(comm,"unlock") == 0) {
        ldbfUnlock(data,data->recno);
        continue;
     }
     if(strcmp(comm,"reindex") == 0) {
        ldbfReindex(data);
        continue;
     }
     if(strcmp(comm,"pack") == 0) {
        ldbfPack(data);
        continue;
     }
     if(strcmp(comm,"zap") == 0) {
        ldbfZap(data);
        continue;
     }
     if(strcmp(comm,"funlock") == 0) {
        ldbfFunlock(data);
        continue;
     }
     if(strcmp(comm,"delete") == 0) {
        ok = ldbfDelete(data);
        continue;
     }
     if(strcmp(comm,"update") == 0) {
        ok = ldbfUpdate(data);
        continue;
     }
     if(strcmp(comm,"recall") == 0) {
        ok = ldbfRecall(data,data->recno);
        continue;
     }
     if(strcmp(comm,"begin") == 0) {
        ldbfBeginTTS(sock);
        continue;
     }
     if(strcmp(comm,"abort") == 0) {
        ldbfAbortTTS(sock);
        continue;
     }
     if(strcmp(comm,"commit") == 0) {
        ok = ldbfCommitTTS(sock);
        continue;
     }
     if(strcmp(comm,"print") == 0) {
        printf("\n%s\n",data->record);
        continue;
     }
     if(strcmp(comm,"status") == 0) {
       printf("%s current:%ld reccount:%ld\n",dbname,data->recno,data->reccount);
       continue;
     }
     if(strcmp(comm,"stru") == 0) {
        printf("alias:%s record width:%d reccount:%ld\n",
                  dbname,data->record_width,data->reccount);
        printf(" NAME          TYPE   LEN   DEC\n"); 
        printf("-----------------------------------------------------------------------\n");
        for(i=0;i<data->n_fields;i++) {
         printf("%-11s    %c    %3d     %3d \n",data->fields[i].name,
                 data->fields[i].type,
                 data->fields[i].len,data->fields[i].dec);
        }
        continue;
     }
     if(strcmp(comm,"taginfo") == 0) {
        printf("NAME        EXPRESSION         FILTER        UNIQUE   DESCENDING\n");
        printf("----------------------------------------------------------------------\n");
        taginfo = (TAGINFO *)ldbfTaginfo(data);
        if(taginfo)
        for(i=0;taginfo[i].name[0] != '\0';i++) {
         printf("%s  %s  %s  %2d %2d\n",taginfo[i].name,taginfo[i].expression, 
                taginfo[i].filter,taginfo[i].unique,taginfo[i].descending);
        }
        if(taginfo) free(taginfo);
        continue;
     }
   }
   if(strcmp(comm,"quit") == 0) {
     ldbfCloseall(sock);
     ldbfShutdown(sock);
   }
   exit(0);
}

