/* -*- Mode: C -*- */
/* Librarian.cc - Librarian - query program main line
 * Created by Robert Heller on Tue Mar 17 16:57:42 1992
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Librarian program - search a card catalog
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <stream.h>
#include <vBTree.h>
#include <ctype.h>
#ifdef MESSYDOS
#include <CardRec.h>
#include <ListRec.h>
#else
#include <CardRecord.h>
#include <ListRecord.h>
#endif
#include <Terminal.h>
#ifdef MESSYDOS
#include <CmdScren.h>
#include <ScrPmt.h>
#include <LLScrPmt.h>
#else
#include <CommandScreen.h>
#include <ScrollPrompt.h>
#include <LLScrollPrompt.h>
#endif
#define VERSION "V1.0Beta"
#ifdef MESSYDOS
#include "Libraria.h"
#else
#include "Librarian.h"
#endif

#ifdef unix
#include <stdio.h>
#endif

static vBTree *Tree;
static Terminal *Term;

const DisplayBufferSize = 4096;
const Margin = 256;
static char DisplayBuffer[DisplayBufferSize];

void DispCard(Key inkey)
{
	int column;
	int lines = 0;
	ScrollPrompt CardOutput("",3,0,80,15,20);
	static char answer[1];
	CoreItem item;
	if (!(Tree->SearchId(inkey,&item) &&
	      strlen(inkey) == strlen(item.key))) return;		
	char* outptr = DisplayBuffer;
	strcpy(outptr,item.key); outptr += strlen(item.key);
	*outptr++ = '\n';
	*outptr++ = '\n';
	if (item.data.size > 0) {
		CardRecord rec(&item.data);
		register Card *c = &rec;
		char* tn = TypeName(c->type);
		strcpy(outptr,c->author); outptr += strlen(c->author);
		*outptr++ = ',';
		*outptr++ = ' ';
		sprintf(outptr,"%d\n",c->year); outptr += strlen(outptr);
		strcpy(outptr,"    "); outptr += strlen(outptr);
		strcpy(outptr,c->title); outptr += strlen(outptr);
		*outptr++ = '\n';
		strcpy(outptr,"    "); outptr += strlen(outptr);
		strcpy(outptr,tn); outptr += strlen(tn);
		*outptr++ = '\n';
		strcpy(outptr,"    Published by "); outptr += strlen(outptr);
		strcpy(outptr,c->publisher); outptr += strlen(outptr);
		*outptr++ = ' ';
		strcpy(outptr,c->city); outptr += strlen(outptr);
		*outptr++ = '\n';
		if (c->vol != 0) {
			sprintf(outptr,"    Volume: %d",c->vol);
			outptr += strlen(outptr);
		}
		*outptr++ = '\n';
		*outptr++ = '\n';
		column = 0;
		for (char* p = c->description; lines < 22 && *p != 0; p++) {
			if (*p != '\n' && column < 4) {
				*outptr++ = ' ';
				*outptr++ = ' ';
				*outptr++ = ' ';
				*outptr++ = ' ';
				column = 4;
			}
			if (*p == '\n') {
				*outptr++ = '\n';
				lines++;
				column = 0;
			} else if (column > 78) {
				*outptr++ = '\\';
				*outptr++ = '\n';
				lines++;
				column = 0;
				p--;
			} else if (*p == '\t') {
				do {
					*outptr++ = ' ';
					column++;
				} while ((column % 8) != 0);
			} else {
				*outptr++ = *p;
				column++;
			}
		}
		if (column > 0) {
			*outptr++ = '\n';
			lines++;
		}
		*outptr = '\0';
		CardOutput.Scroll(DisplayBuffer,"Hit RETURN to continue",answer,1);
	}
}

int ListCards()
{
	CoreItem item;
	Key searchkey;
	static char title[80], line[LineLength];
	Term->PromptLine(18,0,"Search prefix: ",searchkey,KeySize);
	sprintf(title,"Ids matching %s",searchkey);
	LLScrollPrompt IdList(title,3,0,80,15,20);
	LineList* llist = (LineList*) 0;
	LineList** ptr = &llist;
	LineList* prev = (LineList*) 0;
	if (Tree->SearchId(searchkey,&item)) {
		do {
			int fill;
			char* p = line;
			strcpy(p,item.key);
			fill = KeySize - strlen(item.key);
			p += strlen(item.key);
			while (fill-- > 0) *p++ = ' ';
			*p++ = ' ';
			{
				CardRecord crec(&item.data);
				strcpy(p,crec->title);
				p += strlen(crec->title);
			}
			*p++ = 0;
			LineList* newline = new LineList(line,0,prev);
			*ptr = newline;
			prev = newline;
			ptr = &newline->nextline;
			//cerr << "*** line = '" << line << "'\n";
		} while (Tree->SearchIdAgain(&item));
		if (llist != (LineList*) 0) {
			if (IdList.Scroll(llist,"Card to view (RETURN for more, q to exit):",title,KeySize) > 0) 
				DispCard(title);
			FreeLineList(llist);
		}
		return(-1);
	} else {
		Term->Message("No ids found");
		return(1);
	}
}

int ListCardsFromList(char* title,ListRecord& list)
{
	CoreItem item;
	static Key newkey;
	static char line[LineLength];
	LLScrollPrompt IdList(title,3,0,80,15,20);
	LineList* llist = (LineList*) 0;
	LineList** ptr = &llist;
	LineList* prev = (LineList*) 0;
	int numids = list.ElementCount();
	for (int i = 0; i < numids; i++) {
		if (Tree->SearchId(list[i],&item) && strlen(list[i]) == strlen(item.key)) {
			int fill;
			char* p = line;
			strcpy(p,item.key);
			fill = KeySize - strlen(item.key);
			p += strlen(item.key);
			while (fill-- > 0) *p++ = ' ';
			*p++ = ' ';
			{
				CardRecord crec(&item.data);
				strcpy(p,crec->title);
				p += strlen(crec->title);
			}
			*p++ = 0;
			LineList* newline = new LineList(line,0,prev);
			*ptr = newline;
			prev = newline;
			ptr = &newline->nextline;
		}
	}
	if (llist != (LineList*) 0) {
		if (IdList.Scroll(llist,"Card to view (RETURN for more, q to exit):",title,KeySize) > 0) 
			DispCard(title);
		FreeLineList(llist);
	}
	return(-1);
}

int ListTitles()
{
	CoreItem item;
	Key searchkey;
	static char title[80],header[80],line[LineLength];
	Term->PromptLine(18,0,"Search prefix: ",searchkey,KeySize);
	sprintf(title,"Titles matching %s",searchkey);
	LLScrollPrompt TitleList(title,3,0,80,15,20);
	LineList* llist = (LineList*) 0;
	LineList** ptr = &llist;
	LineList* prev = (LineList*) 0;
	int i;
	int refnum = 0;
	if (Tree->SearchTitle(searchkey,&item)) {
		do {
			refnum++;
			sprintf(line,"%3d: %s",refnum,item.key);
			LineList* newline = new LineList(line,0,prev);
			*ptr = newline;
			prev = newline;
			ptr = &newline->nextline;
		} while (Tree->SearchTitleAgain(&item));
		if (llist != (LineList*) 0) {
			if (refnum == 1) {
				if (Tree->SearchTitle(llist->thisline+5,&item)) {
					sprintf(header,"Ids for title %s",item.key);
					ListRecord rec(&item.data);
					if (rec.ElementCount() == 1) DispCard(rec[0]);
					else if (rec.ElementCount() > 1)
						ListCardsFromList(header,rec);
				}
			} else if (TitleList.Scroll(llist,"Ref#, RETURN for more, q to exit:",title,KeySize) > 0) {
				refnum = atoi(title);
				for (i = 1,prev = llist;
				     prev != (LineList*)0 && i < refnum;
				     prev = prev->nextline,i++) ;
				if (i == refnum) {
					if (Tree->SearchTitle(prev->thisline+5,&item)) {
						sprintf(header,"Ids for title %s",item.key);
						ListRecord rec(&item.data);
						if (rec.ElementCount() == 1) DispCard(rec[0]);
						else if (rec.ElementCount() > 1)
							ListCardsFromList(header,rec);
					}
				} else Term->Message("Bad reference number");
			}
			FreeLineList(llist);
		}
		return(-1);
	} else {
		Term->Message("No titles found");
		return(1);
	}
}

int ListAuthors()
{
	CoreItem item;
	Key searchkey;
	static char title[80],header[80],line[LineLength];
	Term->PromptLine(18,0,"Search prefix: ",searchkey,KeySize);
	sprintf(title,"Authors matching %s",searchkey);
	LLScrollPrompt AuthorList(title,3,0,80,15,20);
	LineList* llist = (LineList*) 0;
	LineList** ptr = &llist;
	LineList* prev = (LineList*) 0;
	int refnum = 0;
	int i;
	if (Tree->SearchAuthor(searchkey,&item)) {
		do {
			refnum++;
			sprintf(line,"%3d: %s",refnum,item.key);
			LineList* newline = new LineList(line,0,prev);
			*ptr = newline;
			prev = newline;
			ptr = &newline->nextline;
		} while (Tree->SearchAuthorAgain(&item));
		if (llist != (LineList*) 0) {
			if (refnum == 1) {
				if (Tree->SearchAuthor(llist->thisline+5,&item)) {
					sprintf(header,"Ids for author %s",item.key);
					ListRecord rec(&item.data);
					if (rec.ElementCount() == 1) DispCard(rec[0]);
					else if (rec.ElementCount() > 1)
						ListCardsFromList(header,rec);
				}
			} else if (AuthorList.Scroll(llist,"Ref#, RETURN for more, q to exit:",title,KeySize) > 0) {
				refnum = atoi(title);
				for (i = 1,prev = llist;
				     prev != (LineList*)0 && i < refnum;
				     prev = prev->nextline,i++) ;
				if (i == refnum) {
					if (Tree->SearchAuthor(prev->thisline+5,&item)) {
						sprintf(header,"Ids for author %s",item.key);
						ListRecord rec(&item.data);
						if (rec.ElementCount() == 1) DispCard(rec[0]);
						else if (rec.ElementCount() > 1)
							ListCardsFromList(header,rec);
					}
				} else Term->Message("Bad reference number");
			}
			FreeLineList(llist);
		}
		return(-1);
	} else {
		Term->Message("No authors found");
		return(1);
	}
}

int ListSubjects()
{
	CoreItem item;
	Key searchkey;
	static char title[80],header[80],line[LineLength];
	Term->PromptLine(18,0,"Search prefix: ",searchkey,KeySize);
	sprintf(title,"Subjects matching %s",searchkey);
	LLScrollPrompt SubjectList(title,3,0,80,15,20);
	LineList* llist = (LineList*) 0;
	LineList** ptr = &llist;
	LineList* prev = (LineList*) 0;
	int refnum = 0;
	int i;
	if (Tree->SearchSubj(searchkey,&item)) {
		do {
			refnum++;
			sprintf(line,"%3d: %s",refnum,item.key);
			LineList* newline = new LineList(line,0,prev);
			*ptr = newline;
			prev = newline;
			ptr = &newline->nextline;
		} while (Tree->SearchSubjAgain(&item));
		if (llist != (LineList*) 0) {
			if (refnum == 1) {
				if (Tree->SearchSubj(llist->thisline+5,&item)) {
					sprintf(header,"Ids for subject %s",item.key);
					ListRecord rec(&item.data);
					if (rec.ElementCount() == 1) DispCard(rec[0]);
					else if (rec.ElementCount() > 1)
						ListCardsFromList(header,rec);
				}
			} else if (SubjectList.Scroll(llist,"Ref#, RETURN for more, q to exit:",title,KeySize) > 0) {
				refnum = atoi(title);
				for (i = 1,prev = llist;
				     prev != (LineList*)0 && i < refnum;
				     prev = prev->nextline,i++) ;
				if (i == refnum) {
					if (Tree->SearchSubj(prev->thisline+5,&item)) {
						sprintf(header,"Ids for subject %s",item.key);
						ListRecord rec(&item.data);
						if (rec.ElementCount() == 1) DispCard(rec[0]);
						else if (rec.ElementCount() > 1)
							ListCardsFromList(header,rec);
					}
				} else Term->Message("Bad reference number");
			}
			FreeLineList(llist);
		}
		return(-1);
	} else {
		Term->Message("No subjects found");
		return(1);
	}
}

static int Quit()
{
	return 0;
}

static CommandDescr Main[] = {
	{ "Quit", Quit, 0 },
	{ "List Cards", ListCards, 0 },
	{ "List Titles", ListTitles, 0 },
	{ "List Authors", ListAuthors, 0 },
	{ "List Subjects", ListSubjects, 0 },
};

const NumCommands = sizeof(Main) / sizeof(CommandDescr);

main(int argc,char** argv)
{
	static Librarian args(argc,argv);
	vBTree tree(args.infile,ReadOnly,0);
	if (tree.OpenStat() == failure) {
		int error = errno;
		cerr << "Could not open " << args.infile << ": "
		     << strerror(error) << "\n";
		exit(error);
	}
	Terminal term;
	Term = &term;
	static CommandScreen mainScreen("Main Command Menu",NumCommands,Main);
	Tree = &tree;

	mainScreen.RunScreen();
}


