/* -*- Mode: C -*- */
/* ScrollPrompt.cc - Scroll with prompt
 * Created by Robert Heller on Fri Dec 13 23:20:49 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#ifdef MESSYDOS
#include <scrpmt.h>
#else
#include <ScrollPrompt.h>
#endif

int ScrollPrompt::Scroll(const char* scrolltext,const char* prompt,char* answer,int answersize)
{
	int c = (Terminal::term->colms - strlen(Title)) >> 1;
	Terminal::term->Clear();
	Terminal::term->RevsPen();
	Terminal::term->PutStrAt(1,c,Title);
	Terminal::term->PlainPen();
	const char* p = scrolltext;
	while (p != 0) {
		p = Terminal::term->PutStrInBox(ScrollRow,ScrollCol,
						ScrollWidth,ScrollHeight,p);
		if (p == 0) break;
		int nchars = Terminal::term->PromptLine(PromptRow,0,prompt,answer,answersize);
		if (nchars != 0) return(nchars);
	}
	return(Terminal::term->PromptLine(PromptRow,0,prompt,answer,answersize));
}


