/* -*- Mode: C -*- */
/* ListRecord.cc - ListRecord implementation
 * Created by Robert Heller on Sat Dec  7 00:13:55 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */
#ifdef MESSYDOS
#include <listrec.h>
#else
#include <ListRecord.h>
#endif

char *ListRecord::dummy = NULL;

// ListRecord constructor, given a Record
ListRecord::ListRecord(Record* record)
{
	RawData = *record;		// copy data
	char* str = RawData.buffer;	// get data pointer
	int bytesleft = RawData.size;	// and size
	char* p = str;			// temp pointe
	int bl = bytesleft;		// temp counter

	// find element count
	for (numelts = 0;
		bl > 0 && *p != '\n'; numelts++) {
		int slen = strlen(p)+1;
		p += slen; bl -= slen;
	}
	// allocate vector
	elems = new char* [numelts];
	// fill in pointers
	for (int i = 0; i < numelts; i++) {
		elems[i] = str;
		str += strlen(str)+1;
	}
}

// ListRecord constructor, given a string vector
ListRecord::ListRecord (int numitems,char* inelems[])
{
	numelts = numitems;			// number of elements
	elems = new char* [numelts];		// allocate a vector
	for (int i = 0; i < numelts; i++) {	// copy vector
		elems[i] = inelems[i];
	}
}

// create a fresh record, given the string vector
void ListRecord::UpdateRecord ()
{
	int rsize = 2;		// "\n\0"	// size

	for (int i = 0; i < numelts; i++) {	// compute buffer size
		rsize += strlen(elems[i])+1;
	}
	char* str = new char[rsize]; char *p = str;	// allocate buffer
	// copy strings into the buffer
	for (i = 0; i < numelts; i++) {
		strcpy(p,elems[i]);
		elems[i] = p;
		p += strlen(p)+1;
	}
	// add terminator
	*p++ = '\n'; *p++ = 0;
	// free up old buffer
	RawData.NewBuffer(0);
	// paste in new buffer
	RawData.size = rsize;
	RawData.buffer = str;
}


