/* -*- Mode: C -*- */
/* vm.h - Virtual Memory hackery.
 * Created by Robert Heller on Fri Dec  6 20:37:13 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */
#ifndef _VM_
#define _VM_
#include <common.h>
#define SEEK_SET 0
#define SEEK_END 2

// This class implements the base level disk I/O for pages and records.
// It also does the working set management (deciding when to page in a
// page and when to page out a page)
class PageFile {
protected:
	int fd;				// the file descriptor itself
	Boolean isopen;			// are we really open?
	Direction direction;		// which way?
	const NumPTEntries = 50;	// WSMAX.  Max number of core
					// resident pages
	int numpagesincore;		// WSCURRENT.  Current number
					// of pages actually in memory.
	PTEntry pagetable[NumPTEntries]; // This is our page table.
	PTEntry temp;			// Scratch PT entry.
	Boolean PageRead(PTEntry&);	// Read a page
	Boolean PageWrite(PTEntry&);	// Write a page
	PTEntry & FindPage(DiskPage);	// Find a page (might cause a page in,
					// which might in turn cause a page
					// out).
public:
	// Open the file.  Does base level file open.
	OpenStatus open (char *filename,Direction direction,
		      int flags = ReadWriteFlags,
		      int mode = ReadWriteMode,
		      Boolean create_if = false);
	// Close the file.  Does base level file close.  Any core-resident
	// pages that are "dirty" (modified) are written to disk.
	void close ();
	// Constructor
	     PageFile ()
		{
			isopen = false;
			numpagesincore = 0;
			for (int i = 0;i<NumPTEntries;i++) {
				pagetable[i].isdirty = false;
				pagetable[i].corepage = 0;
			}
		}
	// Destructor.  Makes sure the file is closed.  (close() is
	// ok for a closed file - it is a noop then.)
	    ~PageFile () {close();}
	// Make a new page.
	DiskPage NewPage();
	// Base level record I/O
	int ReadRecord(DiskRecord&, char *, int);
	DiskRecord WriteRecord(char *,int);
	DiskRecord ReWriteRecord(DiskRecord&, char *,int);
	// The [] operator does DiskPage to core Page mapping.
	// Uses FindPage to find the page.  FindPage will bring the page
	// into memory if needed.  Note:  A call to this operator
	// could cause a page out.  ALLWAYS call [] to get an up-to-date
	// pointer to a Page* before referencing the core page.  ALLWAYS
	// *COPY* to local storage any pieces of a page before calling
	// [] again if you plan to copy a bit of info from one page to
	// another.
	Page * operator [] (long addr) {DiskPage page(addr);
					return((FindPage(page).corepage));}
	Page * operator [] (DiskPage page) 
					{return((FindPage(page).corepage));}
	// The () operator gets a reference to the PT entry.  ALLWAYS call
	// () and update the isdirty field after you modify a page and before
	// calling [].  It is not a good idea to keep a local copy of the
	// PT entry reference around, since they move around and a local
	// copy of the PT entry is not meaningfull, since the contents
	// is not stable.
	PTEntry & operator () (long addr) {DiskPage page(addr);
					   return(FindPage(page));}
	PTEntry & operator () (DiskPage page) {return(FindPage(page));}
};


#endif

