/* -*- Mode: C -*- */
/* CardRecord.h - A record as a card
 * Created by Robert Heller on Fri Dec  6 20:20:08 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */
#ifndef _CRECORD_
#define _CRECORD_
#include <common.h>
#include <Card.h>

// This class maps between the card on disk (as a record) and the card
// in memory (as a Card structure).
// RawData is the disk record.  Card is the structure representation
class CardRecord {
	Record RawData;
	Card* card;
	Card* RecordToCard();	// parse a card record into a Card*
	void UpdateRecord();	// convert a Card* to a record
public:
	// Constructors/type converters
	      CardRecord(Record* record);	// Record to CardRecord
	      CardRecord(CoreItem* coreitem);	// CoreItem to CardRecord
	      CardRecord(Card* card);		// Card to CardRecord
	      CardRecord(CardRecord& cardrecord); // CardRecord to CardRecord
	     ~CardRecord(); 			// get rid of a CardRecord
	// pointer magic - make a CardRecord look just like a Card*
	Card* operator -> () {return card;}
	Card& operator *  () {return *card;}
	Card* operator &  () {return card;}
	// copier function
	CardRecord& operator = (CardRecord& cardrecord);
	// Convert a CardRecord to a plain Record
	operator Record  ()
		{
			UpdateRecord();
			Record record = RawData;
			return record;
		}
};

#endif


