#include "request.h"

void main( int argc, char *argv[] )
{
  FILE *file, *output;
  WINDOW *myscreen;
  char name_out[FILENAME_MAX], filename[FILENAME_MAX];
  struct config myconfig;
  char tmp[40], pattern[40];
  int config = TRUE, name = FALSE;
  struct stat file_stat;
  struct file_pos *help;
  int c; 

  curr_pos = 0;
  pair = 0;
  last_search = 0;

  while ((c = getopt( argc, argv, "o:n:" )) != EOF )
    switch( c )
      {
      case 'o': 
		strcpy( myconfig.store_path, optarg );
		config = FALSE;
		break;
      case 'n':
		strcpy( name_out, make_name( optarg ) );
		name = TRUE;
		break;
      }

  if (optind == argc)
    {
      fprintf( stderr, "usage: %s [-o outputdir] [-n name_to_use] filename\n", argv[0] );
      exit( -1 );
    }
  else
    strcpy( filename, argv[optind] );

  if (stat( filename, &file_stat ) != 0) 
    {
      fprintf( stderr, "can't stat\n" );
      exit( -1 );
    }

  if ( file_stat.st_mode & S_IFDIR ) 
    {
      fprintf( stderr, "filename is a directory\n" );
      exit( -1 );
    }

  line = (struct file_pos *)malloc( sizeof(struct file_pos) );
  if (line == NULL)
    {
      fprintf( stderr, "Not enough memory!\n" );
      exit( -1 );
    }
  line->next = NULL;
  line->prev = NULL;
  line->position = 0L;
  line->marked = 0;
  line->lineno = 1;

  if ( ( file = fopen( filename, "r" ) ) == NULL )
    {
      fprintf( stderr, "cannot open file\n" );
      exit( -1 );
    }
  if ( config )
    get_config( &myconfig );
  
  fprintf( stdout, "request V0.1.4\n" );
  fprintf( stdout, "reading file....\n" );
     
  myscreen = initscr( );
  
  screen_height = (myscreen->_maxy) - 1;
  screen_width  =  myscreen->_maxx;
  statusline   =  myscreen->_maxy;

  noecho( ); 
  raw( );
  curs_set(0);

  if(has_colors()) 
  {
    start_color();
    init_pair(1, COLOR_WHITE, COLOR_BLUE);
    attron(COLOR_PAIR(1));
  }


  num_pages = do_list( file );
  
  fclose( file );
  
  if ( !name )
    strcpy( name_out, make_name( filename ) );

  strcat( myconfig.store_path, "/" );
  strcat( myconfig.store_path, name_out );

  keypad( myscreen, TRUE );

  make_screen( UPDATE );
  refresh( );

  while ( (c = getch( )) != 'q' )
    {
      switch( c )
	{
	case KEY_PPAGE:
  	case 'u': make_screen( PAGE_UP );
	          refresh( );
	          break;
	case KEY_NPAGE:
  	case 'd': make_screen( PAGE_DN );
	          refresh( );
	          break;
	case KEY_DOWN:
	case 'j': 
	          if ( curr_pos < screen_height )
                   {
		     curr_pos++;
		     make_screen( INPAGE_DN );
		   }
	          else
		    make_screen( SCROLL_DN );
	          refresh( );
	          break;
	case KEY_UP:
	case 'k':
	          if ( curr_pos > 0 )
		    {
		      curr_pos--;
		      make_screen( INPAGE_UP );
		    }
	          else
		    make_screen( SCROLL_UP );
	          refresh( );
	          break;
	case KEY_ENTER:
	case 10:
                  if ( ( output = fopen( myconfig.store_path, "a" ) ) == NULL )
                    {
                      fprintf( stderr, "cannot open output file!\n" );
                      fprintf( stderr, "file %s\n", myconfig.store_path );
		      exit( -1 );
                    }
	          help = line;
	          c = 0;
	          while( (c++ < curr_pos) && (line->next != NULL) )
		    line = line->next;
	          add_name( output );
	          line = help;
	          make_screen( UPDATE );
                  fclose( output );
	          break;
	case 'm': /* Input magic */
	          if ( ( output = fopen( myconfig.store_path, "a" ) ) == NULL )
		    {
		      fprintf( stderr,"cannot open output file!\n" );
		      fprintf( stderr,"file %s\n", myconfig.store_path );
		      exit( -1 );
		    }
	          strcpy( tmp, get_magic( myscreen, "Magic" ) );
	          fputs( tmp, output ); 
	          fclose( output );
	          make_screen( UPDATE );
	          refresh( );
	          raw( );
	          break;
        case 's':
	          strcpy( pattern, get_magic( myscreen, "Search String" ) );
		  last_search = line->position;
	          if (search( pattern) == -1 )
		    dialog( myscreen, "Search string not found" );
		  make_screen( UPDATE );
		  refresh();
		  raw();
		  break;
	case 'n':
	          
	          if (search( pattern) == -1 )
		    dialog( myscreen, "Search string not found" );
	          make_screen( UPDATE );
	          refresh();
	          raw();
	          break;
        case KEY_END:
	case 'b':
	          while ( (line->next) != NULL )
		    line = line->next;
	          make_screen( UPDATE );
	          refresh();
	          break;
	case KEY_HOME:
	case 't':
	          while( (line->prev) != NULL )
		    line = line->prev;
	          make_screen( UPDATE );
	          refresh();
	          break;
 	}
    }

  curs_set(1);
  endwin( );

  fprintf( stdout, "bye\n" );
}






