/*
 * Open a window to prompt for a path name to be used for the data logging
 * feature.  Also turns on the data logging.
 */

#include <stdio.h>
#include <curses.h>
#include "misc.h"
#include "param.h"
#include "status.h"

void
data_logging()
{
	extern int fd;
	WINDOW *dl_win, *newwin();
	char *ans, *path, *expand(), *get_str(), *str_rep();
	void log_toggle();

	dl_win = newwin(6, 70, 5, 5);

	mvwprintw(dl_win, 2, 4, "Default log file: %s", param->logfile);
	mvwaddstr(dl_win, 3, 4, "New log file: ");
	box(dl_win, VERT, HORZ);

	mvwattrstr(dl_win, 0, 3, A_BOLD, " Start Data Logging ");
	wmove(dl_win, 3, 18);
	wrefresh(dl_win);
					/* get the path */
	while ((ans = get_str(dl_win, 128, "", " \t\n")) != NULL) {
					/* give 'em the default */
		if (*ans == '\0')
			path = param->logfile;
		else
			path = expand(ans);

					/* test write permission */
		if (can_write(path)) {
			status->log_path = str_rep(status->log_path, path);
			/* 
			 * If already on, then cycle it off to close
			 * the old (and perhaps different) logfile.
			 */
			if (status->log_status)
				log_toggle();
			log_toggle();
			break;
		}

		beep();
		mvwattrstr(dl_win, 4, 24, A_BOLD, "No write permission");
		wrefresh(dl_win);
		wait_key(dl_win, 3);
					/* clean up the mess */
		clear_line(dl_win, 3, 18, TRUE);
		clear_line(dl_win, 4, 24, TRUE);
		wmove(dl_win, 3, 18);
		wrefresh(dl_win);
	}
	if (fd == -1) {
		werase(dl_win);
		wrefresh(dl_win);
	}
	delwin(dl_win);

	return;
}
