:
: what version of UUCP do you have?
if [ -f /usr/lib/uucp/Systems -o -f /etc/uucp/Systems ] ;then
	echo "You've got the HoneyDanBer (HDB) version of UUCP"
	echo "Therefore you need:	#define ASCII_PID"
else
	if [ -f /usr/lib/uucp/L.sys ] ;then
		echo "You've got the older version of UUCP (not HDB)"
		echo "Therefore you need:	#undef ASCII_PID"
	else
		echo "Can't determine the UUCP version"
	fi
fi
:
: check the location of the UUCP lock files
if [ -d /usr/spool/locks ] ;then
	echo "Your UUCP lock files go in /usr/spool/locks"
	echo "Therefore you need:	#define LOCK_FILE \"/usr/spool/locks\""
else
	if [ -d /usr/spool/uucp/LCK ]; then
		echo "Your UUCP lock files go in /usr/spool/uucp/LCK"
		echo "Therefore you need:	#define LOCK_FILE \"/usr/spool/uucp/LCK\""
	else
		echo "Your UUCP lock files go in /usr/spool/uucp"
		echo "Therefore you need:	#define LOCK_FILE \"/usr/spool/uucp\""
	fi
fi
:
: check the version of curses
GOT_IT=0
if [ -f /usr/5include/curses.h ] ;then
	GOT_IT=/usr/5include/curses.h
	echo "You've got a System 5 compatibility library... use it!"
	echo "Edit the Makefile:	CC=/usr/5bin/cc and LD=/usr/5bin/cc"
else
	if [ -f /usr/include/curses.h ] ;then
		GOT_IT=/usr/include/curses.h
	else
		echo "Can't determine your version of curses"
	fi
fi
if [ "$GOT_IT" -eq 0 ] ;then
	if [ `grep -c ACS_HLINE $GOT_IT` -gt 0 ] ;then
		echo "You've got the newer version of curses"
		echo "Therefore you need:	#undef OLDCURSES"
	else
		echo "You've got and old version of curses"
		echo "Therefore you need:	#define OLDCURSES"
	fi
fi
:
: check the libraries
echo checking your C library....
if [ -f /usr/5lib/libc.a ] ;then
	ar t /usr/5lib/libc.a > /tmp/config.$$
else
	if [ -f /usr/lib/libc.a ] ;then
		ar t /usr/lib/libc.a > /tmp/config.$$
	else
		if [ -f /lib/libc.a ] ;then
			ar t /lib/libc.a > /tmp/config.$$
		else
			if [ -f /usr/ccs/lib/libc.a ] ;then
				ar t /usr/ccs/lib/libc.a > /tmp/config.$$
			fi
		fi
	fi
fi
if [ -f /tmp/config.$$ ] ;then
	if [ `grep -c "^poll.o" /tmp/config.$$` -eq 1 ] ;then
		echo "You've got the poll() function"
		echo "Edit the Makefile:	IPC.O=ipc_att.o and IPC.C=ipc_att.c"
	else
		if [ `grep -c "^select.o" /tmp/config.$$` -eq 1 ] ;then
			echo "You've got the select() function"
			echo "Edit the Makefile:	IPC.O=ipc_ucb.o and IPC.C=ipc_ucb.c"
		else
			echo "You don't seem to have either poll() or select()"
			echo "Perhaps they are in another library?"
		fi
	fi
	if [ `grep -c "^usleep.o" /tmp/config.$$` -eq 1 ] ;then
		echo "You've got the usleep() function"
		echo "Therefore you need:	#define HAVE_USLEEP"
	else
		echo "You don't have the usleep() function"
		echo "Therefore you need:	#undef HAVE_USLEEP"
	fi
	if [ `grep -c "^strstr.o" /tmp/config.$$` -eq 1 ] ;then
		echo "You've got the strstr() function"
		echo "Therefore you need:	#define HAVE_STRSTR"
	else
		echo "You don't have the strstr() function"
		echo "Therefore you need:	#undef HAVE_STRSTR"
	fi
	if [ `grep -c "^memmove.o" /tmp/config.$$` -eq 1 ] ;then
		echo "You've got the memmove() function"
		echo "Therefore you need:	#define MEMMOVE(a,b,c) memmove(a,b,c)"
	else
		if [ `grep -c "^memcpy.o" /tmp/config.$$` -eq 1 ] ;then
			echo "You've got the memcpy() function"
			echo "Therefore you need:	#define MEMMOVE(a,b,c) memcpy(a,b,c)"
		else
			if [ `grep -c "^bcopy.o" /tmp/config.$$` -eq 1 ] ;then
				echo "You've got the bcopy() function"
				echo "Therefore you need:	#define MEMMOVE(a,b,c) bcopy(b,a,c)"
			fi
		fi
	fi
	if [ `grep -c "^truncate.o" /tmp/config.$$` -eq 1 ] ;then
		echo "You've got the truncate() function"
		echo "Therefore you need:	#define HAVE_TRUNCATE"
	else
		echo "You don't have the truncate() function"
		echo "Therefore you need:	#undef HAVE_TRUNCATE"
	fi
	rm /tmp/config.$$
else
	echo "Can't determine your C functions"
fi
