/*	pager.  A little program to page someone.
 *			This program forces the modem to 2400 baud, and dials
 *			a pager string.
 *	usage:	pager -n <pager string> tty
 *	ie:		pager -n 780-2539,,,24242424# /dev/ttySb
 *			This will page someone with the number 24242424.
 *	
 *	Version: 1.0
 *	
 *	Author: mswanson@globalx.net (Mark Swanson)
 *		Copyright 1995 Global-X-Change Communications Inc.
 *
 *	Modified:
 *		No one yet :-)
 *
 *      This program is free software; you can redistribute it
 *      and/or  modify it under  the terms of  the GNU General
 *      Public  License as  published  by  the  Free  Software
 *      Foundation;  either  version 2 of the License, or  (at
 *      your option) any later version.
 *
 */


#include <termios.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>


static int chan = -1;
static int lock = -1;
struct termios t,t_old;
char path[128];

int init (void) 
{
	int speed;
	pid_t mypid;
	FILE *fd = (FILE *)0;

	chan = open(path, O_RDWR|O_NOCTTY, O_SYNC);
	if (chan == -1) return (-1);

	lock=open ("/usr/spool/uucp/LCK..ttySb", O_RDWR | O_CREAT);
	if (lock == -1) {
		printf("Failed opening LCK file.\n");
		return (-1);
	}

	mypid = getpid();
	write (lock, &mypid, sizeof(mypid));

	if (tcgetattr(chan, &t) != 0) return (-1);
	if (tcgetattr(chan, &t_old) != 0) return (-1);
	t.c_cc[VMIN] = 1;
	t.c_cc[VTIME] = 0;

	t.c_iflag &= ~(BRKINT | IGNPAR | PARMRK | INPCK | ISTRIP |
	INLCR | IGNCR | ICRNL | IXON);
	t.c_iflag = (IGNBRK | IGNPAR);

	t.c_oflag = (0);
	t.c_lflag = (0);
	

	speed = (t.c_cflag & CBAUD);
	t.c_cflag = (HUPCL|CLOCAL|CREAD);

	t.c_cflag &= ~CSTOPB;
	t.c_cflag |= CS8;
	t.c_cflag &= ~(PARENB | PARODD);
	t.c_cflag |= speed;

	if (cfsetispeed(&t, B2400) == -1) return (-1);
	if (cfsetospeed(&t, B2400) == -1) return (-1);

	if (tcflush(chan, TCIFLUSH) == -1) return (-1);
	if (tcsetattr(chan,TCSANOW, &t) == -1) return (-1);

	return (0);
}

void quit(void)
{
	unlink("/usr/spool/uucp/LCK..ttySb");
	tcsetattr(chan, TCSANOW, &t_old);
	exit (0);
}

void usage(void)
{
	fprintf(stderr,
		"Usage: pager -n <number sequence> tty\n");
	exit(1);
}

int main(int argc, char *argv[])
{
	char num[128];
	char *number;
	int s;

	strcpy(path,"");
	opterr = 0;
	while ((s = getopt(argc, argv, "n:")) != EOF) switch(s) {
		case 'n':
			number=optarg;
			break;
		default:
			usage();
	}
	if (optind != (argc -1)) usage();
	strncpy(path,argv[optind],128);

	sprintf(num,"atdt %s\r",number);

	if (init() == -1) {
		puts("\nRats, init modem failed..\n");
		exit(-1);
	}

	sleep (1);
	if (write(chan, num, strlen(num)) != 1);
	/* Since write returns right away, I need to wait for the modem */
	/* to let me know when it's done.  Need to find out what it returns.. */
	/* Ahh, in the next version :-) */
	sleep (15);
	quit();
}

