/* CHK=0xD254 */
/*+-------------------------------------------------------------------------
    naptest2.c - nap test suite
    wht@n4hgf.Mt-Park.GA.US

This test checks a number of nap features.

1.  Does nap correctly nap a reasonable interval of time over
    a range of selected periods?
2.  Does nap correctly return the period of time it napped?
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:09-03-1991-21:04-wht@n4hgf-make part of suite */
/*:06-26-1988-14:05-wht-creation */

#include <stdio.h>
#include <sys/param.h>

/*+-------------------------------------------------------------------------
    nap_test(period) - make repeated nap test for 'period'
--------------------------------------------------------------------------*/
void
nap_test(period)
long period;
{
int itmp,zero_nap_count = 0;
long total = 0L,msec,then,now,nap();
char s64[64],*ctime();
#define CNT 500

	printf("testing nap(%ldL) should take about %.2lf sec\n",
		period,(double)period * CNT / 1000.0);
	time(&then);
	printf("  started at %s",ctime(&then));
	itmp = CNT;
    while(itmp--)
    {
        msec = nap(period);
        total += msec;
        if(!msec)
            zero_nap_count++;
    }
	time(&now);
	strcpy(s64,ctime(&now));
	s64[strlen(s64) - 1] = 0;
	printf("  ended   at %s  (%ld secs)\n",s64,now - then);
    printf("  average nap return value = %.2lf msec\n",(double)total / CNT);
    printf("  reported zero length nap %d out of %d times\n\n",
        zero_nap_count,CNT);

}   /* end of nap_test */

/*+-------------------------------------------------------------------------
    main(argc,argv,envp)
--------------------------------------------------------------------------*/
main(argc,argv,envp)
int argc;
char    **argv;
char    **envp;
{
    int hz;
    long hzmsec;

	setbuf(stdout,NULL);

/*
 * learn tick rate for various timers
 */
    if(getenv("HZ"))
        hz = atoi(getenv("HZ"));
    else
        hz = HZ;
    hzmsec = (1000 / hz) + 1; /* prevent damaged nap from not napping */

    nap_test(5L);       /* this never naps at all unless accidental
                         * scheduling causes a delay
                         */

    nap_test(hzmsec);
    nap_test(50L);
    exit(0);

}   /* end of main */

/* vi: set tabstop=4 shiftwidth=4: */
