/*+-------------------------------------------------------------------------
	proc.h
	wht@n4hgf.Mt-Park.GA.US
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:03-27-1992-16:21-wht@n4hgf-re-include protection for all .h files */
/*:11-16-1991-14:00-wht@n4hgf-add upon_dcdloss */
/*:07-25-1991-12:59-wht@n4hgf-ECU release 3.10 */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#ifndef _proc_h
#define _proc_h

typedef struct lcb_type
{
	ESD *text;				/* line's text buffer */
	struct lcb_type *next;	/* next lcb in chain; if NULL, no more in chain */
	struct lcb_type *prev;	/* previous lcb in chain; if NULL, top of chain */
	ushort lineno;			/* line number */
} LCB;

typedef struct pcb_type
{
	int argc;
	char **argv;
	LCB *first;			/* first in procedure */
	LCB *last;			/* last in procedure */
	LCB *current;		/* currently executing or last executed line */
	ESD upon_dcdloss;	/* pseudo-ESD to execute as
						 * a statement upon DCD loss
						 */
	char *mkvs_last;	/* actually MKV *, but ... */
	char *mkvi_last;	/* ... see var.c for details */
} PCB;

#define MAX_PARGV 20	/* max args to procedure, including name */
#define PROC_STACK_MAX	10	/* max proc nest */

#endif /* _proc_h */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of proc.h */
