/*+-------------------------------------------------------------------------
	pcmdwhile.c - ecu while procedure commands
	wht@n4hgf.Mt-Park.GA.US

    WHILEI $i0 rel-op $i1 cmd
    WHILES $s0 rel-op $s1 cmd

    where rel-op is "=", "==", "!=", "<>", ">", "<", ">=", "=<"

  Defined functions:
	pcmd_whilei(param)
	pcmd_whiles(param)

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-14:00-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:39-wht@n4hgf-ECU release 3.20 BETA */
/*:07-25-1991-12:59-wht@n4hgf-ECU release 3.10 */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include <ctype.h>
#include "ecu.h"
#include "ecuerror.h"
#include "esd.h"
#include "var.h"
#include "proc.h"
#include "relop.h"

extern PCB *pcb_stack[];

/*+-------------------------------------------------------------------------
    pcmd_whilei(param)
--------------------------------------------------------------------------*/
int
pcmd_whilei(param)
ESD *param;
{
register erc;
int truth;
PCB *pcb;
LCB *condition_lcb;
int condition_index = param->index;

	if(!proc_level)
		return(eNotExecutingProc);

	pcb = pcb_stack[proc_level - 1];
	condition_lcb = pcb->current;

REPEAT_WHILE:

	if(erc = get_truth_int(param,&truth))
		return(erc);

/* if end of command, execute frame */
	if(end_of_cmd(param))
	{
		if(erc = execute_frame(truth))
		{
			if(erc == eContinueCommand)
				goto CONTINUE;
			if(erc == eBreakCommand)
				erc = 0;
			return(erc);
		}
	}
	else if(truth)
	{
		if(erc = execute_esd(param))
			return(erc);
	}

/* repeat if indicated */
CONTINUE:
	if(truth)
	{
		pcb->current = condition_lcb;
		param->index = param->old_index = condition_index;
		goto REPEAT_WHILE;
	}

	return(0);
}   /* end of pcmd_whilei */

/*+-------------------------------------------------------------------------
    pcmd_whiles(param)
--------------------------------------------------------------------------*/
int
pcmd_whiles(param)
ESD *param;
{
register erc;
int truth;
PCB *pcb;
LCB *condition_lcb;
int condition_index = param->index;

	if(!proc_level)
		return(eNotExecutingProc);

	pcb = pcb_stack[proc_level - 1];
	condition_lcb = pcb->current;

REPEAT_WHILE:

	if(erc = get_truth_str(param,&truth))
		return(erc);

/* if end of command, execute frame */
	if(end_of_cmd(param))
	{
		if(erc = execute_frame(truth))
		{
			if(erc == eContinueCommand)
				goto CONTINUE;
			if(erc == eBreakCommand)
				erc = 0;
			return(erc);
		}
	}
	else if(truth)
	{
		if(erc = execute_esd(param))
			return(erc);
	}

/* repeat if indicated */
CONTINUE:
	if(truth)
	{
		pcb->current = condition_lcb;
		param->index = param->old_index = condition_index;
		goto REPEAT_WHILE;
	}

	return(0);
}   /* end of pcmd_whiles */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of pcmdwhile.c */
